/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductQuery;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import retrofit2.Response;

public class ProductListRequest
extends BaseCloudRequest {
    private static final String a = ProductListRequest.class.getSimpleName();
    private ProductQuery b;
    private ProductResult<Product> c;
    private volatile boolean d;
    private volatile boolean e;

    public ProductListRequest(CloudManager cloudManager, ProductQuery query, boolean clear, boolean cloud) {
        super(cloudManager);
        this.b = query;
        this.d = clear;
        this.e = cloud;
    }

    public final ProductResult<Product> getProductResult() {
        return this.c;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        } else if (!this.e) {
            this.fetchFromLocalCache(parent);
        }
    }

    public void fetchFromLocalCache(CloudManager parent) throws Exception {
        this.c = new ProductResult();
        this.c.list = StoreUtils.queryDataList(Product.class);
        this.c.count = this.c.list.size();
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        String string2 = JSON.toJSONString((Object)this.b);
        Response<ProductResult<Product>> response = this.executeCall(ServiceFactory.getBookStoreService(parent.getCloudConf().getApiBase()).bookList(string2));
        if (response.isSuccessful()) {
            this.c = (ProductResult)response.body();
            if (this.isSaveToLocal()) {
                this.a(this.c);
            }
        }
    }

    private void a(ProductResult<Product> productResult) {
        StoreUtils.saveToLocal(productResult, Product.class, this.d);
    }
}

