/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.Context;
import android.net.Uri;
import com.onyx.android.sdk.data.db.table.OnyxSystemConfigProvider;
import com.onyx.android.sdk.data.model.v2.SystemKeyValueItem;
import com.onyx.android.sdk.data.model.v2.SystemKeyValueItem_Table;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;

public class SystemConfigProvider {
    public static final int INT_INVALID = -1;
    public static final String KEY_CONTENT_SERVER_INFO = "sys.content_server_info";
    public static final String KEY_APP_PREFERENCE = "sys.app_preference";
    public static final String KEY_STORAGE_FOLDER_SHORTCUT_LIST = "sys.storage_shortcut_list";

    public static String getStringValue(Context context, String key) {
        SystemKeyValueItem systemKeyValueItem = SystemConfigProvider.queryKeyValueItem(context, key);
        return systemKeyValueItem == null ? null : systemKeyValueItem.value;
    }

    public static boolean setStringValue(Context context, String key, String value) {
        return SystemConfigProvider.addKeyValueItem(context, SystemKeyValueItem.create(key, value));
    }

    public static boolean setIntValue(Context context, String key, int value) {
        return SystemConfigProvider.setStringValue(context, key, String.valueOf(value));
    }

    public static int getIntValue(Context context, String key) {
        String string = SystemConfigProvider.getStringValue(context, key);
        if (string == null) {
            return -1;
        }
        return SystemConfigProvider.a(string);
    }

    public static boolean getBooleanValue(Context context, String key) {
        String string = SystemConfigProvider.getStringValue(context, key);
        if (string == null) {
            return false;
        }
        return SystemConfigProvider.c(string);
    }

    public static boolean setBooleanValue(Context context, String key, boolean value) {
        return SystemConfigProvider.setStringValue(context, key, String.valueOf(value));
    }

    public static SystemKeyValueItem queryKeyValueItem(Context context, String key) {
        try {
            return (SystemKeyValueItem)((Object)ContentUtils.querySingle((Uri)OnyxSystemConfigProvider.CONTENT_URI, SystemKeyValueItem.class, (OperatorGroup)OperatorGroup.clause().and((SQLOperator)SystemKeyValueItem_Table.key.eq((Object)key)), null, (String[])new String[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean addKeyValueItem(Context context, SystemKeyValueItem item) {
        item.beforeSave();
        SystemKeyValueItem systemKeyValueItem = SystemConfigProvider.queryKeyValueItem(context, item.key);
        long l = 0L;
        if (systemKeyValueItem == null || !systemKeyValueItem.hasValidId()) {
            Uri uri = ContentUtils.insert((Uri)OnyxSystemConfigProvider.CONTENT_URI, (Object)((Object)item));
            l = uri == null || StringUtils.isNullOrEmpty((String)uri.getLastPathSegment()) ? -1L : SystemConfigProvider.b(uri.getLastPathSegment());
        } else {
            item.setId(systemKeyValueItem.getId());
            l = ContentUtils.update((Uri)OnyxSystemConfigProvider.CONTENT_URI, (Object)((Object)item));
        }
        if (l > 0L) {
            item.setId(l);
        }
        return l > 0L;
    }

    public static boolean delete(Context context, SystemKeyValueItem item) {
        int n = ContentUtils.delete((Uri)OnyxSystemConfigProvider.CONTENT_URI, (Object)((Object)item));
        return n > 0;
    }

    private static int a(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static long b(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static boolean c(String string) {
        try {
            return Boolean.parseBoolean(string);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

