/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.LibraryDataModel;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryPagination;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.ViewType;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.utils.QueryBuilder;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LibraryViewInfo
implements Serializable {
    private int a = 9;
    private QueryArgs b;
    private QueryPagination c = QueryPagination.create(3, 3);
    private LibraryDataModel d = new LibraryDataModel();
    private List<Library> e = new ArrayList<Library>();
    private ViewType f = ViewType.Thumbnail;

    public LibraryViewInfo() {
        this.b = new QueryArgs();
        this.b.limit = this.a;
        this.c.setCurrentPage(0);
    }

    public static LibraryViewInfo create(int rows, int cols) {
        return new LibraryViewInfo(rows, cols, SortBy.Name, SortOrder.Asc);
    }

    public LibraryViewInfo(int row, int col, SortBy sortBy, SortOrder sortOrder) {
        this();
        this.b.limit = this.a = row * col;
        this.c.resize(row, col, 0);
        this.c.setCurrentPage(0);
        this.updateSortBy(sortBy, sortOrder);
    }

    public int getOffset(int currentPage) {
        LibraryDataModel libraryDataModel = this.getLibraryDataModel();
        int n = this.c.itemsPerPage();
        int n2 = currentPage * n - libraryDataModel.libraryCount;
        if (n2 < 0) {
            n2 = currentPage <= libraryDataModel.libraryCount / n ? 0 : n + n2;
        }
        return n2;
    }

    public int getOffset() {
        return this.getOffset(this.c.getCurrentPage());
    }

    public QueryArgs nextPage() {
        this.b.offset = this.getOffset();
        return this.b;
    }

    public QueryArgs prevPage() {
        this.b.offset = this.getOffset();
        return this.b;
    }

    public QueryArgs pageQueryArgs(int page) {
        QueryArgs queryArgs = this.b.copyPart();
        queryArgs.offset = this.getOffset(page);
        return queryArgs;
    }

    public QueryArgs gotoPage(int page) {
        this.c.setCurrentPage(page);
        this.b.offset = this.getOffset(page);
        return this.b;
    }

    public QueryArgs firstPage() {
        return this.gotoPage(0);
    }

    public QueryArgs lastPage() {
        return this.gotoPage(this.c.lastPage());
    }

    public String getSdcardCid() {
        return EnvironmentUtil.getRemovableSDCardCid();
    }

    private OperatorGroup a() {
        OperatorGroup operatorGroup = OperatorGroup.clause().or((SQLOperator)Metadata_Table.storageId.isNull());
        String string = this.getSdcardCid();
        if (StringUtils.isNotBlank((String)string)) {
            operatorGroup.or((SQLOperator)Metadata_Table.storageId.is((Object)string));
        }
        return operatorGroup;
    }

    public QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public QueryArgs generateQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public QueryArgs libraryQuery(int limit, int offset) {
        QueryArgs queryArgs = this.libraryQuery(this.getLibraryIdString());
        queryArgs.limit = limit;
        queryArgs.offset = offset;
        return queryArgs;
    }

    public QueryArgs libraryQuery(String libraryId) {
        QueryArgs queryArgs = this.buildLibraryQuery(libraryId);
        this.updateQueryArgs(queryArgs);
        return queryArgs;
    }

    public QueryArgs buildLibraryQuery(String libraryId) {
        QueryArgs queryArgs = new QueryArgs(this.b.sortBy, this.b.order).appendFilter(this.b.filter);
        queryArgs.limit = this.a;
        queryArgs.offset = 0;
        queryArgs.libraryUniqueId = libraryId;
        this.generateQueryArgs(queryArgs);
        QueryBuilder.andWith(queryArgs.conditionGroup, this.a());
        return this.generateMetadataInQueryArgs(queryArgs);
    }

    public QueryArgs libraryQuery() {
        return this.libraryQuery(this.b.limit, 0);
    }

    public QueryArgs getCurrentQueryArgs() {
        return this.b;
    }

    public void updateQueryArgs(QueryArgs args) {
        this.b = args;
    }

    public LibraryDataModel getLibraryDataModel() {
        return this.d;
    }

    public void setLibraryDataModel(LibraryDataModel libraryDataModel) {
        this.clearThumbnailMap(this.getLibraryDataModel());
        this.d = libraryDataModel;
    }

    public LibraryDataModel getPageLibraryDataModel(LibraryDataModel dataModel) {
        this.setLibraryDataModel(dataModel);
        LibraryDataModel libraryDataModel = new LibraryDataModel();
        int n = this.c.getCurrentPage();
        int n2 = this.c.itemsPerPage();
        if (n > this.d.libraryCount / n2) {
            libraryDataModel.visibleLibraryList = new ArrayList<Library>();
            libraryDataModel.visibleBookList = this.d.visibleBookList;
        } else {
            int n3;
            int n4;
            for (n4 = n3 = n * n2; n4 < this.d.libraryCount && n4 < (n + 1) * n2; ++n4) {
                libraryDataModel.visibleLibraryList.add(this.d.visibleLibraryList.get(n4));
            }
            n4 = n2 - CollectionUtils.getSize(libraryDataModel.visibleLibraryList);
            for (int i = 0; i < n4 && i < CollectionUtils.getSize(this.d.visibleBookList); ++i) {
                libraryDataModel.visibleBookList.add(this.d.visibleBookList.get(i));
            }
        }
        libraryDataModel.bookCount = this.d.bookCount;
        libraryDataModel.libraryCount = this.d.libraryCount;
        libraryDataModel.thumbnailMap = this.d.thumbnailMap;
        libraryDataModel.notificationMap = this.d.notificationMap;
        return libraryDataModel;
    }

    public QueryPagination getQueryPagination() {
        return this.c;
    }

    public void setQueryPagination(QueryPagination queryPagination) {
        this.c = queryPagination;
    }

    public String getLibraryIdString() {
        if (CollectionUtils.isNullOrEmpty(this.e)) {
            return null;
        }
        return this.e.get(this.e.size() - 1).getIdString();
    }

    public List<Library> getLibraryPathList() {
        return this.e;
    }

    public void setLibraryPathList(List<Library> newPathList) {
        this.e = newPathList;
    }

    public void setCurrentSortOrder(SortOrder sortOrder) {
        this.b.order = sortOrder;
    }

    public SortOrder getCurrentSortOrder() {
        return this.b.order;
    }

    public SortBy getCurrentSortBy() {
        return this.b.sortBy;
    }

    public void updateSortBy(SortBy sortBy, SortOrder sortOrder) {
        this.b.sortBy = sortBy;
        this.b.order = sortOrder;
    }

    public void updateSortBy(SortBy sortBy, SortOrder sortOrder, int page) {
        this.updateSortBy(sortBy, sortOrder);
        this.getQueryPagination().setCurrentPage(page);
    }

    public void updateFilterBy(BookFilter filter, SortOrder sortOrder) {
        this.b.filter = filter;
        this.b.order = sortOrder;
    }

    public void setQueryLimit(int limit) {
        this.b.limit = this.a = limit;
    }

    public int getQueryLimit() {
        return this.a;
    }

    public void resizePagination(int row, int col, int count) {
        this.getQueryPagination().resize(row, col, count);
    }

    public void toggleViewType() {
        this.f = this.f == ViewType.Thumbnail ? ViewType.Details : ViewType.Thumbnail;
    }

    public ViewType getCurrentViewType() {
        return this.f;
    }

    public void setCurrentViewType(ViewType viewType) {
        this.f = viewType;
    }

    public void clearThumbnailMap(LibraryDataModel dataModel) {
        if (dataModel == null || CollectionUtils.isNullOrEmpty(dataModel.thumbnailMap)) {
            return;
        }
        for (CloseableReference<Bitmap> closeableReference : dataModel.thumbnailMap.values()) {
            closeableReference.close();
        }
    }

    public static LibraryDataModel buildLibraryDataModel(QueryResult<Metadata> result, Map<String, CloseableReference<Bitmap>> map) {
        LibraryDataModel libraryDataModel = new LibraryDataModel();
        if (result == null) {
            return libraryDataModel;
        }
        libraryDataModel.visibleLibraryList = new ArrayList<Library>();
        libraryDataModel.visibleBookList = result.list;
        libraryDataModel.bookCount = (int)result.count;
        libraryDataModel.thumbnailMap = map;
        libraryDataModel.libraryCount = 0;
        return libraryDataModel;
    }
}

