/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.cache.BitmapReferenceLruCache;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.db.ContentDatabase;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataManagerHelper {
    private static DataProviderBase a() {
        return DataProviderManager.getLocalDataProvider();
    }

    public static List<Library> loadLibraryList(DataManager dataManager, List<Library> list, String parentId) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.libraryUniqueId = parentId;
        return DataManagerHelper.loadLibraryList(dataManager.getRemoteContentProvider(), list, queryArgs);
    }

    public static List<Library> loadLibraryList(DataProviderBase dataProvider, List<Library> list, QueryArgs args) {
        List<Library> list2 = dataProvider.loadAllLibrary(args.libraryUniqueId, args);
        if (!CollectionUtils.isNullOrEmpty(list2)) {
            list.addAll(list2);
        }
        return list2;
    }

    public static void loadLibraryRecursive(DataProviderBase dataProvider, List<Library> list, QueryArgs args) {
        List<Library> list2 = DataManagerHelper.loadLibraryList(dataProvider, list, args);
        if (CollectionUtils.isNullOrEmpty(list2)) {
            return;
        }
        for (Library library : list2) {
            QueryArgs queryArgs = new QueryArgs();
            queryArgs.libraryUniqueId = library.getIdString();
            queryArgs.fetchPolicy = args.fetchPolicy;
            DataManagerHelper.loadLibraryRecursive(dataProvider, list, queryArgs);
        }
    }

    public static void loadLibraryRecursive(DataManager dataManager, List<Library> list, String targetId) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.libraryUniqueId = targetId;
        queryArgs.fetchPolicy = 1;
        DataManagerHelper.loadLibraryRecursive(dataManager.getRemoteContentProvider(), list, queryArgs);
    }

    @NonNull
    public static Library addLibraryByPath(Context context, DataProviderBase dataProvider, String path, boolean setParentId) {
        Library library = new Library();
        library.setName(FileUtils.getFileName((String)path));
        library.setIdString(path);
        if (setParentId) {
            library.setParentUniqueId(FileUtils.getParent((String)path));
        }
        if (EnvironmentUtil.isFileOnRemovableSDCard((File)new File(path))) {
            library.setStorageId(EnvironmentUtil.getRemovableSDCardCid());
        }
        dataProvider.addLibrary(library);
        return library;
    }

    public static Thumbnail loadThumbnail(Context context, String path, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        if (StringUtils.isNullOrEmpty((String)associationId)) {
            try {
                associationId = FileUtils.computeMD5((File)new File(path));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return DataManagerHelper.a().getThumbnailEntry(context, associationId, kind);
    }

    public static Bitmap loadThumbnailBitmap(Context context, Thumbnail thumbnail) {
        return DataManagerHelper.a().getThumbnailBitmap(context, thumbnail.getIdString(), OnyxThumbnail.ThumbnailKind.Original);
    }

    public static Metadata getMetadataByCloudReference(Context context, String cloudReference) {
        return (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.cloudId.eq((Object)cloudReference)}).querySingle());
    }

    public static Metadata getMetadataByHashTag(Context context, String hashTag) {
        return (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.hashTag.eq((Object)hashTag)}).querySingle());
    }

    public static void deleteAllLibrary(Context context, DataManager dataManager, String parentUniqueId, List<Library> libraryList) {
        DataManagerHelper.deleteAllLibrary(context, dataManager.getRemoteContentProvider(), parentUniqueId, libraryList);
    }

    public static void deleteAllLibrary(Context context, DataProviderBase providerBase, String parentUniqueId, List<Library> libraryList) {
        boolean bl = StringUtils.isNullOrEmpty((String)parentUniqueId);
        DataManagerHelper.deleteAllLibrary(context, providerBase, parentUniqueId, libraryList, bl);
    }

    public static void deleteAllLibrary(Context context, DataProviderBase providerBase, String parentUniqueId, List<Library> libraryList, boolean isDeleteMetaCollection) {
        for (Library library : libraryList) {
            if (isDeleteMetaCollection) {
                providerBase.deleteMetadataCollection(context, library.getIdString());
            } else {
                List<MetadataCollection> list = providerBase.loadMetadataCollection(context, library.getIdString());
                for (MetadataCollection metadataCollection : list) {
                    metadataCollection.setLibraryUniqueId(parentUniqueId);
                    providerBase.updateMetadataCollection(metadataCollection);
                }
            }
            providerBase.deleteLibrary(library);
        }
    }

    public static void deleteMetadataCollection(Context context, DataManager dataManager, String libraryIdString) {
        dataManager.getRemoteContentProvider().deleteMetadataCollection(context, libraryIdString);
    }

    public static MetadataCollection loadMetadataCollection(Context context, DataManager dataManager, String libraryIdString, String metaIdString) {
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context, libraryIdString, metaIdString);
    }

    public static List<MetadataCollection> loadMetadataCollection(Context context, DataManager dataManager, String libraryIdString) {
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context, libraryIdString);
    }

    public static List<Metadata> loadMetadataListWithCache(Context context, DataManager dataManager, QueryArgs queryArgs, boolean loadFromCache) {
        String string = queryArgs.conditionGroup.getQuery() + queryArgs.libraryUniqueId + queryArgs.getOrderByQueryWithLimitOffset();
        List<Metadata> list = null;
        if (loadFromCache) {
            list = dataManager.getCacheManager().getMetadataLruCache(string);
        }
        if (list == null && !CollectionUtils.isNullOrEmpty(list = dataManager.getRemoteContentProvider().findMetadataByQueryArgs(context, queryArgs))) {
            dataManager.getCacheManager().addToMetadataCache(string, list);
        }
        return list;
    }

    public static List<Library> loadLibraryListWithCache(Context context, DataManager dataManager, String libraryUniqueId, boolean loadFromCache) {
        String string = String.valueOf(libraryUniqueId);
        List<Library> list = null;
        if (loadFromCache) {
            list = dataManager.getCacheManager().getLibraryLruCache(string);
        }
        if (list == null) {
            list = new ArrayList<Library>();
            DataManagerHelper.loadLibraryList(dataManager, list, libraryUniqueId);
            if (!CollectionUtils.isNullOrEmpty(list)) {
                dataManager.getCacheManager().addToLibraryCache(string, list);
            }
        }
        return list;
    }

    public static OnyxThumbnail.ThumbnailKind getDefaultThumbnailKind() {
        return OnyxThumbnail.ThumbnailKind.Large;
    }

    public static Thumbnail getThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId) {
        return dataProvider.getThumbnailEntry(context, associationId, DataManagerHelper.getDefaultThumbnailKind());
    }

    public static String getThumbnailPath(Context context, DataProviderBase dataProvider, String associationId) {
        Thumbnail thumbnail = DataManagerHelper.getThumbnailEntry(context, dataProvider, associationId);
        if (thumbnail == null) {
            return null;
        }
        if (!FileUtils.fileExist((String)thumbnail.getImageDataPath())) {
            return null;
        }
        return thumbnail.getImageDataPath();
    }

    public static Map<String, CloseableReference<Bitmap>> loadThumbnailBitmapsWithCache(Context context, DataManager dataManager, List<Metadata> metadataList) {
        HashMap<String, CloseableReference<Bitmap>> hashMap = new HashMap<String, CloseableReference<Bitmap>>();
        for (Metadata metadata : metadataList) {
            CloseableReference<Bitmap> closeableReference = DataManagerHelper.loadThumbnailBitmapWithCache(context, dataManager, metadata);
            if (closeableReference == null) continue;
            hashMap.put(metadata.getAssociationId(), closeableReference);
        }
        return hashMap;
    }

    public static CloseableReference<Bitmap> loadThumbnailBitmapWithCache(Context context, DataManager dataManager, Metadata metadata) {
        BitmapReferenceLruCache bitmapReferenceLruCache = dataManager.getCacheManager().getBitmapLruCache();
        String string = metadata.getAssociationId();
        if (StringUtils.isNullOrEmpty((String)string)) {
            return null;
        }
        CloseableReference closeableReference = (CloseableReference)bitmapReferenceLruCache.get(string);
        if (closeableReference != null) {
            return closeableReference.clone();
        }
        return DataManagerHelper.a(context, dataManager.getRemoteContentProvider(), bitmapReferenceLruCache, string);
    }

    private static CloseableReference<Bitmap> a(File file, BitmapReferenceLruCache bitmapReferenceLruCache, String string) {
        CloseableReference<Bitmap> closeableReference = null;
        try {
            closeableReference = ThumbnailUtils.decodeFile(file);
            if (closeableReference != null && closeableReference.isValid()) {
                bitmapReferenceLruCache.put(string, closeableReference);
                return closeableReference.clone();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return closeableReference;
    }

    private static CloseableReference<Bitmap> a(Context context, DataProviderBase dataProviderBase, BitmapReferenceLruCache bitmapReferenceLruCache, String string) {
        CloseableReference<Bitmap> closeableReference = null;
        String string2 = DataManagerHelper.getThumbnailPath(context, dataProviderBase, string);
        if (StringUtils.isNotBlank((String)string2)) {
            closeableReference = DataManagerHelper.a(new File(string2), bitmapReferenceLruCache, string);
        }
        return closeableReference;
    }

    public static List<Library> loadParentLibraryList(Context context, DataManager dataManager, Library library) {
        Library library2;
        ArrayList<Library> arrayList = new ArrayList<Library>();
        if (library == null || StringUtils.isNullOrEmpty((String)library.getParentUniqueId())) {
            return arrayList;
        }
        String string = library.getParentUniqueId();
        while (StringUtils.isNotBlank((String)string) && (library2 = dataManager.getRemoteContentProvider().loadLibrary(string)) != null) {
            arrayList.add(library2);
            string = library2.getParentUniqueId();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static void updateCloudCacheList(List<Metadata> cacheList, QueryResult<Metadata> result, QueryArgs queryArgs) {
        if (result == null || CollectionUtils.isNullOrEmpty(result.list)) {
            return;
        }
        int n = queryArgs.offset + CollectionUtils.getSize(result.list);
        for (int i = queryArgs.offset; i < n && i < CollectionUtils.getSize(cacheList); ++i) {
            cacheList.set(i, (Metadata)((Object)result.list.get(i - queryArgs.offset)));
        }
    }

    public static QueryResult<Metadata> cloudMetadataFromDataProvider(Context context, DataProviderBase dataProvider, QueryArgs queryArgs) {
        int n = queryArgs.limit;
        queryArgs.limit = queryArgs.getCloudFetchLimit();
        QueryResult<Metadata> queryResult = dataProvider.findMetadataResultByQueryArgs(context, queryArgs);
        queryArgs.limit = n;
        return queryResult;
    }

    public static boolean cloudMetadataFromCache(QueryResult<Metadata> result, QueryArgs queryArgs, List<Metadata> cacheList) {
        result.count = CollectionUtils.getSize(cacheList);
        result.list = new ArrayList();
        boolean bl = true;
        for (int i = queryArgs.offset; i < queryArgs.limit + queryArgs.offset && i < CollectionUtils.getSize(cacheList); ++i) {
            Metadata metadata = cacheList.get(i);
            if (metadata == null) {
                bl = false;
                break;
            }
            result.list.add(metadata);
        }
        return bl;
    }

    private static Map<String, String> a(Metadata metadata, boolean bl) {
        Map<String, String> map = metadata.getBookCovers();
        if (CollectionUtils.isNullOrEmpty(map)) {
            map = new HashMap<String, String>();
            if (bl) {
                for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
                    map.put(thumbnailKind.toString().toLowerCase(), null);
                }
            }
        }
        return map;
    }

    public static Map<String, CloseableReference<Bitmap>> loadCloudThumbnailBitmapsWithCache(Context context, CloudManager cloudManager, List<Metadata> metadataList) {
        HashMap<String, CloseableReference<Bitmap>> hashMap = new HashMap<String, CloseableReference<Bitmap>>();
        for (Metadata metadata : metadataList) {
            Map<String, String> map = DataManagerHelper.a(metadata, true);
            for (String string : map.keySet()) {
                String string2 = CacheManager.generateCloudThumbnailKey(metadata.getAssociationId(), map.get(string), string);
                CloseableReference<Bitmap> closeableReference = DataManagerHelper.loadCloudThumbnailBitmapWithCache(context, cloudManager, string2);
                if (closeableReference == null) continue;
                hashMap.put(string2, closeableReference);
            }
        }
        return hashMap;
    }

    public static CloseableReference<Bitmap> loadCloudThumbnailBitmapWithCache(Context context, CloudManager cloudManager, String key) {
        BitmapReferenceLruCache bitmapReferenceLruCache = cloudManager.getCacheManager().getBitmapLruCache();
        if (StringUtils.isNullOrEmpty((String)key)) {
            return null;
        }
        CloseableReference closeableReference = (CloseableReference)bitmapReferenceLruCache.get(key);
        if (closeableReference != null) {
            return closeableReference.clone();
        }
        return null;
    }

    public static void saveCloudCollection(Context context, DataProviderBase dataProvider, String libraryId, String associationId) {
        CloudMetadataCollection cloudMetadataCollection = new CloudMetadataCollection();
        cloudMetadataCollection.setDocumentUniqueId(associationId);
        cloudMetadataCollection.setLibraryUniqueId(libraryId);
        DataManagerHelper.saveCollection(context, dataProvider, cloudMetadataCollection);
    }

    public static void saveCollection(Context context, DataProviderBase dataProvider, MetadataCollection collection) {
        MetadataCollection metadataCollection = dataProvider.loadMetadataCollection(context, collection.getLibraryUniqueId(), collection.getDocumentUniqueId());
        if (metadataCollection == null) {
            if (StringUtils.isNullOrEmpty((String)collection.getLibraryUniqueId())) {
                return;
            }
            dataProvider.addMetadataCollection(context, collection);
        } else if (StringUtils.isNullOrEmpty((String)collection.getLibraryUniqueId())) {
            dataProvider.deleteMetadataCollection(context, collection.getLibraryUniqueId(), collection.getDocumentUniqueId());
        } else {
            collection.setLibraryUniqueId(collection.getLibraryUniqueId());
            dataProvider.updateMetadataCollection(collection);
        }
    }

    public static void saveCloudMetadataAndCollection(Context context, DataProviderBase dataProvider, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (Metadata metadata : queryResult.list) {
            dataProvider.saveMetadata(context, metadata);
            DataManagerHelper.saveCloudCollection(context, dataProvider, queryArgs.libraryUniqueId, metadata.getAssociationId());
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMetadataCollection(Context context, DataProviderBase dataProvider, String libraryId, Collection<Metadata> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase(ContentDatabase.class).getWritableDatabase();
        databaseWrapper.beginTransaction();
        try {
            for (Metadata metadata : list) {
                DataManagerHelper.saveCollection(context, dataProvider, MetadataCollection.create(metadata.getIdString(), libraryId));
            }
            databaseWrapper.setTransactionSuccessful();
        }
        finally {
            databaseWrapper.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMetadata(Context context, DataProviderBase dataProvider, Collection<Metadata> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase(ContentDatabase.class).getWritableDatabase();
        databaseWrapper.beginTransaction();
        try {
            for (Metadata metadata : list) {
                dataProvider.saveMetadata(context, metadata);
            }
            databaseWrapper.setTransactionSuccessful();
        }
        finally {
            databaseWrapper.endTransaction();
        }
    }

    public static List<Library> fetchLibraryLibraryList(Context context, DataProviderBase dataProvider, QueryArgs queryArgs) {
        List<Library> list = dataProvider.loadAllLibrary(queryArgs.libraryUniqueId, queryArgs);
        if (!FetchPolicy.isDataFromMemDb(queryArgs.fetchPolicy, NetworkUtil.isWiFiConnected((Context)context))) {
            DataManagerHelper.saveLibraryListToLocal(dataProvider, list);
        }
        return list;
    }

    public static void saveLibraryListToLocal(DataProviderBase dataProvider, List<Library> libraryList) {
        if (CollectionUtils.isNullOrEmpty(libraryList)) {
            return;
        }
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (Library library : libraryList) {
            dataProvider.addLibrary(library);
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteLibraryWithRecursive(DataProviderBase dataProviderBase, QueryArgs queryArgs, boolean recursive) {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        if (recursive) {
            DataManagerHelper.loadLibraryRecursive(dataProviderBase, arrayList, queryArgs);
        } else {
            DataManagerHelper.loadLibraryList(dataProviderBase, arrayList, queryArgs);
        }
        for (Library library : arrayList) {
            dataProviderBase.deleteLibrary(library);
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void clearLibrary(DataProviderBase dataProvider) {
        dataProvider.clearLibrary();
    }

    public static OperatorGroup getPropertyOrCondition(List<String> valueList, Property<String> property) {
        if (CollectionUtils.isNullOrEmpty(valueList)) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string : valueList) {
            operatorGroup.or((SQLOperator)property.eq((Object)string));
        }
        return operatorGroup;
    }
}

