/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.cache.BitmapReferenceLruCache;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudUtils;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.io.File;
import java.io.IOException;

public class CloudThumbnailLoadRequest
extends BaseCloudRequest {
    private static final String a = CloudThumbnailLoadRequest.class.getSimpleName();
    private String b;
    private String c;
    private OnyxThumbnail.ThumbnailKind d = OnyxThumbnail.ThumbnailKind.Large;
    private CloseableReference<Bitmap> e;
    private int f = Integer.MIN_VALUE;
    private int g = Integer.MIN_VALUE;

    public CloudThumbnailLoadRequest(CloudManager cloudManager, String coverUrl, String associateId) {
        super(cloudManager);
        this.b = coverUrl;
        this.c = associateId;
    }

    public CloudThumbnailLoadRequest(CloudManager cloudManager, String coverUrl, String associateId, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        this(cloudManager, coverUrl, associateId);
        this.d = thumbnailKind;
    }

    public void setReqWidthHeight(int[] widthHeight) {
        this.f = widthHeight[0];
        this.g = widthHeight[1];
    }

    public CloseableReference<Bitmap> getRefBitmap() {
        if (!this.a(this.e)) {
            return null;
        }
        return this.e.clone();
    }

    private boolean a(CloseableReference<Bitmap> closeableReference) {
        return closeableReference != null && closeableReference.isValid();
    }

    private boolean a(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.c)) {
            return;
        }
        if (this.b(cloudManager) || this.isAbort()) {
            return;
        }
        if (this.e(cloudManager) || this.isAbort()) {
            return;
        }
        if (this.c(cloudManager) || this.isAbort()) {
            return;
        }
        this.d(cloudManager);
    }

    private void a(CloudManager cloudManager) {
        cloudManager.getCacheManager().getBitmapLruCache().put(this.b(), this.e);
    }

    private File a() {
        return CloudUtils.imageCachePath(this.getContext(), this.c, this.d.toString().toLowerCase());
    }

    private boolean b(CloudManager cloudManager) {
        BitmapReferenceLruCache bitmapReferenceLruCache = cloudManager.getCacheManager().getBitmapLruCache();
        this.e = (CloseableReference)bitmapReferenceLruCache.get(this.b());
        return this.a(this.e);
    }

    private boolean c(CloudManager cloudManager) {
        File file = this.a();
        if (file == null) {
            Log.w((String)a, (String)"detect associationId is null");
            return false;
        }
        if (file.exists() && file.length() > 0L && this.a(file)) {
            this.a(cloudManager);
            return true;
        }
        return false;
    }

    private boolean d(CloudManager cloudManager) {
        String string2 = this.a(this.getContext(), cloudManager.getCloudDataProvider(), this.c, this.d);
        if (StringUtils.isNullOrEmpty((String)string2) || !FileUtils.fileExist((String)string2)) {
            return false;
        }
        File file = new File(string2);
        if (file.exists() && this.a(file)) {
            this.a(cloudManager);
            return true;
        }
        return false;
    }

    private boolean e(CloudManager cloudManager) {
        if (!StringUtils.isUrl((String)this.b) || this.isAbort()) {
            return false;
        }
        Bitmap bitmap = this.a(this.b);
        if (!this.a(bitmap) || this.isAbort()) {
            return false;
        }
        File file = this.a();
        if (!this.a(file, bitmap) || this.isAbort()) {
            return false;
        }
        if (this.a(file)) {
            this.a(cloudManager);
        }
        return true;
    }

    private boolean a(File file, Bitmap bitmap) {
        return ThumbnailUtils.writeBitmapToThumbnailFile(file, bitmap);
    }

    private boolean a(File file) {
        boolean bl = true;
        try {
            CloseableReference<Bitmap> closeableReference = ThumbnailUtils.decodeFile(file);
            if (this.a(closeableReference)) {
                this.e = closeableReference.clone();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private Bitmap a(String string2) {
        return this.b(string2);
    }

    private Bitmap b(String string2) {
        try {
            return (Bitmap)Glide.with((Context)this.getContext()).asBitmap().load(string2).submit(this.f, this.g).get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void a(CloudManager cloudManager, File file, Bitmap bitmap) {
        boolean bl = ThumbnailUtils.hasThumbnail(this.getContext(), cloudManager.getCloudDataProvider(), this.c);
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        if (!bl) {
            ThumbnailUtils.insertThumbnail(this.getContext(), cloudManager.getCloudDataProvider(), file.getAbsolutePath(), this.c, this.d, bitmap);
        } else {
            ThumbnailUtils.updateThumbnailEntry(this.getContext(), cloudManager.getCloudDataProvider(), this.c, this.d, bitmap);
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    @Override
    public String getIdentifier() {
        return "cloudThumbnail";
    }

    private String a(Context context, DataProviderBase dataProviderBase, String string2, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        Thumbnail thumbnail = dataProviderBase.getThumbnailEntry(context, string2, thumbnailKind);
        if (thumbnail == null) {
            return null;
        }
        return thumbnail.getImageDataPath();
    }

    private String b() {
        return CacheManager.generateCloudThumbnailKey(this.c, this.b, this.d.toString().toLowerCase());
    }
}

