/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.common.ScreenSaverConfig;
import com.onyx.android.sdk.data.request.common.ScreenSaverRequest;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.rx.RxCallback;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;

public class ScreenSaverManager {
    public static int SCREEN_SAVER_COUNT_LIMIT = 3;
    private static ScreenSaverManager a;
    private ScreenSaverConfig b;

    private ScreenSaverManager() {
    }

    public static ScreenSaverManager init(ScreenSaverConfig config) {
        a = new ScreenSaverManager();
        ScreenSaverManager.a.b = config;
        return a;
    }

    public static ScreenSaverManager getInstance() {
        return a;
    }

    public static ScreenSaverConfig getScreenSaverConfig() {
        return ScreenSaverManager.a.b;
    }

    public static String getSourcePicPath(ScreenSaverConfig config, String targetFileName) {
        File file = new File(config.sourcePicPathString);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory()) {
            return new File(config.sourcePicPathString, targetFileName).getAbsolutePath();
        }
        if (file.isFile()) {
            if (StringUtils.isNullOrEmpty((String)targetFileName)) {
                return config.sourcePicPathString;
            }
            return new File(FileUtils.getParent((String)config.sourcePicPathString), targetFileName).getAbsolutePath();
        }
        return config.sourcePicPathString;
    }

    public static void setAllScreenSaver(Context context, DataManager dataManager, ScreenSaverConfig config, RxCallback baseCallback) {
        for (int i = config.screenSaverInitialNumber; i < config.screenSaverInitialNumber + SCREEN_SAVER_COUNT_LIMIT; ++i) {
            ScreenSaverConfig screenSaverConfig = config.copy();
            screenSaverConfig.targetPicPathString = screenSaverConfig.createTargetPicPath(i);
            ScreenSaverManager.setOneScreenSaver(context, dataManager, screenSaverConfig, baseCallback);
        }
    }

    public static void setOneScreenSaver(Context context, DataManager dataManager, ScreenSaverConfig config, RxCallback baseCallback) {
        ScreenSaverRequest screenSaverRequest = new ScreenSaverRequest(dataManager, config);
        dataManager.submit(context, (BaseDataRequest)screenSaverRequest, baseCallback);
    }
}

