/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurePreferences {
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static final String SECRET_KEY_HASH_TRANSFORMATION = "SHA-256";
    private static final String CHARSET = "UTF-8";
    private final boolean encryptKeys;
    private final Cipher writer;
    private final Cipher reader;
    private final Cipher keyWriter;
    private final SharedPreferences preferences;

    public SecurePreferences(Context context, String preferenceName, String secureKey, boolean encryptKeys) throws SecurePreferencesException {
        try {
            this.writer = Cipher.getInstance(TRANSFORMATION);
            this.reader = Cipher.getInstance(TRANSFORMATION);
            this.keyWriter = Cipher.getInstance(KEY_TRANSFORMATION);
            this.initCiphers(secureKey);
            this.preferences = context.getSharedPreferences(preferenceName, 0);
            this.encryptKeys = encryptKeys;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurePreferencesException(generalSecurityException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    protected void initCiphers(String secureKey) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = this.getIv();
        SecretKeySpec secretKeySpec = this.getSecretKey(secureKey);
        this.writer.init(1, (Key)secretKeySpec, ivParameterSpec);
        this.reader.init(2, (Key)secretKeySpec, ivParameterSpec);
        this.keyWriter.init(1, secretKeySpec);
    }

    protected IvParameterSpec getIv() {
        byte[] byArray = new byte[this.writer.getBlockSize()];
        System.arraycopy("fldsjfodasjifudslfjdsaofshaufihadsf".getBytes(), 0, byArray, 0, this.writer.getBlockSize());
        return new IvParameterSpec(byArray);
    }

    protected SecretKeySpec getSecretKey(String key) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] byArray = this.createKeyBytes(key);
        return new SecretKeySpec(byArray, TRANSFORMATION);
    }

    protected byte[] createKeyBytes(String key) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(SECRET_KEY_HASH_TRANSFORMATION);
        messageDigest.reset();
        byte[] byArray = messageDigest.digest(key.getBytes(CHARSET));
        return byArray;
    }

    public void put(String key, String value) {
        if (value == null) {
            this.preferences.edit().remove(this.toKey(key)).commit();
        } else {
            this.putValue(this.toKey(key), value);
        }
    }

    public boolean containsKey(String key) {
        return this.preferences.contains(this.toKey(key));
    }

    public void removeValue(String key) {
        this.preferences.edit().remove(this.toKey(key)).commit();
    }

    public String getString(String key) throws SecurePreferencesException {
        if (this.preferences.contains(this.toKey(key))) {
            String string = this.preferences.getString(this.toKey(key), "");
            return this.decrypt(string);
        }
        return null;
    }

    public void clear() {
        this.preferences.edit().clear().commit();
    }

    private String toKey(String key) {
        if (this.encryptKeys) {
            return this.encrypt(key, this.keyWriter);
        }
        return key;
    }

    private void putValue(String key, String value) throws SecurePreferencesException {
        String string = this.encrypt(value, this.writer);
        this.preferences.edit().putString(key, string).commit();
    }

    protected String encrypt(String value, Cipher writer) throws SecurePreferencesException {
        byte[] byArray;
        try {
            byArray = SecurePreferences.convert(writer, value.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
        String string = Base64.encodeToString((byte[])byArray, (int)2);
        return string;
    }

    protected String decrypt(String securedEncodedValue) {
        byte[] byArray = Base64.decode((String)securedEncodedValue, (int)2);
        byte[] byArray2 = SecurePreferences.convert(this.reader, byArray);
        try {
            return new String(byArray2, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    private static byte[] convert(Cipher cipher, byte[] bs) throws SecurePreferencesException {
        try {
            return cipher.doFinal(bs);
        }
        catch (Exception exception) {
            throw new SecurePreferencesException(exception);
        }
    }

    public static class SecurePreferencesException
    extends RuntimeException {
        public SecurePreferencesException(Throwable e) {
            super(e);
        }
    }
}

