/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Annotation_Table;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Bookmark_Table;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Library_Table;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.data.utils.QueryBuilder;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LocalDataProvider
implements DataProviderBase {
    @Override
    public void clearMetadata() {
        Delete.table(Metadata.class, (SQLOperator[])new SQLOperator[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByIdString(Context context, String idString) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.idString.eq((Object)idString)}).querySingle());
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByPath(Context context, String path) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.nativeAbsolutePath.eq((Object)path)}).querySingle());
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByHashTag(Context context, String path, String hashTag) {
        Metadata metadata = null;
        try {
            if (StringUtils.isNullOrEmpty((String)hashTag)) {
                hashTag = FileUtils.computeMD5((File)new File(path));
            }
            metadata = (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[0]).or((SQLOperator)Metadata_Table.hashTag.eq((Object)hashTag)).or((SQLOperator)Metadata_Table.nativeAbsolutePath.eq((Object)path)).querySingle());
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    @Override
    public QueryResult<Metadata> findMetadataResultByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = new QueryResult<Metadata>();
        queryResult.list = this.findMetadataByQueryArgs(context, queryArgs);
        queryResult.count = this.count(context, queryArgs);
        return queryResult;
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        if (queryArgs.conditionGroup != null) {
            Where where = new Select(queryArgs.propertyList.toArray(new IProperty[0])).from(Metadata.class).where(new SQLOperator[]{queryArgs.conditionGroup});
            for (OrderBy orderBy : queryArgs.orderByList) {
                where.orderBy(orderBy);
            }
            return where.offset(queryArgs.offset).limit(queryArgs.limit).queryList();
        }
        return new ArrayList<Metadata>();
    }

    @Override
    public long count(Context context, QueryArgs queryArgs) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(Metadata.class).where(new SQLOperator[]{queryArgs.conditionGroup}).count();
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.save();
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        metadata.delete();
    }

    @Override
    public boolean saveDocumentOptions(Context context, String path, String md5, String json) {
        try {
            Metadata metadata = this.findMetadataByHashTag(context, path, md5);
            metadata.setExtraAttributes(json);
            if (!metadata.hasValidId()) {
                metadata.setNativeAbsolutePath(path);
                metadata.setHashTag(md5);
                metadata.save();
            } else {
                metadata.update();
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public final List<Annotation> loadAnnotations(String application, String associationId, int pageNumber, OrderBy orderBy) {
        return new Select(new IProperty[0]).from(Annotation.class).where(new SQLOperator[]{Annotation_Table.idString.eq((Object)associationId)}).and((SQLOperator)Annotation_Table.application.eq((Object)application)).and((SQLOperator)Annotation_Table.pageNumber.eq((Object)pageNumber)).orderBy(orderBy).queryList();
    }

    @Override
    public final List<Annotation> loadAnnotations(String application, String associationId, OrderBy orderBy) {
        return new Select(new IProperty[0]).from(Annotation.class).where(new SQLOperator[]{Annotation_Table.idString.eq((Object)associationId)}).and((SQLOperator)Annotation_Table.application.eq((Object)application)).orderBy(orderBy).queryList();
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        annotation.save();
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
        annotation.save();
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
        annotation.delete();
    }

    @Override
    public final Bookmark loadBookmark(String application, String associationId, int pageNumber) {
        return (Bookmark)((Object)new Select(new IProperty[0]).from(Bookmark.class).where(new SQLOperator[]{Bookmark_Table.idString.eq((Object)associationId)}).and((SQLOperator)Bookmark_Table.application.eq((Object)application)).and((SQLOperator)Bookmark_Table.pageNumber.eq((Object)pageNumber)).querySingle());
    }

    @Override
    public final List<Bookmark> loadBookmarks(String application, String associationId, OrderBy orderBy) {
        return new Select(new IProperty[0]).from(Bookmark.class).where(new SQLOperator[]{Bookmark_Table.idString.eq((Object)associationId)}).and((SQLOperator)Bookmark_Table.application.eq((Object)application)).orderBy(orderBy).queryList();
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
        bookmark.save();
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
        bookmark.delete();
    }

    @Override
    public Library loadLibrary(String uniqueId) {
        return (Library)((Object)new Select(new IProperty[0]).from(Library.class).where(new SQLOperator[]{Library_Table.idString.eq((Object)uniqueId)}).querySingle());
    }

    @Override
    public QueryResult<Library> fetchAllLibrary(String paretId, QueryArgs queryArgs) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        queryResult.list = this.loadAllLibrary(queryArgs.libraryUniqueId, queryArgs);
        queryResult.count = CollectionUtils.getSize(queryResult.list);
        return queryResult;
    }

    @Override
    public List<Library> loadAllLibrary(String parentId, QueryArgs queryArgs) {
        Operator operator = QueryBuilder.getNullOrEqualCondition(Library_Table.parentUniqueId, parentId);
        QueryBuilder.andWith(queryArgs.conditionGroup, operator);
        return new Select(new IProperty[0]).from(Library.class).where(new SQLOperator[]{queryArgs.conditionGroup}).queryList();
    }

    @Override
    public void addLibrary(Library library) {
        library.save();
    }

    @Override
    public void updateLibrary(Library library) {
        library.update();
    }

    @Override
    public void deleteLibrary(Library library) {
        library.delete();
    }

    @Override
    public void clearLibrary() {
        Delete.table(Library.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void clearThumbnails() {
        Delete.table(Thumbnail.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void saveThumbnailEntry(Context context, Thumbnail thumbnail) {
        thumbnail.save();
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return (Thumbnail)((Object)new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLOperator[0]).and((SQLOperator)Thumbnail_Table.idString.eq((Object)associationId)).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)kind)).querySingle());
    }

    @Override
    public void deleteThumbnailEntry(Thumbnail thumbnail) {
        thumbnail.delete();
    }

    @Override
    public boolean saveThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap saveBitmap) {
        return false;
    }

    @Override
    public boolean removeThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        new Delete().from(Thumbnail.class).where(new SQLOperator[0]).and((SQLOperator)Thumbnail_Table.idString.eq((Object)associationId)).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)kind)).execute();
        return true;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        Thumbnail thumbnail = this.getThumbnailEntry(context, associationId, kind);
        if (thumbnail == null || StringUtils.isNullOrEmpty((String)thumbnail.getImageDataPath())) {
            return null;
        }
        return BitmapUtils.loadBitmapFromFile((String)thumbnail.getImageDataPath());
    }

    public List<Thumbnail> loadThumbnail(Context context, String associationId) {
        return new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLOperator[]{Thumbnail_Table.idString.eq((Object)associationId)}).queryList();
    }

    @Override
    public void clearMetadataCollection() {
        Delete.table(MetadataCollection.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection collection) {
        collection.save();
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        Where where = SQLite.delete(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)});
        if (StringUtils.isNotBlank((String)associationId)) {
            where.and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)associationId));
        }
        where.execute();
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId) {
        new Delete().from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).execute();
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String docId) {
        new Delete().from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.documentUniqueId.eq((Object)docId)}).execute();
    }

    @Override
    public void updateMetadataCollection(MetadataCollection collection) {
        collection.update();
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)associationId)).querySingle());
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String libraryUniqueId) {
        return new Select(new IProperty[0]).from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).queryList();
    }

    @Override
    public MetadataCollection findMetadataCollection(Context context, String associationId) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.documentUniqueId.eq((Object)associationId)}).querySingle());
    }

    @Override
    public long libraryCount(String parentUniqueId) {
        Operator operator = QueryBuilder.getNullOrEqualCondition(Library_Table.parentUniqueId, parentUniqueId);
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(Library.class).where(new SQLOperator[]{operator}).count();
    }

    @Override
    public long libraryCount(QueryArgs queryArgs) {
        Operator operator = QueryBuilder.getNullOrEqualCondition(Library_Table.parentUniqueId, queryArgs.libraryUniqueId);
        QueryBuilder.andWith(queryArgs.conditionGroup, operator);
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(Library.class).where(new SQLOperator[]{queryArgs.conditionGroup}).count();
    }
}

