/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.graphics.Bitmap;
import android.util.LruCache;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.cache.BitmapReferenceLruCache;
import com.onyx.android.sdk.data.cache.LibraryListLruCache;
import com.onyx.android.sdk.data.cache.MetadataListLruCache;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import java.util.List;

public class CacheManager {
    private static final int a = 524288;
    private static final int b = 262144;
    private static final int c = 0x1B00000;
    private LruCache<String, List<Metadata>> d;
    private LruCache<String, List<Library>> e;
    private BitmapReferenceLruCache f;

    public LruCache<String, List<Metadata>> getMetadataLruCache() {
        if (this.d == null) {
            this.d = new MetadataListLruCache(524288);
        }
        return this.d;
    }

    public LruCache<String, List<Library>> getLibraryLruCache() {
        if (this.e == null) {
            this.e = new LibraryListLruCache(262144);
        }
        return this.e;
    }

    public BitmapReferenceLruCache getBitmapLruCache() {
        if (this.f == null) {
            this.f = new BitmapReferenceLruCache(0x1B00000);
        }
        return this.f;
    }

    public void setMetadataLruCache(LruCache<String, List<Metadata>> lruCache) {
        this.d = lruCache;
    }

    public void setLibraryLruCache(LruCache<String, List<Library>> lruCache) {
        this.e = lruCache;
    }

    public void setBitmapLruCache(BitmapReferenceLruCache bitmapLruCache) {
        this.f = bitmapLruCache;
    }

    public void addToMetadataCache(String key, List<Metadata> metadataList) {
        this.getMetadataLruCache().put((Object)key, metadataList);
    }

    public void clearMetadataCache(String key) {
        this.getMetadataLruCache().remove((Object)key);
    }

    public List<Metadata> getMetadataLruCache(String key) {
        return (List)this.getMetadataLruCache().get((Object)key);
    }

    public void addToLibraryCache(String key, List<Library> libraryList) {
        this.getLibraryLruCache().put((Object)key, libraryList);
    }

    public List<Library> getLibraryLruCache(String key) {
        return (List)this.getLibraryLruCache().get((Object)key);
    }

    public void addToBitmapRefCache(String key, CloseableReference<Bitmap> bitmap) {
        this.getBitmapLruCache().put(key, bitmap);
    }

    public CloseableReference<Bitmap> getBitmapRefCache(String key) {
        return (CloseableReference)this.getBitmapLruCache().get(key);
    }

    public void clearMetadataCache() {
        this.getMetadataLruCache().evictAll();
    }

    public void clearLibraryCache() {
        this.getLibraryLruCache().evictAll();
    }

    public void clearAll() {
        this.clearMetadataCache();
        this.clearLibraryCache();
    }

    public boolean hasMetadataCache(String key) {
        return this.getMetadataLruCache(key) != null;
    }

    public static String generateCloudKey(QueryArgs args) {
        String string = args.libraryUniqueId;
        string = string + args.getOrderByQuery();
        return string;
    }

    public static String generateCloudThumbnailKey(String associationId, String url, String urlKey) {
        return associationId + url + urlKey;
    }
}

