/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.util.Log;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PoolConfig;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ThumbnailUtils {
    public static final String thumbnail_folder = ".thumbnails";
    public static final String preferred_extension = "png";
    private static Map<String, Integer> b = new HashMap<String, Integer>();

    public static Map<String, Integer> defaultThumbnailMapping() {
        if (CollectionUtils.isNullOrEmpty(b)) {
            b = new HashMap<String, Integer>();
            b.put("acsm", R.drawable.acsm);
            b.put("bmp", R.drawable.bmp);
            b.put("chm", R.drawable.chm);
            b.put("djvu", R.drawable.djvu);
            b.put("doc", R.drawable.doc);
            b.put("docx", R.drawable.docx);
            b.put("eba3", R.drawable.eba3);
            b.put("ebaml", R.drawable.ebaml);
            b.put("epub", R.drawable.epub);
            b.put("fb2", R.drawable.fb2);
            b.put("gif", R.drawable.gif);
            b.put("htm", R.drawable.htm);
            b.put("html", R.drawable.html);
            b.put("jpg", R.drawable.jpg);
            b.put("mobi", R.drawable.mobi);
            b.put("mp3", R.drawable.mp3);
            b.put("pdb", R.drawable.pdb);
            b.put("pdf", R.drawable.pdf);
            b.put(preferred_extension, R.drawable.png);
            b.put("ppt", R.drawable.ppt);
            b.put("prc", R.drawable.prc);
            b.put("rar", R.drawable.rar);
            b.put("rtf", R.drawable.rtf);
            b.put("tiff", R.drawable.tiff);
            b.put("txt", R.drawable.txt);
            b.put("wma", R.drawable.wma);
            b.put("xls", R.drawable.xls);
            b.put("zip", R.drawable.zip);
            b.put("cbz", R.drawable.cbz);
        }
        return b;
    }

    public static Integer thumbnailUnknown() {
        return R.drawable.unknown_document;
    }

    public static Integer thumbnailDefault() {
        return R.drawable.book_default_cover;
    }

    public static Integer libraryThumbnailDefault() {
        return R.drawable.library_default_cover;
    }

    public static Bitmap loadThumbnail(Context context, int resId) {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)context.getResources().getDrawable(resId);
        return bitmapDrawable == null ? null : bitmapDrawable.getBitmap();
    }

    public static Bitmap loadDefaultThumbnailFromExtension(Context context, String ext) {
        if (StringUtils.isNullOrEmpty((String)ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailUnknown());
        }
        if (ThumbnailUtils.defaultThumbnailMapping().containsKey(ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.defaultThumbnailMapping().get(ext));
        }
        return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailDefault());
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind) {
        return ThumbnailUtils.getThumbnailFile(context, sourceMD5, thumbnailKind, preferred_extension);
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind, String extension) {
        return EnvironmentUtil.getExternalStorageAppCacheDirectory((String)context.getPackageName()) + File.separator + thumbnail_folder + File.separator + sourceMD5 + "." + thumbnailKind + "." + extension;
    }

    public static Bitmap getThumbnailBitmap(Context context, String sourceMD5, String thumbnailKind) {
        return BitmapUtils.loadBitmapFromFile((String)ThumbnailUtils.getThumbnailFile(context, sourceMD5, thumbnailKind));
    }

    public static Bitmap getThumbnailBitmap(Context context, Thumbnail thumbnail) {
        Bitmap bitmap = ThumbnailUtils.getThumbnailBitmap(context, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString());
        if (bitmap == null) {
            bitmap = ThumbnailUtils.loadDefaultThumbnailFromExtension(context, FileUtils.getFileExtension((String)thumbnail.getOriginContentPath()));
        }
        return bitmap;
    }

    public static boolean saveThumbnailBitmap(Context context, Thumbnail thumbnail, Bitmap saveBitmap) {
        String string2 = ThumbnailUtils.getThumbnailFile(context, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString());
        if (!FileUtils.ensureFileExists((String)string2)) {
            return false;
        }
        boolean bl = BitmapUtils.saveBitmap((Bitmap)ThumbnailUtils.a(saveBitmap, thumbnail.getThumbnailKind()), (String)string2);
        if (bl) {
            thumbnail.setOriginContentPath(string2);
            thumbnail.save();
        }
        return bl;
    }

    private static Bitmap a(Bitmap bitmap, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        Bitmap bitmap2 = bitmap;
        switch (thumbnailKind) {
            case Original: {
                bitmap2 = bitmap;
                break;
            }
            case Large: {
                bitmap2 = OnyxThumbnail.createLargeThumbnail(bitmap);
                break;
            }
            case Middle: {
                bitmap2 = OnyxThumbnail.createMiddleThumbnail(bitmap);
                break;
            }
            case Small: {
                bitmap2 = OnyxThumbnail.createSmallThumbnail(bitmap);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return bitmap2;
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProviderBase, String filePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        return ThumbnailUtils.insertThumbnail(context, dataProviderBase, filePath, ThumbnailUtils.getThumbnailFile(context, associationId, kind.toString()), associationId, kind, bitmap);
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProviderBase, String bookFilePath, String thumbnailFilePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        Thumbnail thumbnail = new Thumbnail();
        thumbnail.setThumbnailKind(kind);
        thumbnail.setOriginContentPath(bookFilePath);
        thumbnail.setIdString(associationId);
        thumbnail.setImageDataPath(thumbnailFilePath);
        dataProviderBase.saveThumbnailEntry(context, thumbnail);
        return ThumbnailUtils.insertThumbnailBitmap(thumbnail, bitmap);
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProviderBase, String filePath, String associationId, Bitmap bitmap) {
        for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
            boolean bl = ThumbnailUtils.insertThumbnail(context, dataProviderBase, filePath, associationId, thumbnailKind, bitmap);
            if (!thumbnailKind.equals((Object)OnyxThumbnail.ThumbnailKind.Large) || bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeBitmapToThumbnailFile(File file, Bitmap transBitmap) {
        boolean bl;
        FileOutputStream fileOutputStream;
        block8: {
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            if (transBitmap != null && !transBitmap.isRecycled()) break block8;
            boolean bl2 = false;
            FileUtils.closeQuietly((Closeable)fileOutputStream);
            return bl2;
        }
        try {
            Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
            if (FileUtils.isPngExtension((File)file)) {
                compressFormat = Bitmap.CompressFormat.PNG;
            } else if (FileUtils.isJpgExtension((File)file)) {
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
            bl = transBitmap.compress(compressFormat, 100, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                Log.w((String)"writeBitmapToThumbnail", (Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            FileUtils.closeQuietly((Closeable)fileOutputStream);
            return false;
        }
        FileUtils.closeQuietly((Closeable)fileOutputStream);
        return bl;
    }

    public static boolean insertThumbnailBitmap(Thumbnail thumbnail, Bitmap bmp) {
        Bitmap bitmap = ThumbnailUtils.a(bmp, thumbnail.getThumbnailKind());
        FileUtils.ensureFileExists((String)thumbnail.getImageDataPath());
        File file = new File(thumbnail.getImageDataPath());
        return ThumbnailUtils.writeBitmapToThumbnailFile(file, bitmap);
    }

    public static Bitmap createLargeThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 512);
    }

    public static Bitmap createMiddleThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 256);
    }

    public static Bitmap createSmallThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 128);
    }

    private static Bitmap a(Bitmap bitmap, int n) {
        if (bitmap.getWidth() <= n && bitmap.getHeight() <= n) {
            return bitmap;
        }
        int n2 = n;
        int n3 = n;
        if (bitmap.getWidth() >= bitmap.getHeight()) {
            double d = (double)n / (double)bitmap.getWidth();
            n3 = (int)(d * (double)bitmap.getHeight());
        } else {
            double d = (double)n / (double)bitmap.getHeight();
            n2 = (int)(d * (double)bitmap.getWidth());
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)true);
    }

    public static CloseableReference<Bitmap> decodeFile(File file) throws IOException {
        return ThumbnailUtils.decodeStream(new FileInputStream(file), Bitmap.Config.ARGB_8888);
    }

    public static CloseableReference<Bitmap> decodeFile(File file, Bitmap.Config config) throws IOException {
        return ThumbnailUtils.decodeStream(new FileInputStream(file), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableReference<Bitmap> decodeStream(InputStream inputStream, Bitmap.Config config) throws IOException {
        CloseableReference closeableReference;
        PoolFactory poolFactory = new PoolFactory(PoolConfig.newBuilder().build());
        PooledByteBuffer pooledByteBuffer = null;
        EncodedImage encodedImage = null;
        try {
            pooledByteBuffer = poolFactory.getPooledByteBufferFactory().newByteBuffer(inputStream);
            encodedImage = new EncodedImage(CloseableReference.of((Closeable)pooledByteBuffer));
            closeableReference = Fresco.getImagePipelineFactory().getPlatformDecoder().decodeFromEncodedImage(encodedImage, config, null);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly((Closeable)inputStream);
            FileUtils.closeQuietly(encodedImage);
            FileUtils.closeQuietly((Closeable)pooledByteBuffer);
            throw throwable;
        }
        FileUtils.closeQuietly((Closeable)inputStream);
        FileUtils.closeQuietly((Closeable)encodedImage);
        FileUtils.closeQuietly((Closeable)pooledByteBuffer);
        return closeableReference;
    }

    public static boolean hasThumbnail(Context context, DataProviderBase dataProvider, String associationId) {
        Thumbnail thumbnail = ThumbnailUtils.getThumbnailEntry(context, dataProvider, associationId, OnyxThumbnail.ThumbnailKind.Large);
        return thumbnail != null && thumbnail.hasValidId();
    }

    public static Thumbnail getThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return dataProvider.getThumbnailEntry(context, associationId, kind);
    }

    public static boolean updateThumbnailEntrySet(Context context, DataProviderBase dataProvider, String associationId, Bitmap originBitmap) {
        boolean bl = true;
        for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
            bl &= ThumbnailUtils.updateThumbnailEntry(context, dataProvider, associationId, thumbnailKind, originBitmap);
        }
        return bl;
    }

    public static boolean updateThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap originBitmap) {
        Thumbnail thumbnail = ThumbnailUtils.getThumbnailEntry(context, dataProvider, associationId, kind);
        if (thumbnail == null) {
            Log.w((String)"update thumbnail", (String)"detect null");
            return false;
        }
        thumbnail.setImageDataPath(ThumbnailUtils.getThumbnailFile(context, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString()));
        dataProvider.saveThumbnailEntry(context, thumbnail);
        return ThumbnailUtils.insertThumbnailBitmap(thumbnail, originBitmap);
    }
}

