/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.model.OnyxAccount;
import java.lang.reflect.Type;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectParseUtils {
    public static final String TAG_UPDATEDAT = "updatedAt";
    public static final String TAG_CREATEDAT = "createdAt";
    public static final String TAG_SESSIONTOKEN = "sessionToken";
    public static final String TAG_MAIN = "main";
    public static final String TAG_EMAIL = "email";
    public static final String TAG_DEVICE_IDS = "deviceIds";
    public static final String TAG_CODE = "code";
    public static final String TAG_MESSAGE = "message";
    public static final int STATUS_CODE_SUCCESS_RESPONSE = 200;
    public static final int STATUS_CODE_ERROR_SERVER_NO_ACTION = 0;
    public static final int STATUS_CODE_ERROR_BAD_REQUEST = 400;
    public static final int STATUS_CODE_ERROR_UNAUTHORIZED = 401;
    public static final int ACCOUNT_ERROR_EXIST = 404;
    public static final int ACCOUNT_ERROR_INCORRECT_PASSWORD = 405;
    public static final int ACCOUNT_ERROR_NOT_EXIST = 406;

    public static OnyxAccount parseOnyxAccount(String jsonString) {
        OnyxAccount onyxAccount = null;
        try {
            onyxAccount = (OnyxAccount)((Object)JSON.parseObject((String)jsonString, OnyxAccount.class));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return onyxAccount;
    }

    public static String httpStatus(int statusCode, JSONObject errorResponse) throws JSONException {
        return errorResponse.getInt(TAG_CODE) + "," + errorResponse.getInt(TAG_MESSAGE);
    }

    public static <T> T parseObject(String json, Class<T> cls, Feature ... features) {
        try {
            return (T)JSON.parseObject((String)json, cls, (Feature[])features);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T> T parseObject(String json, TypeReference<T> typeReference, Feature ... features) {
        try {
            return (T)JSON.parseObject((String)json, typeReference, (Feature[])features);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T> T toBean(byte[] json, Class<T> type) {
        Object object = null;
        try {
            String string2 = new String(json, "UTF-8");
            object = JSON.parseObject((String)string2, type);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (T)object;
    }

    public static <T> T toBean(byte[] json, Type type) {
        Object object = null;
        try {
            String string2 = new String(json, "UTF-8");
            object = JSON.parseObject((String)string2, (Type)type, (Feature[])new Feature[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (T)object;
    }

    public static <T> T toBean(String json, Type type) {
        Object object = JSON.parseObject((String)json, (Type)type, (Feature[])new Feature[0]);
        return (T)object;
    }

    public static String toJson(Object object) {
        String string2 = null;
        try {
            string2 = JSON.toJSONString((Object)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static <T> List<T> toList(String json, Type type) {
        List list = (List)JSON.parseObject((String)json, (Type)type, (Feature[])new Feature[0]);
        return list;
    }

    public static class deviceId {
        public static final String machineIdentifier = "machineIdentifier";
        public static final String timestamp = "timestamp";
        public static final String timeSecond = "timeSecond";
        public static final String time = "time";
        public static final String date = "date";
    }
}

