/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.FileErrorPolicy;
import com.onyx.android.sdk.data.FileReplacePolicy;
import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileCopyRequest
extends BaseFSRequest {
    private File a;
    private File b;
    private List<File> c;
    private List<File> d = new ArrayList<File>();
    private List<File> e = new ArrayList<File>();
    private List<File> f = new ArrayList<File>();
    private boolean g;
    private File h;
    private File i;
    private AtomicBoolean j = new AtomicBoolean();
    public FileReplacePolicy replacePolicy = FileReplacePolicy.Ask;
    public FileErrorPolicy errorPolicy = FileErrorPolicy.Retry;

    public FileCopyRequest(DataManager dataManager, List<File> sourceFiles, File targetDir, boolean isCut) {
        super(dataManager);
        this.f = sourceFiles;
        this.b = targetDir;
        this.g = isCut;
        this.a = sourceFiles.get(0).getParentFile();
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.a();
        this.m();
    }

    private boolean a() throws ContentException {
        if (this.a.equals(this.b)) {
            throw new ContentException.FileCopyException(this.a, this.b);
        }
        return false;
    }

    private void b() {
        this.e();
    }

    private void c() {
        if (this.h != null && this.j()) {
            this.a(this.h);
            this.h = null;
        }
    }

    private void d() {
        if (this.i != null && this.k()) {
            this.c(this.i);
            this.i = null;
        }
    }

    private List<File> e() {
        if (this.c == null) {
            this.c = this.a(this.f);
        }
        return this.c;
    }

    private File f() {
        return this.e().get(0);
    }

    private File g() {
        return this.e().remove(0);
    }

    private List<File> h() {
        return this.e;
    }

    private List<File> i() {
        return this.d;
    }

    private ArrayList<File> a(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (CollectionUtils.isNullOrEmpty(list)) {
            return arrayList;
        }
        for (File file : list) {
            FileUtils.collectFileTree((File)file, arrayList, (AtomicBoolean)this.j);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private void a(File file) {
        this.b(file);
        if (this.replacePolicy == FileReplacePolicy.Skip) {
            this.replacePolicy = FileReplacePolicy.Ask;
        }
    }

    private void b(File file) {
        this.g();
        this.h().add(file);
    }

    private boolean j() {
        return this.replacePolicy.isSkipPolicy();
    }

    private boolean k() {
        return this.errorPolicy.isSkipPolicy();
    }

    private void c(File file) {
        this.b(file);
        if (this.errorPolicy == FileErrorPolicy.Skip) {
            this.errorPolicy = FileErrorPolicy.Retry;
        }
    }

    private boolean d(File file) {
        for (File file2 : this.h()) {
            if (!file2.getAbsolutePath().startsWith(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private boolean l() {
        return this.replacePolicy.isReplacePolicy();
    }

    private boolean e(File file) {
        for (File file2 : this.i()) {
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    private boolean a(File file, File file2) throws ContentException {
        if (this.j()) {
            this.a(file);
            return false;
        }
        if (this.l() || this.e(file2)) {
            if (this.replacePolicy == FileReplacePolicy.Replace && !this.e(file2)) {
                this.d.add(file2);
                this.replacePolicy = FileReplacePolicy.Ask;
            }
            if (file.isDirectory() && file2.isDirectory()) {
                return true;
            }
            if (FileUtils.deleteFile((File)file2, (boolean)true)) {
                return true;
            }
            if (this.k()) {
                this.c(file);
                return false;
            }
            this.i = file;
            throw new ContentException.FileDeleteException(file2);
        }
        this.h = file;
        throw new ContentException.FileAskForReplaceException(file, file2);
    }

    private boolean f(File file) throws ContentException {
        String string2 = file.getAbsolutePath().substring(this.a.getAbsolutePath().length());
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        File file2 = this.a;
        File file3 = this.b;
        String[] stringArray = string2.split("/");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            file2 = new File(file2, stringArray[i]);
            if (!(file3 = new File(file3, stringArray[i])).exists()) {
                if (file3.mkdirs()) {
                    this.i().add(file3);
                    continue;
                }
                if (this.k()) {
                    this.c(file2);
                    continue;
                }
                this.i = file2;
                throw new ContentException.FileCreateException(file3);
            }
            if (this.a(file2, file3)) continue;
            return false;
        }
        File file4 = new File(this.b, string2);
        return !file4.exists() || this.a(file, file4);
    }

    private File a(File file, File file2, File file3) {
        String string2 = file2.getAbsolutePath();
        if (string2.startsWith(file.getAbsolutePath())) {
            String string3 = string2.substring(file.getAbsolutePath().length() + 1);
            return new File(file3, string3);
        }
        return null;
    }

    private boolean g(File file) throws ContentException {
        File file2 = this.a(this.a, file, this.b);
        if (file.isDirectory()) {
            if (!file2.exists() && !file2.mkdirs()) {
                if (this.k()) {
                    this.c(file);
                    return false;
                }
                throw new ContentException.FileCreateException(file2);
            }
        } else if (file.isFile()) {
            boolean bl;
            if (this.g) {
                if (FileUtils.onSameSDCard((File)file, (File)file2)) {
                    bl = file.renameTo(file2);
                } else {
                    bl = FileUtils.copyFile((File)file, (File)file2);
                    if (bl) {
                        FileUtils.deleteFile((File)file);
                    }
                }
            } else {
                bl = FileUtils.copyFile((File)file, (File)file2);
            }
            if (!bl) {
                if (this.k()) {
                    this.c(file);
                    return false;
                }
                throw new ContentException.FileCopyException(file, file2);
            }
        }
        return true;
    }

    private void m() throws ContentException {
        this.b();
        this.c();
        this.d();
        while (!this.isAbort() && !CollectionUtils.isNullOrEmpty(this.e())) {
            File file = this.f();
            if (this.d(file)) {
                this.g();
                continue;
            }
            if (!this.f(file)) {
                if (this.d(file)) {
                    this.g();
                    continue;
                }
                return;
            }
            if (!this.g(file)) {
                if (this.d(file)) continue;
                return;
            }
            if (this.g) {
                FileUtils.deleteFile((File)file);
            }
            this.g();
        }
        return;
    }

    public void setAbort() {
        super.setAbort();
        this.j.set(this.isAbort());
    }
}

