/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.support.annotation.NonNull;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.RequestManager;
import com.onyx.android.sdk.data.FileSystemManager;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.rx.RxCallback;
import com.onyx.android.sdk.rx.RxManager;
import com.onyx.android.sdk.rx.RxRequest;
import com.raizlabs.android.dbflow.config.DatabaseHolder;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DataManager {
    private static final String a = DataManager.class.getSimpleName();
    private RequestManager b;
    private DataProviderManager c = new DataProviderManager();
    private FileSystemManager d;
    private CacheManager e;
    private ConcurrentHashMap<String, RxManager> f = new ConcurrentHashMap();

    public DataManager() {
        this.b = new RequestManager();
        this.d = new FileSystemManager();
    }

    public static void init(Context context, List<Class<? extends DatabaseHolder>> list) {
        FlowConfig.Builder builder = new FlowConfig.Builder(context);
        if (list != null) {
            for (Class<? extends DatabaseHolder> clazz : list) {
                builder.addDatabaseHolder(clazz);
            }
        }
        FlowManager.init((FlowConfig)builder.build());
    }

    public static void cleanUp() {
    }

    public void submit(Context context, BaseDataRequest request, final BaseCallback callback) {
        this.submit(context, request, new RxCallback(){
            private Throwable c;

            public void onNext(@NonNull Object o) {
            }

            public void onError(@NonNull Throwable e) {
                this.c = e;
            }

            public void onFinally() {
                BaseCallback.invoke((BaseCallback)callback, null, (Throwable)this.c);
            }
        });
    }

    public void submit(Context context, BaseDataRequest request, RxCallback callback) {
        this.getRxManager(context, this.a(request), false).enqueue((RxRequest)request, callback);
    }

    public void submitToMulti(Context context, BaseDataRequest request, RxCallback callback) {
        this.getRxManager(context, this.a(request), true).enqueue((RxRequest)request, callback);
    }

    public RxManager getRxManager(Context context, String identifier, boolean multi) {
        String string = identifier + (multi ? "-multi" : "-single");
        RxManager rxManager = this.f.get(string);
        if (rxManager == null) {
            RxManager.Builder.initAppContext((Context)context);
            rxManager = multi ? RxManager.Builder.newMultiThreadManager() : RxManager.Builder.newSingleThreadManager();
            this.f.put(string, rxManager);
        }
        return rxManager;
    }

    private final String a(BaseDataRequest baseDataRequest) {
        return baseDataRequest.getIdentifier();
    }

    public final RequestManager getRequestManager() {
        return this.b;
    }

    public final DataProviderManager getDataProviderManager() {
        return this.c;
    }

    public DataProviderBase getRemoteContentProvider() {
        this.getDataProviderManager();
        return DataProviderManager.getRemoteDataProvider();
    }

    public final FileSystemManager getFileSystemManager() {
        return this.d;
    }

    public CacheManager getCacheManager() {
        if (this.e == null) {
            this.e = new CacheManager();
        }
        return this.e;
    }
}

