/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class QueryBuilder {
    public static QueryArgs libraryAllBookQuery(String string2, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.allBooksQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String string2, Set<String> set, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.allBooksQuery(set, sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String string2, Set<String> set, OrderBy orderBy) {
        QueryArgs queryArgs = QueryArgs.queryBy(QueryBuilder.orTypeCondition(set), orderBy);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryBookListNewQuery(String string2, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.newBookListQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryFinishReadQuery(String string2, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.finishReadQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentReadingQuery(String string2, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.recentReadingQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentAddQuery(String string2, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        queryArgs.conditionGroup = QueryBuilder.recentAddCondition();
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryTagsFilterQuery(String string2, Set<String> set, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.tagsFilterQuery(set, sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs librarySearchQuery(String string2, String string3, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.searchQuery(string3, sortBy, sortOrder);
        queryArgs.libraryUniqueId = string2;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> set, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        queryArgs.fileType = set;
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> set, OrderBy orderBy) {
        return QueryArgs.queryBy(QueryBuilder.orTypeCondition(set), orderBy);
    }

    public static QueryArgs newBookListQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.NEW);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs finishReadQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.FINISHED);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentReadingQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.READING);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs tagsFilterQuery(Set<String> set, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.TAG);
        queryArgs.tags = set;
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs searchQuery(String string2, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.SEARCH);
        queryArgs.query = string2;
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentAddQuery() {
        QueryArgs queryArgs = QueryArgs.queryBy(QueryBuilder.recentAddCondition(), QueryBuilder.getOrderByUpdateAt().descending());
        return queryArgs;
    }

    public static Property<Integer> getMetadataReadingStatusProperty() {
        return Metadata_Table.readingStatus;
    }

    public static Property<String> getMetadataTypeProperty() {
        return Metadata_Table.type;
    }

    public static Property<String> getMetadataTitleProperty() {
        return Metadata_Table.title;
    }

    public static Property<String> getMetadataNameProperty() {
        return Metadata_Table.name;
    }

    public static Property<String> getMetadataAuthorsProperty() {
        return Metadata_Table.authors;
    }

    public static Property<String> getMetadataPublisherProperty() {
        return Metadata_Table.publisher;
    }

    public static Property<String> getMetadataTagsProperty() {
        return Metadata_Table.tags;
    }

    public static Property<String> getMetadataSeriesProperty() {
        return Metadata_Table.series;
    }

    public static Property<String> getMetadataIdStringProperty() {
        return Metadata_Table.idString;
    }

    public static Property<Long> getMetadataSizeProperty() {
        return Metadata_Table.size;
    }

    public static Property<Date> getMetadataCreatedAtProperty() {
        return Metadata_Table.createdAt;
    }

    public static Property<Date> getMetadataLastAccessProperty() {
        return Metadata_Table.lastAccess;
    }

    public static Property<Integer> getMetadataOrdinalProperty() {
        return Metadata_Table.ordinal;
    }

    public static Property<String> getMetadataCollectionDocIdProperty() {
        return MetadataCollection_Table.documentUniqueId;
    }

    public static Property<String> getMetadataCollectionLibraryIdProperty() {
        return MetadataCollection_Table.libraryUniqueId;
    }

    public static OperatorGroup newBookListCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.NEW));
    }

    public static OperatorGroup finishReadCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.FINISHED));
    }

    public static OperatorGroup recentReadingCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.READING));
    }

    public static OperatorGroup recentAddCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.NEW));
    }

    public static OperatorGroup orTypeCondition(Set<String> set) {
        if (CollectionUtils.isNullOrEmpty(set)) {
            return OperatorGroup.clause();
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (String string2 : set) {
            arrayList.add(QueryBuilder.getMetadataTypeProperty().eq((Object)string2));
        }
        return operatorGroup.orAll(arrayList);
    }

    public static OperatorGroup orTagsCondition(Set<String> set) {
        if (CollectionUtils.isNullOrEmpty(set)) {
            return OperatorGroup.clause();
        }
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (String string2 : set) {
            arrayList.add(QueryBuilder.matchLike(QueryBuilder.getMetadataTagsProperty(), string2));
        }
        return OperatorGroup.clause().orAll(arrayList);
    }

    public static OperatorGroup orSearchCondition(String string2) {
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return OperatorGroup.clause();
        }
        return OperatorGroup.clause().or((SQLOperator)QueryBuilder.matchLike(QueryBuilder.getMetadataTitleProperty(), string2)).or((SQLOperator)QueryBuilder.matchLike(QueryBuilder.getMetadataNameProperty(), string2)).or((SQLOperator)QueryBuilder.matchLike(QueryBuilder.getMetadataAuthorsProperty(), string2));
    }

    public static List<OrderBy> getOrderByList() {
        ArrayList<OrderBy> arrayList = new ArrayList<OrderBy>();
        arrayList.add(OrderBy.fromProperty(QueryBuilder.getMetadataNameProperty()).ascending());
        return arrayList;
    }

    public static OrderBy getOrderByUpdateAt() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByCreateAt() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByName() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataNameProperty()).ascending();
    }

    public static OrderBy getOrderBy(IProperty iProperty) {
        return OrderBy.fromProperty((IProperty)iProperty);
    }

    public static void andWith(OperatorGroup operatorGroup, OperatorGroup operatorGroup2) {
        if (operatorGroup != null && operatorGroup2 != null) {
            operatorGroup.and((SQLOperator)operatorGroup2);
        }
    }

    public static SQLOperator matchNotLike(final Property<String> property, final String string2) {
        if (property == null || StringUtils.isNullOrEmpty((String)string2)) {
            return null;
        }
        return new SQLOperator(){
            private String c;

            public void appendConditionToQuery(com.raizlabs.android.dbflow.sql.QueryBuilder queryBuilder) {
                queryBuilder.append((Object)this.columnName()).append((Object)this.operation());
                queryBuilder.append((Object)Operator.convertValueToString((Object)this.value(), (boolean)true));
            }

            public String columnName() {
                return property.getNameAlias().name();
            }

            public String separator() {
                return this.c;
            }

            public SQLOperator separator(String string22) {
                this.c = string22;
                return this;
            }

            public boolean hasSeparator() {
                return StringUtils.isNotBlank((String)this.c);
            }

            public String operation() {
                return String.format(" %1s ", "NOT LIKE");
            }

            public Object value() {
                return "%" + string2 + "%";
            }
        };
    }

    public static Operator matchLike(Property<String> property, String string2) {
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return null;
        }
        return property.like("%" + string2 + "%");
    }

    public static OperatorGroup matchLikeSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string2 : set) {
            Operator operator = QueryBuilder.matchLike(property, string2);
            if (operator == null) continue;
            operatorGroup.or((SQLOperator)operator);
        }
        return operatorGroup;
    }

    public static OperatorGroup matchEqualSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string2 : set) {
            operatorGroup.or((SQLOperator)property.eq((Object)string2));
        }
        return operatorGroup;
    }

    private static Operator a(Property<String> property, String string2) {
        return string2 == null ? property.isNull() : property.eq((Object)string2);
    }

    private static Operator b(Property<String> property, String string2) {
        return string2 == null ? property.isNotNull() : property.eq((Object)string2);
    }

    private static Operator.In a(Property property, Where where, boolean bl) {
        return bl ? property.in((BaseModelQueriable)where, new BaseModelQueriable[0]) : property.notIn((BaseModelQueriable)where, new BaseModelQueriable[0]);
    }

    public static QueryArgs generateQueryArgs(QueryArgs queryArgs) {
        switch (queryArgs.filter) {
            case ALL: {
                queryArgs.conditionGroup = QueryBuilder.orTypeCondition(queryArgs.fileType);
                break;
            }
            case NEW: {
                queryArgs.conditionGroup = QueryBuilder.newBookListCondition();
                break;
            }
            case READING: {
                queryArgs.conditionGroup = QueryBuilder.recentReadingCondition();
                break;
            }
            case FINISHED: {
                queryArgs.conditionGroup = QueryBuilder.finishReadCondition();
                break;
            }
            case TAG: {
                queryArgs.conditionGroup = QueryBuilder.orTagsCondition(queryArgs.tags);
                break;
            }
            case SEARCH: {
                queryArgs.conditionGroup = QueryBuilder.orSearchCondition(queryArgs.query);
            }
        }
        QueryBuilder.generateQueryArgsSortBy(queryArgs);
        QueryBuilder.generateCriteriaCondition(queryArgs);
        return queryArgs;
    }

    public static OrderBy ascDescOrder(OrderBy orderBy, boolean bl) {
        if (bl) {
            orderBy.ascending();
        } else {
            orderBy.descending();
        }
        return orderBy;
    }

    public static Property getPropertyFromSortBy(SortBy sortBy) {
        Object object = QueryBuilder.getMetadataNameProperty();
        switch (sortBy) {
            case None: 
            case Name: {
                break;
            }
            case FileType: {
                object = QueryBuilder.getMetadataTypeProperty();
                break;
            }
            case Size: {
                object = QueryBuilder.getMetadataSizeProperty();
                break;
            }
            case CreationTime: {
                object = QueryBuilder.getMetadataCreatedAtProperty();
                break;
            }
            case BookTitle: {
                object = QueryBuilder.getMetadataTitleProperty();
                break;
            }
            case Author: {
                object = QueryBuilder.getMetadataAuthorsProperty();
                break;
            }
            case Publisher: {
                object = QueryBuilder.getMetadataPublisherProperty();
                break;
            }
            case LastOpenTime: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case RecentlyRead: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Total: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case StartTime: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case InstallTime: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Ordinal: {
                object = QueryBuilder.getMetadataOrdinalProperty();
            }
        }
        return object;
    }

    public static OrderBy generateOrderBy(SortBy sortBy, SortOrder sortOrder) {
        boolean bl = sortOrder == SortOrder.Asc;
        return QueryBuilder.ascDescOrder(OrderBy.fromProperty((IProperty)QueryBuilder.getPropertyFromSortBy(sortBy)), bl);
    }

    public static void generateQueryArgsSortBy(QueryArgs queryArgs) {
        queryArgs.orderByList.clear();
        queryArgs.orderByList.add(QueryBuilder.generateOrderBy(queryArgs.sortBy, queryArgs.order));
    }

    public static void generateCriteriaCondition(QueryArgs queryArgs) {
        QueryBuilder.andWith(queryArgs.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataAuthorsProperty(), queryArgs.author));
        QueryBuilder.andWith(queryArgs.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTagsProperty(), queryArgs.tags));
        QueryBuilder.andWith(queryArgs.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataSeriesProperty(), queryArgs.series));
        QueryBuilder.andWith(queryArgs.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTitleProperty(), queryArgs.title));
        QueryBuilder.andWith(queryArgs.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTypeProperty(), queryArgs.fileType));
    }

    public static QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        Where where = new Select(new IProperty[]{QueryBuilder.getMetadataCollectionDocIdProperty().withTable()}).from(MetadataCollection.class).where(new SQLOperator[]{QueryBuilder.b((Property<String>)QueryBuilder.getMetadataCollectionLibraryIdProperty().withTable(), queryArgs.libraryUniqueId)});
        Operator.In in = QueryBuilder.a(QueryBuilder.getMetadataIdStringProperty().withTable(), where, StringUtils.isNotBlank((String)queryArgs.libraryUniqueId));
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)in);
        queryArgs.conditionGroup = queryArgs.conditionGroup.size() > 0 ? operatorGroup.and((SQLOperator)queryArgs.conditionGroup) : operatorGroup;
        return queryArgs;
    }
}

