/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Intent;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MetadataUtils {
    public static final String INTENT_EXTRA_DATA_METADATA = "intent_extra_data_metadata";

    public static int compareStringAsc(String string2, String string3) {
        if (string2 == null && string3 == null) {
            return 0;
        }
        if (string2 == null) {
            return -1;
        }
        if (string3 == null) {
            return 1;
        }
        return string2.compareTo(string3);
    }

    public static int compareCreatedAtDateAsc(Metadata metadata, Metadata metadata2) {
        if (metadata.getCreatedAt() == null && metadata2.getCreatedAt() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getCreatedAt() == null) {
            return -1;
        }
        if (metadata2.getCreatedAt() == null) {
            return 1;
        }
        int n = metadata.getCreatedAt().compareTo(metadata2.getCreatedAt());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return n;
    }

    public static int compareCreatedAtDateDesc(Metadata metadata, Metadata metadata2) {
        if (metadata.getCreatedAt() == null && metadata2.getCreatedAt() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getCreatedAt() == null) {
            return 1;
        }
        if (metadata2.getCreatedAt() == null) {
            return -1;
        }
        int n = metadata.getCreatedAt().compareTo(metadata2.getCreatedAt());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return -n;
    }

    public static int compareLastModifiedDateAsc(Metadata metadata, Metadata metadata2) {
        if (metadata.getLastModified() == null && metadata2.getLastModified() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getLastModified() == null) {
            return -1;
        }
        if (metadata2.getLastModified() == null) {
            return 1;
        }
        int n = metadata.getLastModified().compareTo(metadata2.getLastModified());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return n;
    }

    public static int compareLastModifiedDateDesc(Metadata metadata, Metadata metadata2) {
        if (metadata.getLastModified() == null && metadata2.getLastModified() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getLastModified() == null) {
            return 1;
        }
        if (metadata2.getLastModified() == null) {
            return -1;
        }
        int n = metadata.getLastModified().compareTo(metadata2.getLastModified());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return -n;
    }

    public static int compareLastAccessedDateAsc(Metadata metadata, Metadata metadata2) {
        if (metadata.getLastAccess() == null && metadata2.getLastAccess() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getLastAccess() == null) {
            return -1;
        }
        if (metadata2.getLastAccess() == null) {
            return 1;
        }
        int n = metadata.getLastAccess().compareTo(metadata2.getLastAccess());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return n;
    }

    public static int compareLastAccessedDateDesc(Metadata metadata, Metadata metadata2) {
        if (metadata.getLastAccess() == null && metadata2.getLastAccess() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getLastAccess() == null) {
            return 1;
        }
        if (metadata2.getLastAccess() == null) {
            return -1;
        }
        int n = metadata.getLastAccess().compareTo(metadata2.getLastAccess());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return -n;
    }

    public static int compareSizeAsc(Metadata metadata, Metadata metadata2) {
        if (metadata.getSize() == metadata2.getSize()) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return (int)metadata.getSize() - (int)metadata2.getSize();
    }

    public static int compareSizeDesc(Metadata metadata, Metadata metadata2) {
        if (metadata.getSize() == metadata2.getSize()) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return (int)metadata2.getSize() - (int)metadata.getSize();
    }

    public static int compareAuthorStringAsc(Metadata metadata, Metadata metadata2) {
        if (metadata.getAuthors() == null && metadata2.getAuthors() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getAuthors() == null) {
            return -1;
        }
        if (metadata2.getAuthors() == null) {
            return 1;
        }
        int n = metadata.getAuthors().compareTo(metadata2.getAuthors());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return n;
    }

    public static int compareAuthorStringDesc(Metadata metadata, Metadata metadata2) {
        if (metadata.getAuthors() == null && metadata2.getAuthors() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getAuthors() == null) {
            return 1;
        }
        if (metadata2.getAuthors() == null) {
            return -1;
        }
        int n = metadata.getAuthors().compareTo(metadata2.getAuthors());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return -n;
    }

    public static int compareTitleStringAsc(Metadata metadata, Metadata metadata2) {
        if (metadata.getTitle() == null && metadata2.getTitle() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getTitle() == null) {
            return -1;
        }
        if (metadata2.getTitle() == null) {
            return 1;
        }
        int n = metadata.getTitle().compareTo(metadata2.getTitle());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return n;
    }

    public static int compareTitleStringDesc(Metadata metadata, Metadata metadata2) {
        if (metadata.getTitle() == null && metadata2.getTitle() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getTitle() == null) {
            return 1;
        }
        if (metadata2.getTitle() == null) {
            return -1;
        }
        int n = metadata.getTitle().compareTo(metadata2.getTitle());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return -n;
    }

    public static int compareTypeAsc(Metadata metadata, Metadata metadata2) {
        if (metadata.getType() == null && metadata2.getType() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getType() == null) {
            return -1;
        }
        if (metadata2.getType() == null) {
            return 1;
        }
        int n = metadata.getType().compareTo(metadata2.getType());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return n;
    }

    public static int compareTypeDesc(Metadata metadata, Metadata metadata2) {
        if (metadata.getType() == null && metadata2.getType() == null) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        if (metadata.getType() == null) {
            return 1;
        }
        if (metadata2.getType() == null) {
            return -1;
        }
        int n = metadata.getType().compareTo(metadata2.getType());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
        }
        return -n;
    }

    public static void sortByCreatedAtDateAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareCreatedAtDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByCreatedAtDateDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareCreatedAtDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastModifiedAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastModifiedDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastModifiedDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastModifiedDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByNameAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByNameDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return -MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortBySizeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareSizeAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortBySizeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareSizeDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByTitleAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTitleStringAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByTitleDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTitleStringDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByFileTypeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTypeAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByFileTypeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTypeDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByAuthorAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareAuthorStringAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByAuthorDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareAuthorStringDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByPublisherAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareStringAsc(metadata.getPublisher(), metadata2.getPublisher());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByPublisherDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return -MetadataUtils.compareStringAsc(metadata.getPublisher(), metadata2.getPublisher());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByRecentlyReadAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByRecentlyReadDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastOpenTimeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastOpenTimeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sort(List<Metadata> list, SortBy sortBy, SortOrder sortOrder) {
        switch (sortBy) {
            case None: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByNameAsc(list);
                    break;
                }
                MetadataUtils.sortByNameDesc(list);
                break;
            }
            case Name: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByNameAsc(list);
                    break;
                }
                MetadataUtils.sortByNameDesc(list);
                break;
            }
            case FileType: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByFileTypeAsc(list);
                    break;
                }
                MetadataUtils.sortByFileTypeDesc(list);
                break;
            }
            case Size: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortBySizeAsc(list);
                    break;
                }
                MetadataUtils.sortBySizeDesc(list);
                break;
            }
            case CreationTime: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByCreatedAtDateAsc(list);
                    break;
                }
                MetadataUtils.sortByCreatedAtDateDesc(list);
                break;
            }
            case BookTitle: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByTitleAsc(list);
                    break;
                }
                MetadataUtils.sortByTitleDesc(list);
                break;
            }
            case Author: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByAuthorAsc(list);
                    break;
                }
                MetadataUtils.sortByAuthorDesc(list);
                break;
            }
            case Publisher: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByPublisherAsc(list);
                    break;
                }
                MetadataUtils.sortByPublisherDesc(list);
                break;
            }
            case RecentlyRead: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByRecentlyReadAsc(list);
                    break;
                }
                MetadataUtils.sortByRecentlyReadDesc(list);
                break;
            }
            case Total: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case StartTime: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case LastOpenTime: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case InstallTime: {
                if (sortOrder == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
        }
    }

    public static boolean safelyContains(Set<String> set, String string2) {
        return set == null || set.size() <= 0 || set.contains(string2);
    }

    public static boolean safelyContains(Set<String> set, List<String> list) {
        if (set != null && list != null) {
            for (String string2 : list) {
                if (!set.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean safelyContains(String string2, String string3) {
        return !StringUtils.isNullOrEmpty((String)string2) && !StringUtils.isNullOrEmpty((String)string3) && string2.contains(string3);
    }

    public static boolean safelyContains(Metadata metadata, String string2) {
        if (MetadataUtils.safelyContains(metadata.getName(), string2)) {
            return true;
        }
        if (MetadataUtils.safelyContains(metadata.getAuthors(), string2)) {
            return true;
        }
        return MetadataUtils.safelyContains(metadata.getTitle(), string2);
    }

    public static boolean containsIfNotNull(Set<String> set, Collection<String> collection) {
        if (set == null || set.size() == 0) {
            return true;
        }
        if (collection == null) {
            return false;
        }
        for (String string2 : collection) {
            if (!set.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getStringSplitSet(String string2, String string3) {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        if (string2 == null) {
            return hashSet;
        }
        for (String string4 : stringArray = string2.split(string3)) {
            hashSet.add(string4);
        }
        return hashSet;
    }

    public static boolean criteriaContains(Metadata metadata, QueryArgs queryArgs) {
        if (!CollectionUtils.contains(queryArgs.fileType, (String)metadata.getType().toLowerCase())) {
            return false;
        }
        if (!MetadataUtils.containsIfNotNull(queryArgs.author, MetadataUtils.getStringSplitSet(metadata.getAuthors(), ","))) {
            return false;
        }
        if (!MetadataUtils.containsIfNotNull(queryArgs.tags, MetadataUtils.getStringSplitSet(metadata.getTags(), ","))) {
            return false;
        }
        if (!CollectionUtils.contains(queryArgs.title, (String)metadata.getTitle())) {
            return false;
        }
        return MetadataUtils.containsIfNotNull(queryArgs.series, MetadataUtils.getStringSplitSet(metadata.getSeries(), ","));
    }

    public static List<Metadata> verifyReadedStatus(List<Metadata> list, BookFilter bookFilter) {
        if (bookFilter != BookFilter.FINISHED) {
            return list;
        }
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : list) {
            if (!metadata.isFinished()) continue;
            arrayList.add(metadata);
        }
        return arrayList;
    }

    public static Metadata ensureObject(Metadata metadata) {
        return metadata != null ? metadata : new Metadata();
    }

    public static Intent putIntentExtraDataMetadata(Intent intent, Metadata metadata) {
        intent.putExtra(INTENT_EXTRA_DATA_METADATA, JSONObjectParseUtils.toJson((Object)metadata));
        return intent;
    }

    public static Metadata getIntentExtraDataMetadata(Intent intent) {
        String string2 = intent.getStringExtra(INTENT_EXTRA_DATA_METADATA);
        return JSONObjectParseUtils.parseObject(string2, Metadata.class, new Feature[0]);
    }
}

