/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductQuery;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.OnyxBookStoreService;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import retrofit2.Response;

public class ProductRecommendedListRequest
extends BaseCloudRequest {
    private ProductResult<Product> a;
    private ProductQuery b;

    public ProductRecommendedListRequest(CloudManager cloudManager, ProductQuery productQuery) {
        super(cloudManager);
        this.b = productQuery;
    }

    public final ProductResult<Product> getProductResult() {
        return this.a;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(cloudManager);
        } else {
            this.fetchFromLocal(cloudManager);
        }
    }

    public void fetchFromCloud(CloudManager cloudManager) throws Exception {
        OnyxBookStoreService onyxBookStoreService = ServiceFactory.getBookStoreService(cloudManager.getCloudConf().getApiBase());
        Response<ProductResult<Product>> response = this.executeCall(onyxBookStoreService.bookRecommendedList(JSON.toJSONString((Object)this.b)));
        if (response.isSuccessful()) {
            this.a = (ProductResult)response.body();
        }
    }

    public void fetchFromLocal(CloudManager cloudManager) throws Exception {
        this.a = new ProductResult();
        this.a.list = StoreUtils.queryDataList(Product.class);
        this.a.count = this.a.list.size();
    }

    private void a(ProductResult<Product> productResult) {
        StoreUtils.saveToLocal(productResult, Product.class, true);
    }
}

