/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurePreferences {
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static final String SECRET_KEY_HASH_TRANSFORMATION = "SHA-256";
    private static final String CHARSET = "UTF-8";
    private final boolean encryptKeys;
    private final Cipher writer;
    private final Cipher reader;
    private final Cipher keyWriter;
    private final SharedPreferences preferences;

    public SecurePreferences(Context context, String string, String string2, boolean bl) throws SecurePreferencesException {
        try {
            this.writer = Cipher.getInstance(TRANSFORMATION);
            this.reader = Cipher.getInstance(TRANSFORMATION);
            this.keyWriter = Cipher.getInstance(KEY_TRANSFORMATION);
            this.initCiphers(string2);
            this.preferences = context.getSharedPreferences(string, 0);
            this.encryptKeys = bl;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurePreferencesException(generalSecurityException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    protected void initCiphers(String string) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = this.getIv();
        SecretKeySpec secretKeySpec = this.getSecretKey(string);
        this.writer.init(1, (Key)secretKeySpec, ivParameterSpec);
        this.reader.init(2, (Key)secretKeySpec, ivParameterSpec);
        this.keyWriter.init(1, secretKeySpec);
    }

    protected IvParameterSpec getIv() {
        byte[] byArray = new byte[this.writer.getBlockSize()];
        System.arraycopy("fldsjfodasjifudslfjdsaofshaufihadsf".getBytes(), 0, byArray, 0, this.writer.getBlockSize());
        return new IvParameterSpec(byArray);
    }

    protected SecretKeySpec getSecretKey(String string) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] byArray = this.createKeyBytes(string);
        return new SecretKeySpec(byArray, TRANSFORMATION);
    }

    protected byte[] createKeyBytes(String string) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(SECRET_KEY_HASH_TRANSFORMATION);
        messageDigest.reset();
        byte[] byArray = messageDigest.digest(string.getBytes(CHARSET));
        return byArray;
    }

    public void put(String string, String string2) {
        if (string2 == null) {
            this.preferences.edit().remove(this.toKey(string)).commit();
        } else {
            this.putValue(this.toKey(string), string2);
        }
    }

    public boolean containsKey(String string) {
        return this.preferences.contains(this.toKey(string));
    }

    public void removeValue(String string) {
        this.preferences.edit().remove(this.toKey(string)).commit();
    }

    public String getString(String string) throws SecurePreferencesException {
        if (this.preferences.contains(this.toKey(string))) {
            String string2 = this.preferences.getString(this.toKey(string), "");
            return this.decrypt(string2);
        }
        return null;
    }

    public void clear() {
        this.preferences.edit().clear().commit();
    }

    private String toKey(String string) {
        if (this.encryptKeys) {
            return this.encrypt(string, this.keyWriter);
        }
        return string;
    }

    private void putValue(String string, String string2) throws SecurePreferencesException {
        String string3 = this.encrypt(string2, this.writer);
        this.preferences.edit().putString(string, string3).commit();
    }

    protected String encrypt(String string, Cipher cipher) throws SecurePreferencesException {
        byte[] byArray;
        try {
            byArray = SecurePreferences.convert(cipher, string.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
        String string2 = Base64.encodeToString((byte[])byArray, (int)2);
        return string2;
    }

    protected String decrypt(String string) {
        byte[] byArray = Base64.decode((String)string, (int)2);
        byte[] byArray2 = SecurePreferences.convert(this.reader, byArray);
        try {
            return new String(byArray2, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    private static byte[] convert(Cipher cipher, byte[] byArray) throws SecurePreferencesException {
        try {
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new SecurePreferencesException(exception);
        }
    }

    public static class SecurePreferencesException
    extends RuntimeException {
        public SecurePreferencesException(Throwable throwable) {
            super(throwable);
        }
    }
}

