/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryArgs
implements Serializable {
    private static final String TAG = QueryArgs.class.getSimpleName();
    public static int CLOUD_FETCH_LIMIT = 50;
    public int offset = 0;
    public int limit = Integer.MAX_VALUE;
    @JSONField(serialize=false, deserialize=false)
    public OperatorGroup conditionGroup = OperatorGroup.clause();
    @JSONField(serialize=false, deserialize=false)
    public List<IProperty> propertyList = new ArrayList<IProperty>();
    @JSONField(serialize=false, deserialize=false)
    public List<OrderBy> orderByList = new ArrayList<OrderBy>();
    public String libraryUniqueId = null;
    public BookFilter filter = BookFilter.ALL;
    public SortBy sortBy = SortBy.Name;
    public SortOrder order = SortOrder.Desc;
    public Set<String> fileType = new HashSet<String>();
    public Set<String> author = new HashSet<String>();
    public Set<String> title = new HashSet<String>();
    public Set<String> tags = new HashSet<String>();
    public Set<String> series = new HashSet<String>();
    public Set<String> category = new HashSet<String>();
    public String query;
    public int fetchPolicy = 4;
    public String cloudToken;
    public static final String DEVICE_LIBRARY = "deviceLibrary";
    public static final String RECENT_READ = "recentRead";
    public static final String RECENT_ADDED = "recentAdded";

    public QueryArgs() {
    }

    public QueryArgs(SortBy sortBy, SortOrder sortOrder) {
        if (sortBy != null) {
            this.sortBy = sortBy;
        }
        if (sortOrder != null) {
            this.order = sortOrder;
        }
    }

    public static QueryArgs queryBy(OperatorGroup operatorGroup, OrderBy orderBy) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = operatorGroup;
        queryArgs.orderByList.add(orderBy);
        return queryArgs;
    }

    public static QueryArgs queryBy(OperatorGroup operatorGroup, List<OrderBy> list) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = operatorGroup;
        queryArgs.orderByList.addAll(list);
        return queryArgs;
    }

    public static QueryArgs queryBy(OperatorGroup operatorGroup, OrderBy orderBy, int n, int n2) {
        QueryArgs queryArgs = QueryArgs.queryBy(operatorGroup, orderBy);
        queryArgs.offset = n;
        queryArgs.limit = n2;
        return queryArgs;
    }

    public static QueryArgs queryBy(OperatorGroup operatorGroup, List<OrderBy> list, int n, int n2) {
        QueryArgs queryArgs = QueryArgs.queryBy(operatorGroup, list);
        queryArgs.offset = n;
        queryArgs.limit = n2;
        return queryArgs;
    }

    public static QueryArgs queryBy(OperatorGroup operatorGroup) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = operatorGroup;
        return queryArgs;
    }

    public QueryArgs appendOrderBy(OrderBy orderBy) {
        this.orderByList.add(orderBy);
        return this;
    }

    public QueryArgs andWith(OperatorGroup operatorGroup) {
        this.conditionGroup.and((SQLOperator)operatorGroup);
        return this;
    }

    public QueryArgs orWith(OperatorGroup operatorGroup) {
        this.conditionGroup.or((SQLOperator)operatorGroup);
        return this;
    }

    public QueryArgs appendFilter(BookFilter bookFilter) {
        this.filter = bookFilter;
        return this;
    }

    public static final QueryArgs fromQueryString(String string) {
        try {
            return (QueryArgs)JSON.parseObject((String)string, QueryArgs.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String toQueryString(QueryArgs queryArgs) {
        return JSON.toJSONString((Object)queryArgs);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QueryArgs)) {
            return false;
        }
        QueryArgs queryArgs = (QueryArgs)object;
        if (!CollectionUtils.equals(queryArgs.fileType, this.fileType)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.title, this.title)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.author, this.author)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.tags, this.tags)) {
            return false;
        }
        return CollectionUtils.equals(queryArgs.series, this.series);
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isAllSetContentEmpty() {
        if (!CollectionUtils.isNullOrEmpty(this.fileType)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.title)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.author)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.tags)) {
            return false;
        }
        return CollectionUtils.isNullOrEmpty(this.series);
    }

    @JSONField(serialize=false, deserialize=false)
    public String getOrderByQuery() {
        if (CollectionUtils.isNullOrEmpty(this.orderByList)) {
            return null;
        }
        String string = "";
        for (OrderBy orderBy : this.orderByList) {
            string = string + orderBy.getQuery();
        }
        return string;
    }

    @JSONField(serialize=false, deserialize=false)
    public String getLimitOffsetQuery() {
        return " LIMIT " + this.limit + " OFFSET " + this.offset + " ";
    }

    @JSONField(serialize=false, deserialize=false)
    public String getOrderByQueryWithLimitOffset() {
        String string = this.getOrderByQuery();
        String string2 = this.getLimitOffsetQuery();
        if (StringUtils.isNullOrEmpty((String)string)) {
            Log.w((String)TAG, (String)"NULL orderBy detected, offset and limit does not work.");
            return null;
        }
        return string + string2;
    }

    @JSONField(serialize=false, deserialize=false)
    public String[] getProjectionSet() {
        if (CollectionUtils.isNullOrEmpty(this.propertyList)) {
            return null;
        }
        String[] stringArray = new String[this.propertyList.size()];
        for (int i = 0; i < this.propertyList.size(); ++i) {
            stringArray[i] = this.propertyList.get(i).getQuery();
        }
        return stringArray;
    }

    @JSONField(serialize=false, deserialize=false)
    public int getCloudFetchLimit() {
        return this.limit > CLOUD_FETCH_LIMIT ? this.limit : CLOUD_FETCH_LIMIT;
    }

    public QueryArgs resetOffset() {
        return this.setOffset(0);
    }

    public QueryArgs setOffset(int n) {
        this.offset = n;
        return this;
    }

    public QueryArgs setLimit(int n) {
        this.limit = n;
        return this;
    }

    public QueryArgs setLibraryUniqueId(String string) {
        this.libraryUniqueId = string;
        return this;
    }

    public QueryArgs setSortByOrder(SortBy sortBy, SortOrder sortOrder) {
        this.sortBy = sortBy;
        this.order = sortOrder;
        return this;
    }

    public QueryArgs setQuery(String string) {
        this.query = string;
        return this;
    }

    public QueryArgs setConditionGroup(OperatorGroup operatorGroup) {
        this.conditionGroup = operatorGroup;
        return this;
    }

    public QueryArgs addOrderByList(@NonNull List<OrderBy> list) {
        this.orderByList.addAll(list);
        return this;
    }

    public QueryArgs addPropertyList(@NonNull List<IProperty> list) {
        this.propertyList.addAll(list);
        return this;
    }

    public QueryArgs addFileTypeList(@NonNull Collection<String> collection) {
        this.fileType.addAll(collection);
        return this;
    }

    public QueryArgs addAuthorList(@NonNull Collection<String> collection) {
        this.author.addAll(collection);
        return this;
    }

    public QueryArgs addTitleList(@NonNull Collection<String> collection) {
        this.title.addAll(collection);
        return this;
    }

    public QueryArgs addTagsList(@NonNull Collection<String> collection) {
        this.tags.addAll(collection);
        return this;
    }

    public QueryArgs addSeriesList(@NonNull Collection<String> collection) {
        this.series.addAll(collection);
        return this;
    }

    public QueryArgs addCategoryList(@NonNull Collection<String> collection) {
        this.category.addAll(collection);
        return this;
    }

    public QueryArgs useMemCloudDbPolicy() {
        this.fetchPolicy = 4;
        return this;
    }

    public QueryArgs useCloudMemDbPolicy() {
        this.fetchPolicy = 2;
        return this;
    }

    public QueryArgs useCloudOnlyPolicy() {
        this.fetchPolicy = 0;
        return this;
    }

    public QueryArgs setFetchPolicy(int n) {
        this.fetchPolicy = n;
        return this;
    }

    public QueryArgs copyPart() {
        return new QueryArgs(this.sortBy, this.order).setLimit(this.limit).setOffset(this.offset).setQuery(this.query).setLibraryUniqueId(this.libraryUniqueId).setConditionGroup(this.conditionGroup).setFetchPolicy(this.fetchPolicy).addOrderByList(this.orderByList).addPropertyList(this.propertyList).addTitleList(this.title).addAuthorList(this.author).addFileTypeList(this.fileType).addTagsList(this.tags).addSeriesList(this.series).addCategoryList(this.category).appendFilter(this.filter);
    }
}

