/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.LibraryDataModel;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryPagination;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.ViewType;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.utils.QueryBuilder;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LibraryViewInfo
implements Serializable {
    private int queryLimit = 9;
    private QueryArgs queryArgs;
    private QueryPagination queryPagination = QueryPagination.create(3, 3);
    private LibraryDataModel libraryDataModel = new LibraryDataModel();
    private List<Library> libraryPath = new ArrayList<Library>();
    private ViewType viewType = ViewType.Thumbnail;

    public LibraryViewInfo() {
        this.queryArgs = new QueryArgs();
        this.queryArgs.limit = this.queryLimit;
        this.queryPagination.setCurrentPage(0);
    }

    public static LibraryViewInfo create(int n, int n2) {
        return new LibraryViewInfo(n, n2, SortBy.Name, SortOrder.Asc);
    }

    public LibraryViewInfo(int n, int n2, SortBy sortBy, SortOrder sortOrder) {
        this();
        this.queryArgs.limit = this.queryLimit = n * n2;
        this.queryPagination.resize(n, n2, 0);
        this.queryPagination.setCurrentPage(0);
        this.updateSortBy(sortBy, sortOrder);
    }

    public int getOffset(int n) {
        LibraryDataModel libraryDataModel = this.getLibraryDataModel();
        int n2 = this.queryPagination.itemsPerPage();
        int n3 = n * n2 - libraryDataModel.libraryCount;
        if (n3 < 0) {
            n3 = n <= libraryDataModel.libraryCount / n2 ? 0 : n2 + n3;
        }
        return n3;
    }

    public int getOffset() {
        return this.getOffset(this.queryPagination.getCurrentPage());
    }

    public QueryArgs nextPage() {
        this.queryArgs.offset = this.getOffset();
        return this.queryArgs;
    }

    public QueryArgs prevPage() {
        this.queryArgs.offset = this.getOffset();
        return this.queryArgs;
    }

    public QueryArgs pageQueryArgs(int n) {
        QueryArgs queryArgs = this.queryArgs.copyPart();
        queryArgs.offset = this.getOffset(n);
        return queryArgs;
    }

    public QueryArgs gotoPage(int n) {
        this.queryPagination.setCurrentPage(n);
        this.queryArgs.offset = this.getOffset(n);
        return this.queryArgs;
    }

    public QueryArgs firstPage() {
        return this.gotoPage(0);
    }

    public QueryArgs lastPage() {
        return this.gotoPage(this.queryPagination.lastPage());
    }

    public String getSdcardCid() {
        return EnvironmentUtil.getRemovableSDCardCid();
    }

    private OperatorGroup storageIdCondition() {
        OperatorGroup operatorGroup = OperatorGroup.clause().or((SQLOperator)Metadata_Table.storageId.isNull());
        String string = this.getSdcardCid();
        if (StringUtils.isNotBlank((String)string)) {
            operatorGroup.or((SQLOperator)Metadata_Table.storageId.is((Object)string));
        }
        return operatorGroup;
    }

    public QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public QueryArgs generateQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public QueryArgs libraryQuery(int n, int n2) {
        QueryArgs queryArgs = this.libraryQuery(this.getLibraryIdString());
        queryArgs.limit = n;
        queryArgs.offset = n2;
        return queryArgs;
    }

    public QueryArgs libraryQuery(String string) {
        QueryArgs queryArgs = this.buildLibraryQuery(string);
        this.updateQueryArgs(queryArgs);
        return queryArgs;
    }

    public QueryArgs buildLibraryQuery(String string) {
        QueryArgs queryArgs = new QueryArgs(this.queryArgs.sortBy, this.queryArgs.order).appendFilter(this.queryArgs.filter);
        queryArgs.limit = this.queryLimit;
        queryArgs.offset = 0;
        queryArgs.libraryUniqueId = string;
        this.generateQueryArgs(queryArgs);
        QueryBuilder.andWith(queryArgs.conditionGroup, this.storageIdCondition());
        return this.generateMetadataInQueryArgs(queryArgs);
    }

    public QueryArgs libraryQuery() {
        return this.libraryQuery(this.queryArgs.limit, 0);
    }

    public QueryArgs getCurrentQueryArgs() {
        return this.queryArgs;
    }

    public void updateQueryArgs(QueryArgs queryArgs) {
        this.queryArgs = queryArgs;
    }

    public LibraryDataModel getLibraryDataModel() {
        return this.libraryDataModel;
    }

    public void setLibraryDataModel(LibraryDataModel libraryDataModel) {
        this.clearThumbnailMap(this.getLibraryDataModel());
        this.libraryDataModel = libraryDataModel;
    }

    public LibraryDataModel getPageLibraryDataModel(LibraryDataModel libraryDataModel) {
        this.setLibraryDataModel(libraryDataModel);
        LibraryDataModel libraryDataModel2 = new LibraryDataModel();
        int n = this.queryPagination.getCurrentPage();
        int n2 = this.queryPagination.itemsPerPage();
        if (n > this.libraryDataModel.libraryCount / n2) {
            libraryDataModel2.visibleLibraryList = new ArrayList<Library>();
            libraryDataModel2.visibleBookList = this.libraryDataModel.visibleBookList;
        } else {
            int n3;
            int n4;
            for (n4 = n3 = n * n2; n4 < this.libraryDataModel.libraryCount && n4 < (n + 1) * n2; ++n4) {
                libraryDataModel2.visibleLibraryList.add(this.libraryDataModel.visibleLibraryList.get(n4));
            }
            n4 = n2 - CollectionUtils.getSize(libraryDataModel2.visibleLibraryList);
            for (int i = 0; i < n4 && i < CollectionUtils.getSize(this.libraryDataModel.visibleBookList); ++i) {
                libraryDataModel2.visibleBookList.add(this.libraryDataModel.visibleBookList.get(i));
            }
        }
        libraryDataModel2.bookCount = this.libraryDataModel.bookCount;
        libraryDataModel2.libraryCount = this.libraryDataModel.libraryCount;
        libraryDataModel2.thumbnailMap = this.libraryDataModel.thumbnailMap;
        libraryDataModel2.notificationMap = this.libraryDataModel.notificationMap;
        return libraryDataModel2;
    }

    public QueryPagination getQueryPagination() {
        return this.queryPagination;
    }

    public void setQueryPagination(QueryPagination queryPagination) {
        this.queryPagination = queryPagination;
    }

    public String getLibraryIdString() {
        if (CollectionUtils.isNullOrEmpty(this.libraryPath)) {
            return null;
        }
        return this.libraryPath.get(this.libraryPath.size() - 1).getIdString();
    }

    public List<Library> getLibraryPathList() {
        return this.libraryPath;
    }

    public void setLibraryPathList(List<Library> list) {
        this.libraryPath = list;
    }

    public void setCurrentSortOrder(SortOrder sortOrder) {
        this.queryArgs.order = sortOrder;
    }

    public SortOrder getCurrentSortOrder() {
        return this.queryArgs.order;
    }

    public SortBy getCurrentSortBy() {
        return this.queryArgs.sortBy;
    }

    public void updateSortBy(SortBy sortBy, SortOrder sortOrder) {
        this.queryArgs.sortBy = sortBy;
        this.queryArgs.order = sortOrder;
    }

    public void updateSortBy(SortBy sortBy, SortOrder sortOrder, int n) {
        this.updateSortBy(sortBy, sortOrder);
        this.getQueryPagination().setCurrentPage(n);
    }

    public void updateFilterBy(BookFilter bookFilter, SortOrder sortOrder) {
        this.queryArgs.filter = bookFilter;
        this.queryArgs.order = sortOrder;
    }

    public void setQueryLimit(int n) {
        this.queryArgs.limit = this.queryLimit = n;
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public void resizePagination(int n, int n2, int n3) {
        this.getQueryPagination().resize(n, n2, n3);
    }

    public void toggleViewType() {
        this.viewType = this.viewType == ViewType.Thumbnail ? ViewType.Details : ViewType.Thumbnail;
    }

    public ViewType getCurrentViewType() {
        return this.viewType;
    }

    public void setCurrentViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public void clearThumbnailMap(LibraryDataModel libraryDataModel) {
        if (libraryDataModel == null || CollectionUtils.isNullOrEmpty(libraryDataModel.thumbnailMap)) {
            return;
        }
        for (CloseableReference<Bitmap> closeableReference : libraryDataModel.thumbnailMap.values()) {
            closeableReference.close();
        }
    }

    public static LibraryDataModel buildLibraryDataModel(QueryResult<Metadata> queryResult, Map<String, CloseableReference<Bitmap>> map) {
        LibraryDataModel libraryDataModel = new LibraryDataModel();
        if (queryResult == null) {
            return libraryDataModel;
        }
        libraryDataModel.visibleLibraryList = new ArrayList<Library>();
        libraryDataModel.visibleBookList = queryResult.list;
        libraryDataModel.bookCount = (int)queryResult.count;
        libraryDataModel.thumbnailMap = map;
        libraryDataModel.libraryCount = 0;
        return libraryDataModel;
    }
}

