/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.cache.BitmapReferenceLruCache;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataManagerHelper {
    private static DataProviderBase a() {
        return DataProviderManager.getLocalDataProvider();
    }

    public static List<Library> loadLibraryList(DataManager dataManager, List<Library> list, String string) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.libraryUniqueId = string;
        return DataManagerHelper.loadLibraryList(dataManager.getRemoteContentProvider(), list, queryArgs);
    }

    public static List<Library> loadLibraryList(DataProviderBase dataProviderBase, List<Library> list, QueryArgs queryArgs) {
        List<Library> list2 = dataProviderBase.loadAllLibrary(queryArgs.libraryUniqueId, queryArgs);
        if (!CollectionUtils.isNullOrEmpty(list2)) {
            list.addAll(list2);
        }
        return list2;
    }

    public static void loadLibraryRecursive(DataProviderBase dataProviderBase, List<Library> list, QueryArgs queryArgs) {
        List<Library> list2 = DataManagerHelper.loadLibraryList(dataProviderBase, list, queryArgs);
        if (CollectionUtils.isNullOrEmpty(list2)) {
            return;
        }
        for (Library library : list2) {
            QueryArgs queryArgs2 = new QueryArgs();
            queryArgs2.libraryUniqueId = library.getIdString();
            queryArgs2.fetchPolicy = queryArgs.fetchPolicy;
            DataManagerHelper.loadLibraryRecursive(dataProviderBase, list, queryArgs2);
        }
    }

    public static void loadLibraryRecursive(DataManager dataManager, List<Library> list, String string) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.libraryUniqueId = string;
        queryArgs.fetchPolicy = 1;
        DataManagerHelper.loadLibraryRecursive(dataManager.getRemoteContentProvider(), list, queryArgs);
    }

    public static Thumbnail loadThumbnail(Context context, String string, String string2, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        if (StringUtils.isNullOrEmpty((String)string2)) {
            try {
                string2 = FileUtils.computeMD5((File)new File(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return DataManagerHelper.a().getThumbnailEntry(context, string2, thumbnailKind);
    }

    public static Bitmap loadThumbnailBitmap(Context context, Thumbnail thumbnail) {
        return DataManagerHelper.a().getThumbnailBitmap(context, thumbnail.getIdString(), OnyxThumbnail.ThumbnailKind.Original);
    }

    public static Metadata getMetadataByCloudReference(Context context, String string) {
        return (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.cloudId.eq((Object)string)}).querySingle());
    }

    public static Metadata getMetadataByHashTag(Context context, String string) {
        return (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.hashTag.eq((Object)string)}).querySingle());
    }

    public static void deleteAllLibrary(Context context, DataManager dataManager, String string, List<Library> list) {
        DataManagerHelper.deleteAllLibrary(context, dataManager.getRemoteContentProvider(), string, list);
    }

    public static void deleteAllLibrary(Context context, DataProviderBase dataProviderBase, String string, List<Library> list) {
        boolean bl = StringUtils.isNullOrEmpty((String)string);
        DataManagerHelper.deleteAllLibrary(context, dataProviderBase, string, list, bl);
    }

    public static void deleteAllLibrary(Context context, DataProviderBase dataProviderBase, String string, List<Library> list, boolean bl) {
        for (Library library : list) {
            if (bl) {
                dataProviderBase.deleteMetadataCollection(context, library.getIdString());
            } else {
                List<MetadataCollection> list2 = dataProviderBase.loadMetadataCollection(context, library.getIdString());
                for (MetadataCollection metadataCollection : list2) {
                    metadataCollection.setLibraryUniqueId(string);
                    dataProviderBase.updateMetadataCollection(metadataCollection);
                }
            }
            dataProviderBase.deleteLibrary(library);
        }
    }

    public static void deleteMetadataCollection(Context context, DataManager dataManager, String string) {
        dataManager.getRemoteContentProvider().deleteMetadataCollection(context, string);
    }

    public static MetadataCollection loadMetadataCollection(Context context, DataManager dataManager, String string, String string2) {
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context, string, string2);
    }

    public static List<MetadataCollection> loadMetadataCollection(Context context, DataManager dataManager, String string) {
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context, string);
    }

    public static List<Metadata> loadMetadataListWithCache(Context context, DataManager dataManager, QueryArgs queryArgs, boolean bl) {
        String string = queryArgs.conditionGroup.getQuery() + queryArgs.libraryUniqueId + queryArgs.getOrderByQueryWithLimitOffset();
        List<Metadata> list = null;
        if (bl) {
            list = dataManager.getCacheManager().getMetadataLruCache(string);
        }
        if (list == null && !CollectionUtils.isNullOrEmpty(list = dataManager.getRemoteContentProvider().findMetadataByQueryArgs(context, queryArgs))) {
            dataManager.getCacheManager().addToMetadataCache(string, list);
        }
        return list;
    }

    public static List<Library> loadLibraryListWithCache(Context context, DataManager dataManager, String string, boolean bl) {
        String string2 = String.valueOf(string);
        List<Library> list = null;
        if (bl) {
            list = dataManager.getCacheManager().getLibraryLruCache(string2);
        }
        if (list == null) {
            list = new ArrayList<Library>();
            DataManagerHelper.loadLibraryList(dataManager, list, string);
            if (!CollectionUtils.isNullOrEmpty(list)) {
                dataManager.getCacheManager().addToLibraryCache(string2, list);
            }
        }
        return list;
    }

    public static OnyxThumbnail.ThumbnailKind getDefaultThumbnailKind() {
        return OnyxThumbnail.ThumbnailKind.Large;
    }

    public static Thumbnail getThumbnailEntry(Context context, DataProviderBase dataProviderBase, String string) {
        return dataProviderBase.getThumbnailEntry(context, string, DataManagerHelper.getDefaultThumbnailKind());
    }

    public static String getThumbnailPath(Context context, DataProviderBase dataProviderBase, String string) {
        Thumbnail thumbnail = DataManagerHelper.getThumbnailEntry(context, dataProviderBase, string);
        if (thumbnail == null) {
            return null;
        }
        if (!FileUtils.fileExist((String)thumbnail.getImageDataPath())) {
            return null;
        }
        return thumbnail.getImageDataPath();
    }

    public static Map<String, CloseableReference<Bitmap>> loadThumbnailBitmapsWithCache(Context context, DataManager dataManager, List<Metadata> list) {
        HashMap<String, CloseableReference<Bitmap>> hashMap = new HashMap<String, CloseableReference<Bitmap>>();
        for (Metadata metadata : list) {
            CloseableReference<Bitmap> closeableReference = DataManagerHelper.loadThumbnailBitmapWithCache(context, dataManager, metadata);
            if (closeableReference == null) continue;
            hashMap.put(metadata.getAssociationId(), closeableReference);
        }
        return hashMap;
    }

    public static CloseableReference<Bitmap> loadThumbnailBitmapWithCache(Context context, DataManager dataManager, Metadata metadata) {
        BitmapReferenceLruCache bitmapReferenceLruCache = dataManager.getCacheManager().getBitmapLruCache();
        String string = metadata.getAssociationId();
        if (StringUtils.isNullOrEmpty((String)string)) {
            return null;
        }
        CloseableReference closeableReference = (CloseableReference)bitmapReferenceLruCache.get(string);
        if (closeableReference != null) {
            return closeableReference.clone();
        }
        return DataManagerHelper.a(context, dataManager.getRemoteContentProvider(), bitmapReferenceLruCache, string);
    }

    private static CloseableReference<Bitmap> a(File file, BitmapReferenceLruCache bitmapReferenceLruCache, String string) {
        CloseableReference<Bitmap> closeableReference = null;
        try {
            closeableReference = ThumbnailUtils.decodeFile(file);
            if (closeableReference != null && closeableReference.isValid()) {
                bitmapReferenceLruCache.put(string, closeableReference);
                return closeableReference.clone();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return closeableReference;
    }

    private static CloseableReference<Bitmap> a(Context context, DataProviderBase dataProviderBase, BitmapReferenceLruCache bitmapReferenceLruCache, String string) {
        CloseableReference<Bitmap> closeableReference = null;
        String string2 = DataManagerHelper.getThumbnailPath(context, dataProviderBase, string);
        if (StringUtils.isNotBlank((String)string2)) {
            closeableReference = DataManagerHelper.a(new File(string2), bitmapReferenceLruCache, string);
        }
        return closeableReference;
    }

    public static List<Library> loadParentLibraryList(Context context, DataManager dataManager, Library library) {
        Library library2;
        ArrayList<Library> arrayList = new ArrayList<Library>();
        if (library == null || StringUtils.isNullOrEmpty((String)library.getParentUniqueId())) {
            return arrayList;
        }
        String string = library.getParentUniqueId();
        while (StringUtils.isNotBlank((String)string) && (library2 = dataManager.getRemoteContentProvider().loadLibrary(string)) != null) {
            arrayList.add(library2);
            string = library2.getParentUniqueId();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static void updateCloudCacheList(List<Metadata> list, QueryResult<Metadata> queryResult, QueryArgs queryArgs) {
        if (queryResult == null || CollectionUtils.isNullOrEmpty(queryResult.list)) {
            return;
        }
        int n = queryArgs.offset + CollectionUtils.getSize(queryResult.list);
        for (int i = queryArgs.offset; i < n && i < CollectionUtils.getSize(list); ++i) {
            list.set(i, (Metadata)((Object)queryResult.list.get(i - queryArgs.offset)));
        }
    }

    public static QueryResult<Metadata> cloudMetadataFromDataProvider(Context context, DataProviderBase dataProviderBase, QueryArgs queryArgs) {
        int n = queryArgs.limit;
        queryArgs.limit = queryArgs.getCloudFetchLimit();
        QueryResult<Metadata> queryResult = dataProviderBase.findMetadataResultByQueryArgs(context, queryArgs);
        queryArgs.limit = n;
        return queryResult;
    }

    public static boolean cloudMetadataFromCache(QueryResult<Metadata> queryResult, QueryArgs queryArgs, List<Metadata> list) {
        queryResult.count = CollectionUtils.getSize(list);
        queryResult.list = new ArrayList();
        boolean bl = true;
        for (int i = queryArgs.offset; i < queryArgs.limit + queryArgs.offset && i < CollectionUtils.getSize(list); ++i) {
            Metadata metadata = list.get(i);
            if (metadata == null) {
                bl = false;
                break;
            }
            queryResult.list.add(metadata);
        }
        return bl;
    }

    private static Map<String, String> a(Metadata metadata, boolean bl) {
        Map<String, String> map = metadata.getBookCovers();
        if (CollectionUtils.isNullOrEmpty(map)) {
            map = new HashMap<String, String>();
            if (bl) {
                for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
                    map.put(thumbnailKind.toString().toLowerCase(), null);
                }
            }
        }
        return map;
    }

    public static Map<String, CloseableReference<Bitmap>> loadCloudThumbnailBitmapsWithCache(Context context, CloudManager cloudManager, List<Metadata> list) {
        HashMap<String, CloseableReference<Bitmap>> hashMap = new HashMap<String, CloseableReference<Bitmap>>();
        for (Metadata metadata : list) {
            Map<String, String> map = DataManagerHelper.a(metadata, true);
            for (String string : map.keySet()) {
                String string2 = CacheManager.generateCloudThumbnailKey(metadata.getAssociationId(), map.get(string), string);
                CloseableReference<Bitmap> closeableReference = DataManagerHelper.loadCloudThumbnailBitmapWithCache(context, cloudManager, string2);
                if (closeableReference == null) continue;
                hashMap.put(string2, closeableReference);
            }
        }
        return hashMap;
    }

    public static CloseableReference<Bitmap> loadCloudThumbnailBitmapWithCache(Context context, CloudManager cloudManager, String string) {
        BitmapReferenceLruCache bitmapReferenceLruCache = cloudManager.getCacheManager().getBitmapLruCache();
        if (StringUtils.isNullOrEmpty((String)string)) {
            return null;
        }
        CloseableReference closeableReference = (CloseableReference)bitmapReferenceLruCache.get(string);
        if (closeableReference != null) {
            return closeableReference.clone();
        }
        return null;
    }

    public static void saveCloudCollection(Context context, DataProviderBase dataProviderBase, String string, String string2) {
        CloudMetadataCollection cloudMetadataCollection = new CloudMetadataCollection();
        cloudMetadataCollection.setDocumentUniqueId(string2);
        cloudMetadataCollection.setLibraryUniqueId(string);
        DataManagerHelper.saveCollection(context, dataProviderBase, cloudMetadataCollection);
    }

    public static void saveCollection(Context context, DataProviderBase dataProviderBase, MetadataCollection metadataCollection) {
        MetadataCollection metadataCollection2 = dataProviderBase.loadMetadataCollection(context, metadataCollection.getLibraryUniqueId(), metadataCollection.getDocumentUniqueId());
        if (metadataCollection2 == null) {
            if (StringUtils.isNullOrEmpty((String)metadataCollection.getLibraryUniqueId())) {
                return;
            }
            dataProviderBase.addMetadataCollection(context, metadataCollection);
        } else if (StringUtils.isNullOrEmpty((String)metadataCollection.getLibraryUniqueId())) {
            dataProviderBase.deleteMetadataCollection(context, metadataCollection.getLibraryUniqueId(), metadataCollection.getDocumentUniqueId());
        } else {
            metadataCollection.setLibraryUniqueId(metadataCollection.getLibraryUniqueId());
            dataProviderBase.updateMetadataCollection(metadataCollection);
        }
    }

    public static void saveCloudMetadataAndCollection(Context context, DataProviderBase dataProviderBase, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (Metadata metadata : queryResult.list) {
            dataProviderBase.saveMetadata(context, metadata);
            DataManagerHelper.saveCloudCollection(context, dataProviderBase, queryArgs.libraryUniqueId, metadata.getAssociationId());
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static List<Library> fetchLibraryLibraryList(Context context, DataProviderBase dataProviderBase, QueryArgs queryArgs) {
        List<Library> list = dataProviderBase.loadAllLibrary(queryArgs.libraryUniqueId, queryArgs);
        if (!FetchPolicy.isDataFromMemDb(queryArgs.fetchPolicy, NetworkUtil.isWiFiConnected((Context)context))) {
            DataManagerHelper.saveLibraryListToLocal(dataProviderBase, list);
        }
        return list;
    }

    public static void saveLibraryListToLocal(DataProviderBase dataProviderBase, List<Library> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (Library library : list) {
            dataProviderBase.addLibrary(library);
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteLibraryWithRecursive(DataProviderBase dataProviderBase, QueryArgs queryArgs, boolean bl) {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        if (bl) {
            DataManagerHelper.loadLibraryRecursive(dataProviderBase, arrayList, queryArgs);
        } else {
            DataManagerHelper.loadLibraryList(dataProviderBase, arrayList, queryArgs);
        }
        for (Library library : arrayList) {
            dataProviderBase.deleteLibrary(library);
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void clearLibrary(DataProviderBase dataProviderBase) {
        dataProviderBase.clearLibrary();
    }

    public static OperatorGroup getPropertyOrCondition(List<String> list, Property<String> property) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string : list) {
            operatorGroup.or((SQLOperator)property.eq((Object)string));
        }
        return operatorGroup;
    }
}

