/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel_Table;
import com.onyx.android.sdk.utils.MapUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class StatisticsUtils {
    public static void saveStatistics(Context context, OnyxStatisticsModel onyxStatisticsModel) {
        if (onyxStatisticsModel == null) {
            return;
        }
        onyxStatisticsModel.save();
    }

    public static void saveStatisticsList(Context context, Collection<OnyxStatisticsModel> collection) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : collection) {
            onyxStatisticsModel.save();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteStatisticsList(Context context, Collection<OnyxStatisticsModel> collection) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : collection) {
            onyxStatisticsModel.delete();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteStatisticsListByStatus(Context context, int n) {
        List list = (List)StatisticsUtils.loadStatisticsListByStatus(context, n);
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            onyxStatisticsModel.delete();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteStatisticsListByNote(Context context, String string2) {
        List list = (List)StatisticsUtils.loadStatisticsListByNote(context, string2);
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            onyxStatisticsModel.delete();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteStatisticsList(Context context) {
        Select select = new Select(new IProperty[0]);
        List list = select.from(OnyxStatisticsModel.class).queryList();
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            onyxStatisticsModel.delete();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(Context context, int n, int n2) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.status.eq((Object)n2)}).limit(n);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(Context context, int n) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.status.eq((Object)n)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByNote(Context context, String string2) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.note.eq((Object)string2)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, String string2, int n) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n)}).and((SQLOperator)OnyxStatisticsModel_Table.md5short.eq((Object)string2));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, String string2, int n, Date date) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n)}).and((SQLOperator)OnyxStatisticsModel_Table.md5short.eq((Object)string2)).and((SQLOperator)OnyxStatisticsModel_Table.eventTime.greaterThan((Object)date));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, int n) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, int n, int n2) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n)}).and((SQLOperator)OnyxStatisticsModel_Table.status.eq((Object)n2));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, Date date) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)date)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, Date date, int n) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)date)}).and((SQLOperator)OnyxStatisticsModel_Table.type.eq((Object)n));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByMd5short(Context context, String string2) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5short.eq((Object)string2)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, int n, boolean bl) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n)}).orderBy(OnyxStatisticsModel_Table.eventTime, bl);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, int n, int n2, boolean bl) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n)}).and((SQLOperator)OnyxStatisticsModel_Table.status.eq((Object)n2)).orderBy(OnyxStatisticsModel_Table.eventTime, bl);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, String string2, boolean bl) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5short.eq((Object)string2)}).orderBy(OnyxStatisticsModel_Table.eventTime, bl);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, String string2, int n, boolean bl) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.type.eq((Object)n)}).and((SQLOperator)OnyxStatisticsModel_Table.md5short.eq((Object)string2)).orderBy(OnyxStatisticsModel_Table.eventTime, bl);
        List list = where.queryList();
        return list;
    }

    public static String getBookMd5(Context context, String string2) {
        String string3 = "";
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5short.eq((Object)string2)}).limit(1);
        List list = where.queryList();
        if (list != null && list.size() > 0) {
            string3 = ((OnyxStatisticsModel)list.get(0)).getMd5();
        }
        return string3;
    }

    public static List<Integer> getEventHourlyAgg(List<OnyxStatisticsModel> list, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(0);
        }
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            int n2 = onyxStatisticsModel.getEventTime().getHours();
            if (n2 >= arrayList.size()) continue;
            int n3 = (Integer)arrayList.get(n2);
            arrayList.set(n2, ++n3);
        }
        return arrayList;
    }

    public static Book getLongestBook(List<OnyxStatisticsModel> list) {
        Object object;
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        for (OnyxStatisticsModel object22 : list) {
            object = object22.getMd5short();
            long l = object22.getDurationTime();
            if (hashMap.containsKey(object)) {
                l = (Long)hashMap.get(object);
                l += object22.getDurationTime().longValue();
            }
            hashMap.put(object, l);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)MapUtils.sortByValue(hashMap);
        Book book = new Book();
        object = MapUtils.getLast((Map)linkedHashMap);
        book.setMd5short((String)object.getKey());
        book.setReadingTime((Long)object.getValue());
        return book;
    }

    public static Book getMostCarefullyBook(List<OnyxStatisticsModel> list) {
        Object object;
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        for (OnyxStatisticsModel object22 : list) {
            object = object22.getMd5short();
            long l = 1L;
            if (hashMap.containsKey(object)) {
                l = (Long)hashMap.get(object);
                ++l;
            }
            hashMap.put(object, l);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)MapUtils.sortByValue(hashMap);
        Book book = new Book();
        object = MapUtils.getLast((Map)linkedHashMap);
        book.setMd5short((String)object.getKey());
        return book;
    }

    public static List<Book> getRecentBooks(List<OnyxStatisticsModel> list, int n) {
        ArrayList<Book> arrayList = new ArrayList<Book>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (OnyxStatisticsModel object : list) {
            if (linkedHashSet.size() >= n) break;
            linkedHashSet.add(object.getMd5short());
        }
        for (String string2 : linkedHashSet) {
            Book book = new Book();
            book.setMd5short(string2);
            arrayList.add(book);
        }
        return arrayList;
    }
}

