/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.EventTypeAggBean;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.StatisticsResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StatisticsUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.DateTimeUtil;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import retrofit2.Response;

public class GetStatisticsRequest
extends BaseCloudRequest {
    private static final String a = "GetStatisticsRequest";
    public static final int RECENT_BOOK_MAX_COUNT = 5;
    private Context b;
    private StatisticsResult c;
    private String d;

    public GetStatisticsRequest(CloudManager cloudManager, Context context, String string2) {
        super(cloudManager);
        this.b = context;
        this.d = string2;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        this.c = new StatisticsResult();
        if (NetworkUtil.isWiFiConnected((Context)this.b)) {
            this.a(cloudManager);
        } else {
            this.a();
        }
    }

    private void a(CloudManager cloudManager) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.d)) {
            return;
        }
        String string2 = NetworkUtil.getMacAddress((Context)this.b);
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return;
        }
        try {
            Response<StatisticsResult> response = this.executeCall(ServiceFactory.getStatisticsService(this.d).getStatistics(string2));
            if (response != null && response.isSuccessful()) {
                this.c = (StatisticsResult)response.body();
                this.c.setMyEventHourlyAgg(this.h());
                if (this.c.isEmpty()) {
                    this.a();
                }
            } else {
                this.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.a();
        }
    }

    private void a() {
        EventTypeAggBean eventTypeAggBean = this.c.getEventTypeAgg();
        this.c.setTotalReadTime(this.b());
        eventTypeAggBean.setRead(this.c());
        eventTypeAggBean.setFinish(this.d());
        eventTypeAggBean.setAnnotation(this.f());
        eventTypeAggBean.setTextSelect(this.g());
        this.c.setMyEventHourlyAgg(this.h());
        this.c.setDailyAvgReadTime(this.i());
        this.c.setLongestReadTimeBook(this.j());
        this.c.setMostCarefulBook(this.k());
        this.c.setRecentReadingBooks(this.getRecentBooks());
    }

    private long b() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 1);
        long l = 0L;
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            l += onyxStatisticsModel.getDurationTime().longValue();
        }
        return l;
    }

    private int c() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 0);
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            hashSet.add(onyxStatisticsModel.getMd5short());
        }
        return hashSet.size();
    }

    private int d() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 6);
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            hashSet.add(onyxStatisticsModel.getMd5short());
        }
        return hashSet.size();
    }

    private int e() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 3);
        return list.size();
    }

    private int f() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 2);
        return list.size();
    }

    private int g() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 4);
        return list.size();
    }

    private List<Integer> h() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, date);
        return StatisticsUtils.getEventHourlyAgg(list, 24);
    }

    private long i() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        HashSet<String> hashSet = new HashSet<String>();
        long l = 0L;
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, date, 1);
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            hashSet.add(DateTimeUtil.formatDate((Date)onyxStatisticsModel.getEventTime(), (SimpleDateFormat)DateTimeUtil.DATE_FORMAT_YYYYMMDD));
            l += onyxStatisticsModel.getDurationTime().longValue();
        }
        if (hashSet.size() == 0) {
            return 0L;
        }
        long l2 = l / (long)hashSet.size();
        if (l2 > 36000000L) {
            Log.d((String)a, (String)("statisticsModels:" + JSON.toJSONString((Object)list)));
            Log.d((String)a, (String)("days: " + JSON.toJSONString(hashSet) + "-------readTimes: " + l + "------date: " + date));
        }
        return l2;
    }

    private Book j() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 1);
        Book book = StatisticsUtils.getLongestBook(list);
        if (book == null) {
            return null;
        }
        String string2 = book.getMd5short();
        list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.b, string2, 0, true);
        if (list != null && list.size() > 0) {
            book.setBegin(((OnyxStatisticsModel)list.get(0)).getEventTime());
        }
        if ((list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.b, string2, true)) != null && list.size() > 0) {
            book.setEnd(((OnyxStatisticsModel)list.get(list.size() - 1)).getEventTime());
        }
        if ((list = (List)StatisticsUtils.loadStatisticsListByMd5short(this.b, string2)).size() > 0) {
            book.setName(((OnyxStatisticsModel)list.get(0)).getName());
        }
        return book;
    }

    private Book k() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.b, 3);
        list.addAll(StatisticsUtils.loadStatisticsList(this.b, 2));
        list.addAll(StatisticsUtils.loadStatisticsList(this.b, 4));
        Book book = StatisticsUtils.getMostCarefullyBook(list);
        if (book == null) {
            return null;
        }
        String string2 = book.getMd5short();
        list = (List)StatisticsUtils.loadStatisticsList(this.b, string2, 3);
        book.setLookupDic(list.size());
        list = (List)StatisticsUtils.loadStatisticsList(this.b, string2, 2);
        book.setAnnotation(list.size());
        list = (List)StatisticsUtils.loadStatisticsList(this.b, string2, 4);
        book.setTextSelect(list.size());
        list = (List)StatisticsUtils.loadStatisticsListByMd5short(this.b, string2);
        if (list.size() > 0) {
            book.setName(((OnyxStatisticsModel)list.get(0)).getName());
        }
        return book;
    }

    public List<Book> getRecentBooks() {
        List list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.b, 0, false);
        List<Book> list2 = StatisticsUtils.getRecentBooks(list, 5);
        for (Book book : list2) {
            String string2 = book.getMd5short();
            list = (List)StatisticsUtils.loadStatisticsListByMd5short(this.b, string2);
            if (list.size() > 0) {
                book.setName(((OnyxStatisticsModel)list.get(0)).getName());
            }
            Date date = null;
            Date date2 = null;
            list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.b, string2, 0, false);
            if (list != null && list.size() > 0) {
                date = ((OnyxStatisticsModel)list.get(0)).getEventTime();
                book.setBegin(date);
            }
            if ((list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.b, string2, false)) != null && list.size() > 0) {
                date2 = ((OnyxStatisticsModel)list.get(0)).getEventTime();
                book.setEnd(date2);
            }
            long l = 0L;
            if (date != null) {
                list = (List)StatisticsUtils.loadStatisticsList(this.b, string2, 1, date);
                for (OnyxStatisticsModel onyxStatisticsModel : list) {
                    l += onyxStatisticsModel.getDurationTime().longValue();
                }
            }
            if (l <= 0L && date != null & date2 != null) {
                l = date2.getTime() - date.getTime();
            }
            book.setReadingTime(Math.max(l, 0L));
        }
        return list2;
    }

    public StatisticsResult getStatisticsResult() {
        return this.c;
    }
}

