/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Annotation_Table;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Bookmark_Table;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Library_Table;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LocalDataProvider
implements DataProviderBase {
    @Override
    public void clearMetadata() {
        Delete.table(Metadata.class, (SQLOperator[])new SQLOperator[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByIdString(Context context, String string) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.idString.eq((Object)string)}).querySingle());
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByPath(Context context, String string) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.nativeAbsolutePath.eq((Object)string)}).querySingle());
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByHashTag(Context context, String string, String string2) {
        Metadata metadata = null;
        try {
            if (StringUtils.isNullOrEmpty((String)string2)) {
                string2 = FileUtils.computeMD5((File)new File(string));
            }
            metadata = (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[0]).or((SQLOperator)Metadata_Table.hashTag.eq((Object)string2)).or((SQLOperator)Metadata_Table.nativeAbsolutePath.eq((Object)string)).querySingle());
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    @Override
    public QueryResult<Metadata> findMetadataResultByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = new QueryResult<Metadata>();
        queryResult.list = this.findMetadataByQueryArgs(context, queryArgs);
        queryResult.count = this.count(context, queryArgs);
        return queryResult;
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        if (queryArgs.conditionGroup != null) {
            Where where = new Select(queryArgs.propertyList.toArray(new IProperty[0])).from(Metadata.class).where(new SQLOperator[]{queryArgs.conditionGroup});
            for (OrderBy orderBy : queryArgs.orderByList) {
                where.orderBy(orderBy);
            }
            return where.offset(queryArgs.offset).limit(queryArgs.limit).queryList();
        }
        return new ArrayList<Metadata>();
    }

    @Override
    public long count(Context context, QueryArgs queryArgs) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(Metadata.class).where(new SQLOperator[]{queryArgs.conditionGroup}).count();
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.save();
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        metadata.delete();
    }

    @Override
    public boolean saveDocumentOptions(Context context, String string, String string2, String string3) {
        try {
            Metadata metadata = this.findMetadataByHashTag(context, string, string2);
            metadata.setExtraAttributes(string3);
            if (!metadata.hasValidId()) {
                metadata.setNativeAbsolutePath(string);
                metadata.setHashTag(string2);
                metadata.save();
            } else {
                metadata.update();
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public final List<Annotation> loadAnnotations(String string, String string2, int n, OrderBy orderBy) {
        return new Select(new IProperty[0]).from(Annotation.class).where(new SQLOperator[]{Annotation_Table.idString.eq((Object)string2)}).and((SQLOperator)Annotation_Table.application.eq((Object)string)).and((SQLOperator)Annotation_Table.pageNumber.eq((Object)n)).orderBy(orderBy).queryList();
    }

    @Override
    public final List<Annotation> loadAnnotations(String string, String string2, OrderBy orderBy) {
        return new Select(new IProperty[0]).from(Annotation.class).where(new SQLOperator[]{Annotation_Table.idString.eq((Object)string2)}).and((SQLOperator)Annotation_Table.application.eq((Object)string)).orderBy(orderBy).queryList();
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        annotation.save();
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
        annotation.save();
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
        annotation.delete();
    }

    @Override
    public final Bookmark loadBookmark(String string, String string2, int n) {
        return (Bookmark)((Object)new Select(new IProperty[0]).from(Bookmark.class).where(new SQLOperator[]{Bookmark_Table.idString.eq((Object)string2)}).and((SQLOperator)Bookmark_Table.application.eq((Object)string)).and((SQLOperator)Bookmark_Table.pageNumber.eq((Object)n)).querySingle());
    }

    @Override
    public final List<Bookmark> loadBookmarks(String string, String string2, OrderBy orderBy) {
        return new Select(new IProperty[0]).from(Bookmark.class).where(new SQLOperator[]{Bookmark_Table.idString.eq((Object)string2)}).and((SQLOperator)Bookmark_Table.application.eq((Object)string)).orderBy(orderBy).queryList();
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
        bookmark.save();
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
        bookmark.delete();
    }

    private Operator a(Property<String> property, String string) {
        return string == null ? property.isNull() : property.eq((Object)string);
    }

    private Operator b(Property<String> property, String string) {
        return string == null ? property.isNotNull() : property.eq((Object)string);
    }

    @Override
    public Library loadLibrary(String string) {
        return (Library)((Object)new Select(new IProperty[0]).from(Library.class).where(new SQLOperator[]{Library_Table.idString.eq((Object)string)}).querySingle());
    }

    @Override
    public QueryResult<Library> fetchAllLibrary(String string, QueryArgs queryArgs) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        queryResult.list = this.loadAllLibrary(queryArgs.libraryUniqueId, queryArgs);
        queryResult.count = CollectionUtils.getSize(queryResult.list);
        return queryResult;
    }

    @Override
    public List<Library> loadAllLibrary(String string, QueryArgs queryArgs) {
        Operator operator = this.a(Library_Table.parentUniqueId, string);
        return new Select(new IProperty[0]).from(Library.class).where(new SQLOperator[]{operator}).queryList();
    }

    @Override
    public void addLibrary(Library library) {
        library.save();
    }

    @Override
    public void updateLibrary(Library library) {
        library.update();
    }

    @Override
    public void deleteLibrary(Library library) {
        library.delete();
    }

    @Override
    public void clearLibrary() {
        Delete.table(Library.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void clearThumbnails() {
        Delete.table(Thumbnail.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void saveThumbnailEntry(Context context, Thumbnail thumbnail) {
        thumbnail.save();
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String string, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        return (Thumbnail)((Object)new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLOperator[0]).and((SQLOperator)Thumbnail_Table.idString.eq((Object)string)).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)thumbnailKind)).querySingle());
    }

    @Override
    public void deleteThumbnailEntry(Thumbnail thumbnail) {
        thumbnail.delete();
    }

    @Override
    public boolean saveThumbnailBitmap(Context context, String string, OnyxThumbnail.ThumbnailKind thumbnailKind, Bitmap bitmap) {
        return false;
    }

    @Override
    public boolean removeThumbnailBitmap(Context context, String string, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        new Delete().from(Thumbnail.class).where(new SQLOperator[0]).and((SQLOperator)Thumbnail_Table.idString.eq((Object)string)).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)thumbnailKind)).execute();
        return true;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String string, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        Thumbnail thumbnail = this.getThumbnailEntry(context, string, thumbnailKind);
        if (thumbnail == null || StringUtils.isNullOrEmpty((String)thumbnail.getImageDataPath())) {
            return null;
        }
        return BitmapUtils.loadBitmapFromFile((String)thumbnail.getImageDataPath());
    }

    public List<Thumbnail> loadThumbnail(Context context, String string) {
        return new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLOperator[]{Thumbnail_Table.idString.eq((Object)string)}).queryList();
    }

    @Override
    public void clearMetadataCollection() {
        Delete.table(MetadataCollection.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection metadataCollection) {
        metadataCollection.save();
    }

    @Override
    public void deleteMetadataCollection(Context context, String string, String string2) {
        Where where = SQLite.delete(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)string)});
        if (StringUtils.isNotBlank((String)string2)) {
            where.and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)string2));
        }
        where.execute();
    }

    @Override
    public void deleteMetadataCollection(Context context, String string) {
        new Delete().from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)string)}).execute();
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String string) {
        new Delete().from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.documentUniqueId.eq((Object)string)}).execute();
    }

    @Override
    public void updateMetadataCollection(MetadataCollection metadataCollection) {
        metadataCollection.update();
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String string, String string2) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)string)}).and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)string2)).querySingle());
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String string) {
        return new Select(new IProperty[0]).from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.libraryUniqueId.eq((Object)string)}).queryList();
    }

    @Override
    public MetadataCollection findMetadataCollection(Context context, String string) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(MetadataCollection.class).where(new SQLOperator[]{MetadataCollection_Table.documentUniqueId.eq((Object)string)}).querySingle());
    }
}

