/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.common.ScreenSaverConfig;
import com.onyx.android.sdk.data.request.common.ScreenSaverRequest;
import com.onyx.android.sdk.rx.RxCallback;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;

public class ScreenSaverManager {
    public static int SCREEN_SAVER_COUNT_LIMIT = 3;
    private static ScreenSaverManager a;
    private ScreenSaverConfig b;

    private ScreenSaverManager() {
    }

    public static ScreenSaverManager init(ScreenSaverConfig screenSaverConfig) {
        a = new ScreenSaverManager();
        ScreenSaverManager.a.b = screenSaverConfig;
        return a;
    }

    public static ScreenSaverManager getInstance() {
        return a;
    }

    public static ScreenSaverConfig getScreenSaverConfig() {
        return ScreenSaverManager.a.b;
    }

    public static String getSourcePicPath(ScreenSaverConfig screenSaverConfig, String string) {
        File file = new File(screenSaverConfig.sourcePicPathString);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory()) {
            return new File(screenSaverConfig.sourcePicPathString, string).getAbsolutePath();
        }
        if (file.isFile()) {
            if (StringUtils.isNullOrEmpty((String)string)) {
                return screenSaverConfig.sourcePicPathString;
            }
            return new File(FileUtils.getParent((String)screenSaverConfig.sourcePicPathString), string).getAbsolutePath();
        }
        return screenSaverConfig.sourcePicPathString;
    }

    public static void setAllScreenSaver(Context context, DataManager dataManager, ScreenSaverConfig screenSaverConfig, RxCallback rxCallback) {
        for (int i = screenSaverConfig.screenSaverInitialNumber; i < screenSaverConfig.screenSaverInitialNumber + SCREEN_SAVER_COUNT_LIMIT; ++i) {
            ScreenSaverConfig screenSaverConfig2 = screenSaverConfig.copy();
            screenSaverConfig2.targetPicPathString = screenSaverConfig2.createTargetPicPath(i);
            ScreenSaverManager.setOneScreenSaver(context, dataManager, screenSaverConfig2, rxCallback);
        }
    }

    public static void setOneScreenSaver(Context context, DataManager dataManager, ScreenSaverConfig screenSaverConfig, RxCallback rxCallback) {
        ScreenSaverRequest screenSaverRequest = new ScreenSaverRequest(dataManager, screenSaverConfig);
        dataManager.submit(context, screenSaverRequest, rxCallback);
    }
}

