/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.onyx.android.sdk.data.request.cloud.CloudFileDownloadRequest;
import com.onyx.android.sdk.data.utils.DownloadListener;
import com.onyx.android.sdk.data.utils.NotificationItem;
import com.onyx.android.sdk.rx.RxCallback;
import java.util.LinkedHashMap;

public class OnyxDownloadManager {
    private static int a = 1200;
    private static OnyxDownloadManager b;
    private static Context c;
    private FileDownloadNotificationHelper<NotificationItem> d = new FileDownloadNotificationHelper();
    private LinkedHashMap<Object, BaseDownloadTask> e = new LinkedHashMap();

    private OnyxDownloadManager() {
    }

    public static void init(Context context) {
        c = context;
        FileDownloader.init((Context)c);
        FileDownloader.getImpl().setMaxNetworkThreadCount(5);
    }

    public static synchronized OnyxDownloadManager getInstance() {
        if (b == null) {
            b = new OnyxDownloadManager();
        }
        return b;
    }

    public static synchronized Context getContext() {
        return FileDownloadHelper.getAppContext();
    }

    public CloudFileDownloadRequest createDownloadRequest(String string, String string2, Object object) {
        CloudFileDownloadRequest cloudFileDownloadRequest = new CloudFileDownloadRequest(null, string, string2, object);
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)string, (String)string2));
        return cloudFileDownloadRequest;
    }

    public DownloadListener createDownloadListener(CloudFileDownloadRequest cloudFileDownloadRequest, RxCallback rxCallback) {
        return new DownloadListener(cloudFileDownloadRequest, rxCallback, this.d);
    }

    public DownloadListener createDownloadListener(NotificationItem.NotificationBean notificationBean, CloudFileDownloadRequest cloudFileDownloadRequest, RxCallback rxCallback) {
        DownloadListener downloadListener = this.createDownloadListener(cloudFileDownloadRequest, rxCallback);
        downloadListener.setNotificationBean(notificationBean);
        return downloadListener;
    }

    public BaseDownloadTask download(Context context, String string, String string2, Object object, RxCallback rxCallback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(string, string2, object);
        cloudFileDownloadRequest.setContext(context);
        return this.download(cloudFileDownloadRequest, rxCallback);
    }

    public BaseDownloadTask download(CloudFileDownloadRequest cloudFileDownloadRequest, RxCallback rxCallback) {
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)cloudFileDownloadRequest.getUrl(), (String)cloudFileDownloadRequest.getPath()));
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        baseDownloadTask.setListener((FileDownloadListener)this.createDownloadListener(cloudFileDownloadRequest, rxCallback));
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(String string, String string2, Object object, NotificationItem.NotificationBean notificationBean, RxCallback rxCallback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(string, string2, object);
        DownloadListener downloadListener = this.createDownloadListener(notificationBean, cloudFileDownloadRequest, rxCallback);
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(CloudFileDownloadRequest cloudFileDownloadRequest, NotificationItem.NotificationBean notificationBean, RxCallback rxCallback) {
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)cloudFileDownloadRequest.getUrl(), (String)cloudFileDownloadRequest.getPath()));
        DownloadListener downloadListener = this.createDownloadListener(notificationBean, cloudFileDownloadRequest, rxCallback);
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public int downloadDirectly(Context context, String string, String string2, Object object, RxCallback rxCallback) {
        return this.startDownload(this.download(context, string, string2, object, rxCallback));
    }

    public int downloadDirectly(CloudFileDownloadRequest cloudFileDownloadRequest, RxCallback rxCallback) {
        return this.startDownload(this.download(cloudFileDownloadRequest, rxCallback));
    }

    public int startDownload(BaseDownloadTask baseDownloadTask) {
        baseDownloadTask.setCallbackProgressMinInterval(a);
        return baseDownloadTask.start();
    }

    public int startDownload(BaseDownloadTask baseDownloadTask, int n) {
        baseDownloadTask.setCallbackProgressMinInterval(n);
        return baseDownloadTask.start();
    }

    public void removeTask(Object object) {
        this.e.remove(object);
    }

    public void addTask(Object object, BaseDownloadTask baseDownloadTask) {
        this.e.put(object, baseDownloadTask);
    }

    public BaseDownloadTask getTask(Object object) {
        return this.e.get(object);
    }

    public void clearTaskQueue() {
        this.e.clear();
    }

    public int getTaskProgress(int n) {
        return (int)((float)FileDownloader.getImpl().getSoFar(n) * 1.0f / (float)FileDownloader.getImpl().getTotal(n) * 100.0f);
    }

    public int getTaskStatus(int n, String string) {
        return FileDownloader.getImpl().getStatus(n, string);
    }

    public void pauseTask(Object object, boolean bl) {
        BaseDownloadTask baseDownloadTask = this.getTask(object);
        if (baseDownloadTask == null) {
            return;
        }
        baseDownloadTask.pause();
        if (bl) {
            this.removeTask(object);
        }
    }
}

