/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.data.db.OnyxCloudDatabase;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.model.Dictionary;
import com.onyx.android.sdk.data.model.DownloadLink;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.transaction.ProcessDeleteModel;
import com.onyx.android.sdk.data.transaction.ProcessSaveModel;
import com.onyx.android.sdk.data.transaction.ProcessUpdateModel;
import com.onyx.android.sdk.data.utils.CloudUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.InternalAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.FastStoreModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.ProcessModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.ArrayList;
import java.util.List;

public class StoreUtils {
    public static final int PROCESS_SAVE = 0;
    public static final int PROCESS_DELETE = 1;
    public static final int PROCESS_UPDATE = 2;

    public static <T extends BaseData> ProcessModelTransaction.ProcessModel<T> getProcessModel(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = new ProcessSaveModel();
                break;
            }
            case 2: {
                object = new ProcessUpdateModel();
                break;
            }
            case 1: {
                object = new ProcessDeleteModel();
                break;
            }
            default: {
                object = new ProcessSaveModel();
            }
        }
        return object;
    }

    public static <T extends BaseData> void processOnAsync(List<T> list, final int n, ProcessModelTransaction.OnModelProcessListener<T> onModelProcessListener) {
        ProcessModelTransaction processModelTransaction = new ProcessModelTransaction.Builder(new ProcessModelTransaction.ProcessModel<T>(){

            public void a(T t, DatabaseWrapper databaseWrapper) {
                if (n == 0) {
                    ((BaseData)((Object)t)).save();
                } else if (n == 1) {
                    t.delete();
                } else if (n == 2) {
                    t.update();
                }
            }

            public /* synthetic */ void processModel(Object object, DatabaseWrapper databaseWrapper) {
                this.a((Object)((Object)((BaseData)((Object)object))), databaseWrapper);
            }
        }).processListener(onModelProcessListener).addAll(list).build();
        Transaction transaction = FlowManager.getDatabase(OnyxCloudDatabase.class).beginTransactionAsync((ITransaction)processModelTransaction).build();
        transaction.execute();
    }

    public static <T extends BaseData> void saveToLocal(Class<?> clazz, List<T> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase(clazz).getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (BaseData baseData : list) {
            baseData.save();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static <T extends BaseData> void saveToLocal(ProductResult<T> productResult, Class<T> clazz, boolean bl) {
        if (StoreUtils.clearTable(productResult, clazz, bl)) {
            StoreUtils.processOnAsync(productResult.list, 0, null);
        }
    }

    public static <T extends BaseData> void saveToLocal(List<T> list, Class<T> clazz, boolean bl) {
        if (bl) {
            StoreUtils.clearTable(clazz);
        }
        StoreUtils.processOnAsync(list, 0, null);
    }

    public static <T extends BaseData> void saveToLocalFast(ProductResult<T> productResult, Class<T> clazz, boolean bl) {
        if (StoreUtils.clearTable(productResult, clazz, bl)) {
            StoreUtils.saveToLocalFast(productResult.list, clazz);
        }
    }

    public static <T extends BaseData> void saveToLocalFast(List<T> list, Class<T> clazz, boolean bl) {
        if (bl) {
            if (list.size() <= 0) {
                return;
            }
            StoreUtils.clearTable(clazz);
        }
        StoreUtils.saveToLocalFast(list, clazz);
    }

    public static <T extends BaseData> void saveToLocalFast(List<T> list, Class<T> clazz) {
        StoreUtils.a(FastStoreModelTransaction.saveBuilder((InternalAdapter)FlowManager.getModelAdapter(clazz)), list);
    }

    public static <T extends BaseData> void updateToLocalFast(List<T> list, Class<T> clazz) {
        StoreUtils.a(FastStoreModelTransaction.updateBuilder((InternalAdapter)FlowManager.getModelAdapter(clazz)), list);
    }

    private static <T extends BaseData> void a(FastStoreModelTransaction.Builder<T> builder, List<T> list) {
        builder.addAll(list).build().execute(FlowManager.getWritableDatabase(OnyxCloudDatabase.class));
    }

    public static <T extends BaseData> boolean clearTable(ProductResult<T> productResult, Class<T> clazz, boolean bl) {
        if (CloudUtils.isEmpty(productResult)) {
            return false;
        }
        if (bl) {
            StoreUtils.clearTable(clazz);
        }
        return true;
    }

    public static <T extends BaseModel> void clearTable(Class<T> clazz) {
        SQLite.delete(clazz).execute();
    }

    public static <T extends BaseModel> void clearAllTable() {
        StoreUtils.clearTable(Product.class);
        StoreUtils.clearTable(Dictionary.class);
        StoreUtils.clearTable(Category.class);
        StoreUtils.clearTable(DownloadLink.class);
    }

    public static <T extends BaseModel> List<T> queryDataList(Class<T> clazz, int n) {
        return SQLite.select((IProperty[])new IProperty[0]).from(clazz).limit(n).queryList();
    }

    public static <T extends BaseModel> List<T> queryDataList(Class<T> clazz) {
        return SQLite.select((IProperty[])new IProperty[0]).from(clazz).queryList();
    }

    public static <T extends BaseModel> T queryDataSingle(Class<T> clazz) {
        return (T)((BaseModel)SQLite.select((IProperty[])new IProperty[0]).from(clazz).querySingle());
    }

    public static <T extends BaseModel> List<T> queryDataList(Class<T> clazz, OrderBy ... orderByArray) {
        Where where = SQLite.select((IProperty[])new IProperty[0]).from(clazz).where(new SQLOperator[0]);
        for (OrderBy orderBy : orderByArray) {
            where.orderBy(orderBy);
        }
        return where.queryList();
    }

    public static <T extends BaseModel> T queryDataSingle(Class<T> clazz, SQLOperator ... sQLOperatorArray) {
        return (T)((BaseModel)SQLite.select((IProperty[])new IProperty[0]).from(clazz).where(new SQLOperator[0]).andAll(sQLOperatorArray).querySingle());
    }

    public static <T extends BaseModel> T queryDataSingle(Class<T> clazz, OrderBy ... orderByArray) {
        Where where = SQLite.select((IProperty[])new IProperty[0]).from(clazz).where(new SQLOperator[0]);
        for (OrderBy orderBy : orderByArray) {
            where.orderBy(orderBy);
        }
        return (T)((BaseModel)where.querySingle());
    }

    public static <T extends BaseModel> long queryDataCount(Class<T> clazz) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(clazz).count();
    }

    public static <T extends BaseModel> long queryDataCount(Class<T> clazz, Operator ... operatorArray) {
        Where where = new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(clazz).where(new SQLOperator[0]);
        if (operatorArray != null && operatorArray.length > 0) {
            where.andAll((SQLOperator[])operatorArray);
        }
        return where.count();
    }

    public static <T extends BaseData> void saveAsyncSingle(BaseData baseData) {
        baseData.async().save();
    }

    public static <T extends BaseData> boolean isEmpty(ProductResult<T> productResult) {
        return productResult == null || productResult.list == null || productResult.list.size() <= 0;
    }

    public static <T extends BaseData> List<T> getResultList(ProductResult<T> productResult) {
        if (StoreUtils.isEmpty(productResult)) {
            return new ArrayList();
        }
        return productResult.list;
    }
}

