/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.AppDataInfo;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.common.AppPreference;
import com.onyx.android.sdk.data.provider.SystemConfigProvider;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.utils.ApplicationUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.onyx.android.sdk.utils.ViewDocumentUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class FileOpenWithRequest
extends BaseFSRequest {
    private File a;
    private String b;
    private Map<String, String> c = new HashMap<String, String>();
    private Map<String, JSONArray> d = new HashMap<String, JSONArray>();
    private List<String> e = new ArrayList<String>();
    private List<AppDataInfo> f = new ArrayList<AppDataInfo>();
    private int g = -1;

    public FileOpenWithRequest(File file, Map<String, JSONArray> map, List<String> list) {
        this.a = file;
        this.d = map;
        this.e = list;
    }

    public void setDefaultMimeType(String string2) {
        this.b = string2;
    }

    public void setCustomizedIconAppsMap(Map<String, String> map) {
        this.c = map;
    }

    public int getPreferenceIndex() {
        return this.g;
    }

    public List<AppDataInfo> getAppInfoList() {
        return this.f;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.a(this.a);
    }

    private void a(File file) {
        List<ResolveInfo> list = this.d(file);
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        AppPreference appPreference = this.a(this.getContext(), file);
        for (ResolveInfo resolveInfo : list) {
            AppDataInfo appDataInfo = this.a(resolveInfo);
            if (appDataInfo != null) {
                this.f.add(appDataInfo);
            }
            if (appPreference == null || !resolveInfo.activityInfo.packageName.equalsIgnoreCase(appPreference.packageName)) continue;
            this.g = CollectionUtils.getSize(this.f) - 1;
        }
    }

    private AppDataInfo a(ResolveInfo resolveInfo) {
        AppDataInfo appDataInfo = ApplicationUtil.appDataFromApplicationInfo((ActivityInfo)resolveInfo.activityInfo, (PackageInfo)ApplicationUtil.getPackageInfoFromPackageName((Context)this.getContext(), (String)resolveInfo.activityInfo.packageName), (PackageManager)this.getContext().getPackageManager());
        if (appDataInfo != null) {
            appDataInfo.intent = ViewDocumentUtils.mimeTypeIntent((File)this.a);
            appDataInfo.intent.setComponent(new ComponentName(appDataInfo.packageName, appDataInfo.activityClassName));
            ApplicationUtil.checkCustomIcon((Context)this.getContext(), this.c, (AppDataInfo)appDataInfo);
        }
        return appDataInfo;
    }

    private boolean a(String string2) {
        return CollectionUtils.safelyReverseContains(this.e, (String)string2);
    }

    private boolean a(JSONArray jSONArray, String string2) {
        if (jSONArray == null) {
            return false;
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            if (!jSONArray.getString(i).equals(string2)) continue;
            return true;
        }
        return false;
    }

    private JSONArray b(File file) {
        String string2 = FilenameUtils.getExtension((String)file.getName()).toLowerCase(Locale.getDefault());
        JSONArray jSONArray = null;
        if (!CollectionUtils.isNullOrEmpty(this.d)) {
            jSONArray = this.d.get(string2);
        }
        return jSONArray;
    }

    private List<ResolveInfo> c(File file) {
        Intent intent = ViewDocumentUtils.mimeTypeIntent((File)file);
        if (StringUtils.isNotBlank((String)this.b)) {
            intent.setDataAndType(intent.getData(), this.b);
        }
        if (this.a(intent.getType())) {
            return null;
        }
        return this.getContext().getPackageManager().queryIntentActivities(intent, 65536);
    }

    private List<ResolveInfo> d(File file) {
        List<ResolveInfo> list = this.c(file);
        if (CollectionUtils.isNullOrEmpty(list)) {
            return list;
        }
        ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        JSONArray jSONArray = this.b(file);
        for (ResolveInfo resolveInfo : list) {
            if (this.a(jSONArray, resolveInfo.activityInfo.packageName) || hashSet.contains(resolveInfo.activityInfo.packageName)) continue;
            arrayList.add(resolveInfo);
            hashSet.add(resolveInfo.activityInfo.packageName);
        }
        return arrayList;
    }

    private AppPreference a(Context context, File file) {
        String string2;
        List<AppPreference> list;
        Map<String, AppPreference> map = AppPreference.getFileAppPreferMap();
        if (CollectionUtils.isNullOrEmpty(map) && !CollectionUtils.isNullOrEmpty(list = JSONObjectParseUtils.parseObject(string2 = SystemConfigProvider.getStringValue(context, "sys.app_preference"), new TypeReference<List<AppPreference>>(){}, new Feature[0]))) {
            AppPreference.addAppPreferencesToMap(list);
        }
        return map.get(FilenameUtils.getExtension((String)file.getName()));
    }
}

