/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudContentRefreshRequest
extends BaseCloudRequest {
    private QueryArgs a;
    private QueryResult<Library> b;
    private QueryResult<Metadata> c;
    private Map<String, CloseableReference<Bitmap>> d = new HashMap<String, CloseableReference<Bitmap>>();

    public CloudContentRefreshRequest(QueryArgs queryArgs) {
        this.a = queryArgs;
    }

    public QueryResult<Metadata> getProductResult() {
        return this.c;
    }

    public QueryResult<Library> getLibraryResult() {
        return this.b;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        this.a(this.a);
        this.b = this.a(cloudManager);
        this.c = DataManagerHelper.cloudMetadataFromDataProvider(this.getContext(), cloudManager.getCloudDataProvider(), this.a);
        if (this.c == null || this.c.hasException()) {
            return;
        }
        this.a(this.getContext(), cloudManager.getCloudDataProvider(), this.a.libraryUniqueId);
        if (this.c.isContentEmpty()) {
            this.a(cloudManager.getCacheManager(), this.a);
            return;
        }
        this.a(cloudManager.getCacheManager(), this.a, this.c);
        DataManagerHelper.saveCloudMetadataAndCollection(this.getContext(), cloudManager.getCloudDataProvider(), this.a, this.c);
        this.d = DataManagerHelper.loadCloudThumbnailBitmapsWithCache(this.getContext(), cloudManager, this.c.list);
    }

    private void a(QueryArgs queryArgs) {
        if (!FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy)) {
            queryArgs.useCloudOnlyPolicy();
        }
    }

    private QueryResult<Library> a(CloudManager cloudManager) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        queryResult.list = DataManagerHelper.fetchLibraryLibraryList(this.getContext(), cloudManager.getCloudDataProvider(), this.a);
        queryResult.count = CollectionUtils.getSize(queryResult.list);
        return queryResult;
    }

    private void a(Context context, DataProviderBase dataProviderBase, String string2) {
        dataProviderBase.deleteMetadataCollection(context, string2);
    }

    private void a(CacheManager cacheManager, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        List<Metadata> list = Arrays.asList(new Metadata[(int)queryResult.count]);
        cacheManager.addToMetadataCache(CacheManager.generateCloudKey(queryArgs), list);
        DataManagerHelper.updateCloudCacheList(list, queryResult, queryArgs);
    }

    private void a(CacheManager cacheManager, QueryArgs queryArgs) {
        cacheManager.clearMetadataCache(CacheManager.generateCloudKey(queryArgs));
    }

    public Map<String, CloseableReference<Bitmap>> getThumbnailMap() {
        return this.d;
    }
}

