/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.model.Link;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.PushProduct;
import com.onyx.android.sdk.data.model.PushProduct_Table;
import com.onyx.android.sdk.data.model.PushRecord;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class PushRecordListRequest
extends BaseCloudRequest {
    private boolean a = false;
    private boolean b = false;
    private List<PushRecord> c = new ArrayList<PushRecord>();
    private List<PushProduct> d = new ArrayList<PushProduct>();
    private List<Link> e = new ArrayList<Link>();

    public PushRecordListRequest(boolean bl, boolean bl2) {
        this.b = bl2;
        this.a = bl;
    }

    public List<PushProduct> getProductList() {
        return this.d;
    }

    public List<Link> getLinkList() {
        return this.e;
    }

    public List<PushRecord> getRecordList() {
        return this.c;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        if (!this.a) {
            this.fetchFromLocalCache(cloudManager);
            return;
        }
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(cloudManager);
        } else {
            this.fetchFromLocalCache(cloudManager);
        }
    }

    public void fetchFromLocalCache(CloudManager cloudManager) throws Exception {
        this.d = this.a();
        this.a(this.getContext(), this.d);
        this.a(this.d, cloudManager.getCloudConf().getCloudStorage());
    }

    public void fetchFromCloud(CloudManager cloudManager) throws Exception {
        ProductResult productResult;
        Response<ProductResult<PushRecord>> response = this.executeCall(ServiceFactory.getPushService(cloudManager.getCloudConf().getApiBase()).pushRecordList(this.getAccountSessionToken()));
        if (response.isSuccessful() && !StoreUtils.isEmpty(productResult = (ProductResult)response.body())) {
            this.c = productResult.list;
            for (PushRecord pushRecord : productResult.list) {
                PushProduct pushProduct = pushRecord.parsePushProduct();
                if (pushProduct == null) continue;
                this.d.add(pushProduct);
            }
            if (this.b && this.d.size() > 0) {
                this.a(this.d);
            }
            this.a(this.getContext(), this.d);
            this.a(this.d, cloudManager.getCloudConf().getCloudStorage());
        }
    }

    private void a(List<PushProduct> list) {
        List<PushProduct> list2 = this.a();
        if (!CollectionUtils.isNullOrEmpty(list2)) {
            block0: for (PushProduct pushProduct : list2) {
                for (PushProduct pushProduct2 : list) {
                    if (!StringUtils.isNotBlank((String)pushProduct.getGuid()) || !pushProduct.getGuid().equals(pushProduct2.getGuid())) continue;
                    pushProduct2.setIdString(pushProduct.getIdString());
                    continue block0;
                }
            }
        }
        StoreUtils.saveToLocal(list, PushProduct.class, true);
    }

    private void a(Context context, List<PushProduct> list) {
        for (PushProduct pushProduct : list) {
            boolean bl = false;
            Metadata metadata = DataManagerHelper.getMetadataByCloudReference(context, pushProduct.getGuid());
            if (metadata == null && StringUtils.isNotBlank((String)pushProduct.getIdString())) {
                metadata = DataManagerHelper.getMetadataByHashTag(context, pushProduct.getIdString());
            }
            if (metadata != null) {
                File file = new File(metadata.getNativeAbsolutePath());
                bl = file.exists();
            }
            pushProduct.isFiLeExist = bl;
        }
    }

    private void a(List<PushProduct> list, String string2) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (PushProduct pushProduct : list) {
            Link link = pushProduct.getFirstDownloadLink();
            if (link == null) {
                link = new Link();
            }
            this.e.add(link);
        }
    }

    private List<PushProduct> a() {
        return StoreUtils.queryDataList(PushProduct.class, OrderBy.fromProperty(PushProduct_Table.createdAt).descending());
    }
}

