/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductQuery;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import retrofit2.Response;

public class ProductListRequest
extends BaseCloudRequest {
    private static final String a = ProductListRequest.class.getSimpleName();
    private ProductQuery b;
    private ProductResult<Product> c;
    private volatile boolean d;
    private volatile boolean e;

    public ProductListRequest(ProductQuery productQuery, boolean bl, boolean bl2) {
        this.b = productQuery;
        this.d = bl;
        this.e = bl2;
    }

    public final ProductResult<Product> getProductResult() {
        return this.c;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(cloudManager);
        } else if (!this.e) {
            this.fetchFromLocalCache(cloudManager);
        }
    }

    public void fetchFromLocalCache(CloudManager cloudManager) throws Exception {
        this.c = new ProductResult();
        this.c.list = StoreUtils.queryDataList(Product.class);
        this.c.count = this.c.list.size();
    }

    public void fetchFromCloud(CloudManager cloudManager) throws Exception {
        String string2 = JSON.toJSONString((Object)this.b);
        Response<ProductResult<Product>> response = this.executeCall(ServiceFactory.getBookStoreService(cloudManager.getCloudConf().getApiBase()).bookList(string2));
        if (response.isSuccessful()) {
            this.c = (ProductResult)response.body();
            if (this.isSaveToLocal()) {
                this.a(this.c);
            }
        }
    }

    private void a(ProductResult<Product> productResult) {
        StoreUtils.saveToLocal(productResult, Product.class, this.d);
    }
}

