/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.annotation.ColumnIgnore;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Metadata
extends BaseData {
    public static final String PROGRESS_DIVIDER = "/";
    private String name = null;
    private String title = null;
    private String authors = null;
    private String publisher = null;
    private String language = null;
    private String ISBN = null;
    private String description = null;
    private String location = null;
    private String nativeAbsolutePath = null;
    private long size = 0L;
    private String encoding = null;
    private Date lastAccess = null;
    private Date lastModified = null;
    private String progress = null;
    private int favorite = 0;
    private int rating = 0;
    private String tags = null;
    private String series = null;
    private String extraAttributes = null;
    private String type = null;
    private String cloudId;
    private String parentId;
    private int readingStatus = 0;
    private String hashTag;
    private String storageId;
    private int fetchSource;
    private String coverUrl;
    private int ordinal;
    @ColumnIgnore
    private Map<String, String> bookCovers = new HashMap<String, String>();

    public void setFetchSource(int n) {
        this.fetchSource = n;
    }

    public int getFetchSource() {
        return this.fetchSource;
    }

    public void setCoverUrl(String string2) {
        this.coverUrl = string2;
    }

    public String getCoverUrl() {
        return this.coverUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string2) {
        this.title = string2;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String string2) {
        this.authors = string2;
    }

    public List<String> getAuthorList() {
        return StringUtils.split((String)this.authors, (String)",");
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String string2) {
        this.publisher = string2;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string2) {
        this.language = string2;
    }

    public String getISBN() {
        return this.ISBN;
    }

    public void setISBN(String string2) {
        this.ISBN = string2;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string2) {
        this.description = string2;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string2) {
        this.location = string2;
    }

    public String getNativeAbsolutePath() {
        return this.nativeAbsolutePath;
    }

    public void setNativeAbsolutePath(String string2) {
        this.nativeAbsolutePath = string2;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string2) {
        this.encoding = string2;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Date date) {
        this.lastAccess = date;
    }

    public void updateLastAccess() {
        this.setLastAccess(new Date());
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String string2) {
        this.progress = string2;
    }

    public void setProgress(int n, int n2) {
        this.setProgress(String.format(Locale.getDefault(), "%d/%d", n, n2));
    }

    public int getFavorite() {
        return this.favorite;
    }

    public void setFavorite(int n) {
        this.favorite = n;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int n) {
        this.rating = n;
    }

    public String getTags() {
        return this.tags;
    }

    public List<String> getTagList() {
        return StringUtils.split((String)this.getTags(), (String)",");
    }

    public void setTags(String string2) {
        this.tags = string2;
    }

    public String getSeries() {
        return this.series;
    }

    public List<String> getSerieList() {
        return StringUtils.split((String)this.getSeries(), (String)",");
    }

    public void setSeries(String string2) {
        this.series = string2;
    }

    public String getExtraAttributes() {
        return this.extraAttributes;
    }

    public void setExtraAttributes(String string2) {
        this.extraAttributes = string2;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string2) {
        this.type = string2;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String string2) {
        this.cloudId = string2;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String string2) {
        this.parentId = string2;
    }

    public int getReadingStatus() {
        return this.readingStatus;
    }

    public void setReadingStatus(int n) {
        this.readingStatus = n;
    }

    public String getHashTag() {
        return this.hashTag;
    }

    public void setHashTag(String string2) {
        this.hashTag = string2;
    }

    public void setStorageId(String string2) {
        this.storageId = string2;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int n) {
        this.ordinal = n;
    }

    public Map<String, String> getBookCovers() {
        return this.bookCovers;
    }

    public void setBookCovers(Map<String, String> map) {
        this.bookCovers = map;
    }

    @JSONField(deserialize=false, serialize=false)
    public String getCoverUrl(String string2) {
        if (CollectionUtils.isNullOrEmpty(this.bookCovers)) {
            return null;
        }
        return this.bookCovers.get(string2);
    }

    public static Metadata createFromFile(String string2) {
        return Metadata.createFromFile(new File(string2));
    }

    public static Metadata createFromFile(File file) {
        return Metadata.createFromFile(file, true);
    }

    public static Metadata createFromMetadataPath(Metadata metadata, boolean bl) {
        File file = new File(metadata.getNativeAbsolutePath());
        try {
            if (bl) {
                String string2 = FileUtils.computeMD5((File)file);
                metadata.setHashTag(string2);
            }
            Metadata.getBasicMetadataFromFile(metadata, file);
            return metadata;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Metadata createFromFile(File file, boolean bl) {
        Metadata metadata = new Metadata();
        metadata.setNativeAbsolutePath(file.getAbsolutePath());
        return Metadata.createFromMetadataPath(metadata, bl);
    }

    public static void getBasicMetadataFromFile(Metadata metadata, File file) {
        metadata.setName(file.getName());
        metadata.setIdString(file.getAbsolutePath());
        metadata.setLocation(file.getAbsolutePath());
        metadata.setNativeAbsolutePath(file.getAbsolutePath());
        metadata.setSize(file.length());
        metadata.setLastModified(new Date(FileUtils.getLastChangeTime((File)file)));
        metadata.setType(FileUtils.getFileExtension((String)file.getName()));
    }

    private int parseProgress(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getProgressPercent() {
        if (StringUtils.isNullOrEmpty((String)this.progress)) {
            return 0;
        }
        String[] stringArray = this.progress.split(PROGRESS_DIVIDER);
        if (stringArray.length != 2) {
            return 0;
        }
        int n = this.parseProgress(stringArray[0]);
        int n2 = this.parseProgress(stringArray[1]);
        if (n2 == 0) {
            return 0;
        }
        return n * 100 / n2;
    }

    public boolean internalProgressEqual(String string2) {
        String[] stringArray = string2.split(PROGRESS_DIVIDER);
        if (stringArray.length != 2) {
            return false;
        }
        return stringArray[0].equals(stringArray[1]);
    }

    public String getAssociationId() {
        return this.getHashTag();
    }

    public boolean isFinished() {
        return this.readingStatus == ReadingStatus.FINISHED;
    }

    public boolean isReading() {
        return this.readingStatus == ReadingStatus.READING;
    }

    public boolean isNew() {
        return this.readingStatus == ReadingStatus.NEW;
    }

    public static class FetchSource {
        public static int LOCAL = 0;
        public static int CLOUD = 1;
    }

    public static class ReadingStatus {
        public static int NEW = 0;
        public static int READING = 1;
        public static int FINISHED = 2;
    }
}

