/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import android.os.Build;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.PackageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ApplicationUpdate
extends BaseData {
    public String channel;
    public String packageName;
    public String model;
    public String[] downloadUrlList;
    public Map<String, List<String>> changeLogs;
    public String type;
    public String versionName;
    public int versionCode;
    public int size;
    public String macAddress;
    public String platform;

    public String getFirstDownloadUrl() {
        if (this.downloadUrlList == null || this.downloadUrlList.length <= 0) {
            return null;
        }
        return this.downloadUrlList[0];
    }

    public List<String> getChangeLogList() {
        if (CollectionUtils.isNullOrEmpty(this.changeLogs)) {
            return new ArrayList<String>();
        }
        List<String> list = this.changeLogs.get(Locale.getDefault().toString());
        if (CollectionUtils.isNullOrEmpty(list)) {
            String string2 = Locale.US.toString();
            list = this.changeLogs.get(string2);
        }
        if (list == null) {
            list = new ArrayList<String>();
        }
        return list;
    }

    public static ApplicationUpdate create(Context context) {
        ApplicationUpdate applicationUpdate = new ApplicationUpdate();
        applicationUpdate.versionCode = PackageUtils.getAppVersionCode((Context)context);
        applicationUpdate.versionName = PackageUtils.getAppVersionName((Context)context);
        applicationUpdate.packageName = context.getPackageName();
        applicationUpdate.platform = PackageUtils.getAppPlatform((Context)context);
        applicationUpdate.channel = PackageUtils.getAppChannel((Context)context);
        applicationUpdate.type = PackageUtils.getAppType((Context)context);
        applicationUpdate.model = Build.MODEL;
        return applicationUpdate;
    }
}

