/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.CloudStore;
import com.onyx.android.sdk.data.model.WeChatUserInfo;
import com.onyx.android.sdk.data.request.cloud.AccountGetOAuthCodeRequest;
import com.onyx.android.sdk.data.request.cloud.WeChatOauthRequest;
import com.onyx.android.sdk.data.request.cloud.WeChatUserInfoRequest;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.WXImageObject;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXMusicObject;
import com.tencent.mm.opensdk.modelmsg.WXTextObject;
import com.tencent.mm.opensdk.modelmsg.WXVideoObject;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;

public class WeChatManager {
    public static final String WE_CHAT_LOGIN_OAUTH_ACTION = "we_chat_login_oauth_action";
    private static String a = "";
    private static String b = "";
    private static WeChatManager c;
    private IWXAPI d;
    private String e;

    private WeChatManager(Context context) {
        this.a(context);
    }

    private void a(Context context) {
        this.d = WXAPIFactory.createWXAPI((Context)context, (String)a, (boolean)true);
        this.d.registerApp(a);
    }

    public static WeChatManager sharedInstance(Context context) {
        if (c == null) {
            c = new WeChatManager(context);
        }
        return c;
    }

    public static WeChatManager sharedInstance(Context context, String string, String string2) {
        if (c == null) {
            a = string;
            b = string2;
            c = WeChatManager.sharedInstance(context);
        }
        return c;
    }

    public IWXAPI getWeChatApi() {
        return this.d;
    }

    public void sendWeChatAuthRequest(Context context) {
        if (this.d == null) {
            this.a(context);
        }
        SendAuth.Req req = new SendAuth.Req();
        req.scope = "snsapi_userinfo";
        req.state = "wx_login_onyx";
        this.d.sendReq((BaseReq)req);
    }

    public boolean sendWeChatTokenRequest(CloudStore cloudStore, Context context, BaseCallback baseCallback) {
        if (StringUtils.isNullOrEmpty((String)this.e)) {
            return false;
        }
        WeChatOauthRequest weChatOauthRequest = new WeChatOauthRequest(a, b, this.e);
        cloudStore.submitRequest(context, weChatOauthRequest, baseCallback);
        return true;
    }

    public boolean sendWeChatUserInfoRequest(CloudStore cloudStore, Context context, String string, String string2, BaseCallback baseCallback) {
        if (StringUtils.isNullOrEmpty((String)string) || StringUtils.isNullOrEmpty((String)string2)) {
            return false;
        }
        WeChatUserInfoRequest weChatUserInfoRequest = new WeChatUserInfoRequest(string, string2);
        cloudStore.submitRequest(context, weChatUserInfoRequest, baseCallback);
        return true;
    }

    public boolean sendOnyxOAuthCodeRequest(CloudStore cloudStore, Context context, WeChatUserInfo weChatUserInfo, BaseCallback baseCallback) {
        AccountGetOAuthCodeRequest accountGetOAuthCodeRequest = new AccountGetOAuthCodeRequest("wechat", weChatUserInfo.createOAuthAccountData());
        cloudStore.submitRequest(context, accountGetOAuthCodeRequest, baseCallback);
        return true;
    }

    public void shareText(MediaBuilder mediaBuilder) {
        WXTextObject wXTextObject = new WXTextObject();
        wXTextObject.text = mediaBuilder.getContent();
        WXMediaMessage wXMediaMessage = this.a(mediaBuilder, (WXMediaMessage.IMediaObject)wXTextObject);
        this.sendMessageToWX(wXMediaMessage, mediaBuilder);
    }

    public void shareImage(MediaBuilder mediaBuilder) {
        WXImageObject wXImageObject = new WXImageObject(mediaBuilder.getImageBitmap());
        WXMediaMessage wXMediaMessage = this.a(mediaBuilder, (WXMediaMessage.IMediaObject)wXImageObject);
        this.sendMessageToWX(wXMediaMessage, mediaBuilder);
    }

    public void shareWebPage(MediaBuilder mediaBuilder) {
        WXWebpageObject wXWebpageObject = new WXWebpageObject();
        wXWebpageObject.webpageUrl = mediaBuilder.getUrl();
        WXMediaMessage wXMediaMessage = this.a(mediaBuilder, (WXMediaMessage.IMediaObject)wXWebpageObject);
        this.sendMessageToWX(wXMediaMessage, mediaBuilder);
    }

    public void shareMusic(MediaBuilder mediaBuilder) {
        WXMusicObject wXMusicObject = new WXMusicObject();
        wXMusicObject.musicUrl = mediaBuilder.getUrl();
        WXMediaMessage wXMediaMessage = this.a(mediaBuilder, (WXMediaMessage.IMediaObject)wXMusicObject);
        this.sendMessageToWX(wXMediaMessage, mediaBuilder);
    }

    public void shareVideo(MediaBuilder mediaBuilder) {
        WXVideoObject wXVideoObject = new WXVideoObject();
        wXVideoObject.videoUrl = mediaBuilder.getUrl();
        WXMediaMessage wXMediaMessage = this.a(mediaBuilder, (WXMediaMessage.IMediaObject)wXVideoObject);
        this.sendMessageToWX(wXMediaMessage, mediaBuilder);
    }

    public boolean sendMessageToWX(WXMediaMessage wXMediaMessage, MediaBuilder mediaBuilder) {
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = mediaBuilder.getTransaction() == null ? String.valueOf(System.currentTimeMillis()) : null;
        req.message = wXMediaMessage;
        req.scene = mediaBuilder.getScene();
        return this.getWeChatApi().sendReq((BaseReq)req);
    }

    private WXMediaMessage a(MediaBuilder mediaBuilder, WXMediaMessage.IMediaObject iMediaObject) {
        WXMediaMessage wXMediaMessage = new WXMediaMessage(iMediaObject);
        wXMediaMessage.title = mediaBuilder.getTitle();
        wXMediaMessage.description = mediaBuilder.getDescription();
        Bitmap bitmap = mediaBuilder.buildThumbnailBitmap();
        if (bitmap != null) {
            wXMediaMessage.thumbData = BitmapUtils.bitmapToBytes((Bitmap)bitmap);
        }
        return wXMediaMessage;
    }

    public String getRespCode() {
        return this.e;
    }

    public String getRespCodeAndReset() {
        String string = this.e;
        this.e = null;
        return string;
    }

    public void setRespCode(String string) {
        this.e = string;
    }

    public String getWxAppId() {
        return a;
    }

    public String getWxAppSecret() {
        return b;
    }

    public static class MediaBuilder {
        private static final int a = 180;
        private String b;
        private String c;
        private String d;
        private String e;
        private Bitmap f;
        private int g = 180;
        private int h = 180;
        private int i = 1;
        private String j;

        public MediaBuilder setTitle(String string) {
            this.b = string;
            return this;
        }

        public MediaBuilder setContent(String string) {
            this.c = string;
            return this;
        }

        public MediaBuilder setDescription(String string) {
            this.d = string;
            return this;
        }

        public MediaBuilder setImageBitmap(Bitmap bitmap) {
            this.f = bitmap;
            return this;
        }

        public MediaBuilder setThumbnailSize(int n, int n2) {
            this.g = n;
            this.h = n2;
            return this;
        }

        public MediaBuilder setScene(int n) {
            this.i = n;
            return this;
        }

        public MediaBuilder setUrl(String string) {
            this.e = string;
            return this;
        }

        public String getTitle() {
            return this.b;
        }

        public String getContent() {
            return this.c;
        }

        public String getDescription() {
            return this.d;
        }

        public String getUrl() {
            return this.e;
        }

        public Bitmap getImageBitmap() {
            return this.f;
        }

        public int getThumbWidth() {
            return this.g;
        }

        public int getThumbHeight() {
            return this.h;
        }

        public int getScene() {
            return this.i;
        }

        public String getTransaction() {
            return this.j;
        }

        public Bitmap buildThumbnailBitmap() {
            if (this.f == null) {
                return null;
            }
            return Bitmap.createScaledBitmap((Bitmap)this.f, (int)this.g, (int)this.h, (boolean)true);
        }
    }
}

