/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.OnyxDownloadManager;
import com.onyx.android.sdk.data.model.ApplicationUpdate;
import com.onyx.android.sdk.data.request.cloud.ApplicationUpdateRequest;
import com.onyx.android.sdk.data.utils.NotificationItem;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.PackageUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AppUpdateManager {
    public static final String PHONE_APPLICATION_MODEL = "mobile";

    public static ApplicationUpdate getApplicationUpdate(Context context) {
        ApplicationUpdate applicationUpdate = ApplicationUpdate.create(context);
        applicationUpdate.model = PHONE_APPLICATION_MODEL;
        return applicationUpdate;
    }

    public static String getApkFilePath(Context context, ApplicationUpdate applicationUpdate) {
        String string = applicationUpdate.packageName.replaceAll("\\.", "_");
        return new File(context.getExternalCacheDir(), string + "_" + applicationUpdate.versionCode + ".apk").getAbsolutePath();
    }

    private static String a(ApplicationUpdate applicationUpdate) {
        return applicationUpdate.getFirstDownloadUrl();
    }

    public static void checkUpdate(Context context, CloudManager cloudManager, AppUpdateConfig appUpdateConfig) {
        AppUpdateManager.checkUpdate(context, cloudManager, appUpdateConfig, null);
    }

    public static void checkUpdate(Context context, CloudManager cloudManager, AppUpdateConfig appUpdateConfig, BaseCallback baseCallback) {
        ArrayList<ApplicationUpdate> arrayList = new ArrayList<ApplicationUpdate>();
        ApplicationUpdate applicationUpdate = AppUpdateManager.getApplicationUpdate(context);
        if (StringUtils.isNotBlank((String)appUpdateConfig.model)) {
            applicationUpdate.model = appUpdateConfig.model;
        }
        arrayList.add(applicationUpdate);
        AppUpdateManager.checkUpdate(context, cloudManager, appUpdateConfig, arrayList, baseCallback);
    }

    public static void checkUpdate(final Context context, CloudManager cloudManager, final AppUpdateConfig appUpdateConfig, List<ApplicationUpdate> list, final BaseCallback baseCallback) {
        final ApplicationUpdateRequest applicationUpdateRequest = new ApplicationUpdateRequest(list);
        cloudManager.submitRequest(context, applicationUpdateRequest, new BaseCallback(){

            public void done(BaseRequest baseRequest, Throwable throwable) {
                BaseCallback.invoke((BaseCallback)baseCallback, (BaseRequest)baseRequest, (Throwable)throwable);
                if (throwable == null && appUpdateConfig.autoDownload) {
                    AppUpdateManager.checkUpdatedFileDownload(context, appUpdateConfig, applicationUpdateRequest.getUpdateList(), null);
                }
            }
        });
    }

    private static PendingIntent a(Context context, File file) {
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)PackageUtils.getInstallIntent((File)file), (int)0x8000000);
    }

    private static NotificationItem.NotificationBean a(Context context, AppUpdateConfig appUpdateConfig, ApplicationUpdate applicationUpdate, File file) {
        NotificationItem.NotificationBean notificationBean = new NotificationItem.NotificationBean();
        notificationBean.title = PackageUtils.getAppDisplayName((Context)context, (String)context.getPackageName());
        notificationBean.desc = applicationUpdate.versionName;
        notificationBean.icon = appUpdateConfig.notificationSmallIcon;
        notificationBean.largeIcon = appUpdateConfig.notificationLargeIcon;
        notificationBean.pendingIntent = AppUpdateManager.a(context, file);
        return notificationBean;
    }

    public static boolean checkUpdatedFileDownload(Context context, AppUpdateConfig appUpdateConfig, ApplicationUpdate applicationUpdate, BaseCallback baseCallback) {
        if (applicationUpdate == null) {
            return false;
        }
        String string = AppUpdateManager.getApkFilePath(context, applicationUpdate);
        File file = new File(string);
        String string2 = AppUpdateManager.a(applicationUpdate);
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return false;
        }
        BaseDownloadTask baseDownloadTask = OnyxDownloadManager.getInstance().downloadWithNotify(string2, string, string, AppUpdateManager.a(context, appUpdateConfig, applicationUpdate, file), baseCallback);
        baseDownloadTask.setForceReDownload(true);
        return OnyxDownloadManager.getInstance().startDownload(baseDownloadTask) != 0;
    }

    public static boolean checkUpdatedFileDownload(Context context, AppUpdateConfig appUpdateConfig, List<ApplicationUpdate> list, BaseCallback baseCallback) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return false;
        }
        boolean bl = true;
        for (ApplicationUpdate applicationUpdate : list) {
            bl &= AppUpdateManager.checkUpdatedFileDownload(context, appUpdateConfig, applicationUpdate, baseCallback);
        }
        return bl;
    }

    public static class AppUpdateConfig {
        public int notificationSmallIcon;
        public Bitmap notificationLargeIcon;
        public boolean autoDownload;
        public String model;

        public static AppUpdateConfig create(int n, boolean bl) {
            AppUpdateConfig appUpdateConfig = new AppUpdateConfig();
            appUpdateConfig.notificationSmallIcon = n;
            appUpdateConfig.autoDownload = bl;
            return appUpdateConfig;
        }
    }
}

