/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.request.cloud.CloudFileDownloadRequest;
import com.onyx.android.sdk.data.utils.DownloadListener;
import com.onyx.android.sdk.data.utils.NotificationItem;
import java.util.LinkedHashMap;

public class OnyxDownloadManager {
    private static int a = 1200;
    private static OnyxDownloadManager b;
    private static Context c;
    private FileDownloadNotificationHelper<NotificationItem> d = new FileDownloadNotificationHelper();
    private LinkedHashMap<Object, BaseDownloadTask> e = new LinkedHashMap();

    private OnyxDownloadManager() {
    }

    public static void init(Context context) {
        c = context;
        FileDownloader.init((Context)c);
        FileDownloader.getImpl().setMaxNetworkThreadCount(5);
    }

    public static synchronized OnyxDownloadManager getInstance() {
        if (b == null) {
            b = new OnyxDownloadManager();
        }
        return b;
    }

    public static synchronized Context getContext() {
        return FileDownloadHelper.getAppContext();
    }

    public CloudFileDownloadRequest createDownloadRequest(String string, String string2, Object object) {
        CloudFileDownloadRequest cloudFileDownloadRequest = new CloudFileDownloadRequest(string, string2, object);
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)string, (String)string2));
        return cloudFileDownloadRequest;
    }

    public DownloadListener createDownloadListener(CloudFileDownloadRequest cloudFileDownloadRequest, BaseCallback baseCallback) {
        return new DownloadListener(cloudFileDownloadRequest, baseCallback, this.d);
    }

    public DownloadListener createDownloadListener(NotificationItem.NotificationBean notificationBean, CloudFileDownloadRequest cloudFileDownloadRequest, BaseCallback baseCallback) {
        DownloadListener downloadListener = this.createDownloadListener(cloudFileDownloadRequest, baseCallback);
        downloadListener.setNotificationBean(notificationBean);
        return downloadListener;
    }

    public BaseDownloadTask download(Context context, String string, String string2, Object object, BaseCallback baseCallback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(string, string2, object);
        cloudFileDownloadRequest.setContext(context);
        return this.download(cloudFileDownloadRequest, baseCallback);
    }

    public BaseDownloadTask download(CloudFileDownloadRequest cloudFileDownloadRequest, BaseCallback baseCallback) {
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)cloudFileDownloadRequest.getUrl(), (String)cloudFileDownloadRequest.getPath()));
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        baseDownloadTask.setListener((FileDownloadListener)this.createDownloadListener(cloudFileDownloadRequest, baseCallback));
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(String string, String string2, Object object, NotificationItem.NotificationBean notificationBean, BaseCallback baseCallback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(string, string2, object);
        DownloadListener downloadListener = this.createDownloadListener(notificationBean, cloudFileDownloadRequest, baseCallback);
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(CloudFileDownloadRequest cloudFileDownloadRequest, NotificationItem.NotificationBean notificationBean, BaseCallback baseCallback) {
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)cloudFileDownloadRequest.getUrl(), (String)cloudFileDownloadRequest.getPath()));
        DownloadListener downloadListener = this.createDownloadListener(notificationBean, cloudFileDownloadRequest, baseCallback);
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public int downloadDirectly(Context context, String string, String string2, Object object, BaseCallback baseCallback) {
        return this.startDownload(this.download(context, string, string2, object, baseCallback));
    }

    public int downloadDirectly(CloudFileDownloadRequest cloudFileDownloadRequest, BaseCallback baseCallback) {
        return this.startDownload(this.download(cloudFileDownloadRequest, baseCallback));
    }

    public int startDownload(BaseDownloadTask baseDownloadTask) {
        baseDownloadTask.setCallbackProgressMinInterval(a);
        return baseDownloadTask.start();
    }

    public int startDownload(BaseDownloadTask baseDownloadTask, int n) {
        baseDownloadTask.setCallbackProgressMinInterval(n);
        return baseDownloadTask.start();
    }

    public void removeTask(Object object) {
        this.e.remove(object);
    }

    public void addTask(Object object, BaseDownloadTask baseDownloadTask) {
        this.e.put(object, baseDownloadTask);
    }

    public BaseDownloadTask getTask(Object object) {
        return this.e.get(object);
    }

    public void clearTaskQueue() {
        this.e.clear();
    }

    public int getTaskProgress(int n) {
        return (int)((float)FileDownloader.getImpl().getSoFar(n) * 1.0f / (float)FileDownloader.getImpl().getTotal(n) * 100.0f);
    }

    public int getTaskStatus(int n, String string) {
        return FileDownloader.getImpl().getStatus(n, string);
    }

    public void pauseTask(Object object, boolean bl) {
        BaseDownloadTask baseDownloadTask = this.getTask(object);
        if (baseDownloadTask == null) {
            return;
        }
        baseDownloadTask.pause();
        if (bl) {
            this.removeTask(object);
        }
    }
}

