/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.v2;

import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.v2.AdminApplyModel;
import com.onyx.android.sdk.data.model.v2.AuthToken;
import com.onyx.android.sdk.data.model.v2.BaseAuthAccount;
import com.onyx.android.sdk.data.model.v2.CloudGroup;
import com.onyx.android.sdk.data.model.v2.CloudLibrary;
import com.onyx.android.sdk.data.model.v2.CloudMetadata;
import com.onyx.android.sdk.data.model.v2.Course;
import com.onyx.android.sdk.data.model.v2.DeviceBind;
import com.onyx.android.sdk.data.model.v2.GroupContainer;
import com.onyx.android.sdk.data.model.v2.GroupUserInfo;
import com.onyx.android.sdk.data.model.v2.IndexService;
import com.onyx.android.sdk.data.model.v2.InstallationIdBinding;
import com.onyx.android.sdk.data.model.v2.NeoAccountBase;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ContentService {
    public static final String CONTENT_AUTH_PREFIX = "Bearer ";

    @GET(value="devices/findByMac")
    public Call<IndexService> getIndexService(@Query(value="mac") String var1, @Query(value="installationId") String var2);

    @POST(value="auth/local")
    public Call<AuthToken> getAccountToken(@Body BaseAuthAccount var1);

    @GET(value="users/me")
    public Call<ResponseBody> getAccount();

    @GET(value="courses/my")
    public Call<List<Course>> getMyCourses();

    @GET(value="librarys/my")
    public Call<List<CloudLibrary>> loadLibraryList();

    @GET(value="librarys/books")
    public Call<ProductResult<CloudMetadata>> loadBookList(@Query(value="where") String var1);

    @GET(value="librarys/{id}/library")
    public Call<QueryResult<CloudLibrary>> loadLibraryList(@Path(value="id") String var1);

    @GET(value="librarys/{id}/books")
    public Call<ProductResult<CloudMetadata>> loadBookList(@Path(value="id") String var1, @Query(value="where") String var2);

    @GET(value="books/{id}")
    public Call<CloudMetadata> loadBook(@Path(value="id") String var1);

    @POST(value="groups/{id}/createUserByDevices")
    public Call<NeoAccountBase> createUserByDevice(@Path(value="id") String var1, @Body DeviceBind var2);

    @GET(value="groups/{id}/groupusers")
    public Call<List<NeoAccountBase>> getGroupUserList(@Path(value="id") String var1);

    @GET(value="groups/{id}")
    public Call<CloudGroup> getGroup(@Path(value="id") String var1);

    @GET(value="groups/recursive")
    public Call<List<CloudGroup>> getRecursiveGroupList();

    @GET(value="groups/me")
    public Call<List<CloudGroup>> getMyGroupList();

    @GET(value="groups/myGroupsWithLibrary")
    public Call<List<GroupContainer>> getMyGroupContainerList();

    @POST(value="adusers")
    public Call<ResponseBody> applyAdminRequest(@Body AdminApplyModel var1);

    @GET(value="adusers/findByMac")
    public Call<IndexService> getAdminIndexService(@Query(value="mac") String var1);

    @GET(value="users/findByDeviceMac")
    public Call<GroupUserInfo> getGroupUserInfo(@Query(value="mac") String var1);

    @PUT(value="users/{id}/bindDevice")
    public Call<ResponseBody> bindUserByDevice(@Path(value="id") String var1, @Body DeviceBind var2);

    @PUT(value="users/{id}/unbindDevice")
    public Call<ResponseBody> unbindUserByDevice(@Path(value="id") String var1, @Body DeviceBind var2);

    @GET(value="adapplys/phoneVerify")
    public Call<ResponseBody> applyPhoneVerify(@Query(value="phone") String var1);

    @POST(value="devices/updateInstallationIdByMac")
    public Call<ResponseBody> updateInstallationIdByMac(@Body InstallationIdBinding var1);
}

