/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.util.Log;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PoolConfig;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ThumbnailUtils {
    public static final String thumbnail_folder = ".thumbnails";
    public static final String preferred_extension = "png";
    private static Map<String, Integer> defaultThumbnailMap = new HashMap<String, Integer>();

    public static Map<String, Integer> defaultThumbnailMapping() {
        if (defaultThumbnailMap == null) {
            defaultThumbnailMap = new HashMap<String, Integer>();
            defaultThumbnailMap.put("acsm", R.drawable.acsm);
            defaultThumbnailMap.put("bmp", R.drawable.bmp);
            defaultThumbnailMap.put("chm", R.drawable.chm);
            defaultThumbnailMap.put("djvu", R.drawable.djvu);
            defaultThumbnailMap.put("doc", R.drawable.doc);
            defaultThumbnailMap.put("docx", R.drawable.docx);
            defaultThumbnailMap.put("eba3", R.drawable.eba3);
            defaultThumbnailMap.put("ebaml", R.drawable.ebaml);
            defaultThumbnailMap.put("epub", R.drawable.epub);
            defaultThumbnailMap.put("fb2", R.drawable.fb2);
            defaultThumbnailMap.put("gif", R.drawable.gif);
            defaultThumbnailMap.put("htm", R.drawable.htm);
            defaultThumbnailMap.put("html", R.drawable.html);
            defaultThumbnailMap.put("jpg", R.drawable.jpg);
            defaultThumbnailMap.put("mobi", R.drawable.mobi);
            defaultThumbnailMap.put("mp3", R.drawable.mp3);
            defaultThumbnailMap.put("pdb", R.drawable.pdb);
            defaultThumbnailMap.put("pdf", R.drawable.pdf);
            defaultThumbnailMap.put(preferred_extension, R.drawable.png);
            defaultThumbnailMap.put("ppt", R.drawable.ppt);
            defaultThumbnailMap.put("prc", R.drawable.prc);
            defaultThumbnailMap.put("rar", R.drawable.rar);
            defaultThumbnailMap.put("rtf", R.drawable.rtf);
            defaultThumbnailMap.put("tiff", R.drawable.tiff);
            defaultThumbnailMap.put("txt", R.drawable.txt);
            defaultThumbnailMap.put("wma", R.drawable.wma);
            defaultThumbnailMap.put("xls", R.drawable.xls);
            defaultThumbnailMap.put("zip", R.drawable.zip);
            defaultThumbnailMap.put("cbz", R.drawable.cbz);
        }
        return defaultThumbnailMap;
    }

    public static Integer thumbnailUnknown() {
        return R.drawable.unknown_document;
    }

    public static Integer thumbnailDefault() {
        return R.drawable.book_default_cover;
    }

    public static Integer libraryThumbnailDefault() {
        return R.drawable.library_default_cover;
    }

    public static Bitmap loadThumbnail(Context context, int resId) {
        BitmapDrawable drawable2 = (BitmapDrawable)context.getResources().getDrawable(resId);
        return drawable2 == null ? null : drawable2.getBitmap();
    }

    public static Bitmap loadDefaultThumbnailFromExtension(Context context, String ext) {
        if (StringUtils.isNullOrEmpty((String)ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailUnknown());
        }
        if (ThumbnailUtils.defaultThumbnailMapping().containsKey(ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.defaultThumbnailMapping().get(ext));
        }
        return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailDefault());
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind) {
        return ThumbnailUtils.getThumbnailFile(context, sourceMD5, thumbnailKind, preferred_extension);
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind, String extension) {
        return EnvironmentUtil.getExternalStorageAppCacheDirectory((String)context.getPackageName()) + File.separator + thumbnail_folder + File.separator + sourceMD5 + "." + thumbnailKind + "." + extension;
    }

    public static Bitmap getThumbnailBitmap(Context context, String sourceMD5, String thumbnailKind) {
        return BitmapUtils.loadBitmapFromFile((String)ThumbnailUtils.getThumbnailFile(context, sourceMD5, thumbnailKind));
    }

    public static Bitmap getThumbnailBitmap(Context context, Thumbnail thumbnail) {
        Bitmap bitmap = ThumbnailUtils.getThumbnailBitmap(context, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString());
        if (bitmap == null) {
            bitmap = ThumbnailUtils.loadDefaultThumbnailFromExtension(context, FileUtils.getFileExtension((String)thumbnail.getOriginContentPath()));
        }
        return bitmap;
    }

    public static boolean saveThumbnailBitmap(Context context, Thumbnail thumbnail, Bitmap saveBitmap) {
        String path = ThumbnailUtils.getThumbnailFile(context, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString());
        if (!FileUtils.ensureFileExists((String)path)) {
            return false;
        }
        boolean save = BitmapUtils.saveBitmap((Bitmap)ThumbnailUtils.generateBitmap(saveBitmap, thumbnail.getThumbnailKind()), (String)path);
        if (save) {
            thumbnail.setOriginContentPath(path);
            thumbnail.save();
        }
        return save;
    }

    private static Bitmap generateBitmap(Bitmap bitmap, OnyxThumbnail.ThumbnailKind kind) {
        Bitmap scaleBitmap = bitmap;
        switch (kind) {
            case Original: {
                scaleBitmap = bitmap;
                break;
            }
            case Large: {
                scaleBitmap = OnyxThumbnail.createLargeThumbnail(bitmap);
                break;
            }
            case Middle: {
                scaleBitmap = OnyxThumbnail.createMiddleThumbnail(bitmap);
                break;
            }
            case Small: {
                scaleBitmap = OnyxThumbnail.createSmallThumbnail(bitmap);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return scaleBitmap;
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProviderBase, String filePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        return ThumbnailUtils.insertThumbnail(context, dataProviderBase, filePath, ThumbnailUtils.getThumbnailFile(context, associationId, kind.toString()), associationId, kind, bitmap);
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProviderBase, String bookFilePath, String thumbnailFilePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        Thumbnail thumbnail = new Thumbnail();
        thumbnail.setThumbnailKind(kind);
        thumbnail.setOriginContentPath(bookFilePath);
        thumbnail.setIdString(associationId);
        thumbnail.setImageDataPath(thumbnailFilePath);
        dataProviderBase.saveThumbnailEntry(context, thumbnail);
        return ThumbnailUtils.insertThumbnailBitmap(thumbnail, bitmap);
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProviderBase, String filePath, String associationId, Bitmap bitmap) {
        for (OnyxThumbnail.ThumbnailKind kind : OnyxThumbnail.ThumbnailKind.values()) {
            boolean success = ThumbnailUtils.insertThumbnail(context, dataProviderBase, filePath, associationId, kind, bitmap);
            if (!kind.equals((Object)OnyxThumbnail.ThumbnailKind.Large) || success) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeBitmapToThumbnailFile(File file, Bitmap transBitmap) {
        boolean bl;
        FileOutputStream os;
        block8: {
            os = null;
            os = new FileOutputStream(file);
            if (transBitmap != null && !transBitmap.isRecycled()) break block8;
            boolean bl2 = false;
            FileUtils.closeQuietly((Closeable)os);
            return bl2;
        }
        try {
            Bitmap.CompressFormat format = Bitmap.CompressFormat.PNG;
            if (FileUtils.isPngExtension((File)file)) {
                format = Bitmap.CompressFormat.PNG;
            } else if (FileUtils.isJpgExtension((File)file)) {
                format = Bitmap.CompressFormat.JPEG;
            }
            bl = transBitmap.compress(format, 100, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            try {
                Log.w((String)"writeBitmapToThumbnail", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(os);
                throw throwable;
            }
            FileUtils.closeQuietly((Closeable)os);
            return false;
        }
        FileUtils.closeQuietly((Closeable)os);
        return bl;
    }

    public static boolean insertThumbnailBitmap(Thumbnail thumbnail, Bitmap bmp) {
        Bitmap transBitmap = ThumbnailUtils.generateBitmap(bmp, thumbnail.getThumbnailKind());
        FileUtils.ensureFileExists((String)thumbnail.getImageDataPath());
        File file = new File(thumbnail.getImageDataPath());
        return ThumbnailUtils.writeBitmapToThumbnailFile(file, transBitmap);
    }

    public static Bitmap createLargeThumbnail(Bitmap bmp) {
        return ThumbnailUtils.createThumbnail(bmp, 512);
    }

    public static Bitmap createMiddleThumbnail(Bitmap bmp) {
        return ThumbnailUtils.createThumbnail(bmp, 256);
    }

    public static Bitmap createSmallThumbnail(Bitmap bmp) {
        return ThumbnailUtils.createThumbnail(bmp, 128);
    }

    private static Bitmap createThumbnail(Bitmap bmp, int limit) {
        if (bmp.getWidth() <= limit && bmp.getHeight() <= limit) {
            return bmp;
        }
        int w = limit;
        int h = limit;
        if (bmp.getWidth() >= bmp.getHeight()) {
            double z = (double)limit / (double)bmp.getWidth();
            h = (int)(z * (double)bmp.getHeight());
        } else {
            double z = (double)limit / (double)bmp.getHeight();
            w = (int)(z * (double)bmp.getWidth());
        }
        return Bitmap.createScaledBitmap((Bitmap)bmp, (int)w, (int)h, (boolean)true);
    }

    public static CloseableReference<Bitmap> decodeFile(File file) throws IOException {
        return ThumbnailUtils.decodeStream(new FileInputStream(file), Bitmap.Config.ARGB_8888);
    }

    public static CloseableReference<Bitmap> decodeFile(File file, Bitmap.Config config) throws IOException {
        return ThumbnailUtils.decodeStream(new FileInputStream(file), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableReference<Bitmap> decodeStream(InputStream inputStream, Bitmap.Config config) throws IOException {
        CloseableReference closeableReference;
        PoolFactory poolFactory = new PoolFactory(PoolConfig.newBuilder().build());
        PooledByteBuffer pooledByteBuffer = null;
        EncodedImage image = null;
        try {
            pooledByteBuffer = poolFactory.getPooledByteBufferFactory().newByteBuffer(inputStream);
            image = new EncodedImage(CloseableReference.of((Closeable)pooledByteBuffer));
            closeableReference = Fresco.getImagePipelineFactory().getPlatformDecoder().decodeFromEncodedImage(image, config);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly((Closeable)inputStream);
            FileUtils.closeQuietly(image);
            FileUtils.closeQuietly((Closeable)pooledByteBuffer);
            throw throwable;
        }
        FileUtils.closeQuietly((Closeable)inputStream);
        FileUtils.closeQuietly((Closeable)image);
        FileUtils.closeQuietly((Closeable)pooledByteBuffer);
        return closeableReference;
    }

    public static boolean hasThumbnail(Context context, DataProviderBase dataProvider, String associationId) {
        Thumbnail thumbnail = ThumbnailUtils.getThumbnailEntry(context, dataProvider, associationId, OnyxThumbnail.ThumbnailKind.Large);
        return thumbnail != null && thumbnail.hasValidId();
    }

    public static Thumbnail getThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return dataProvider.getThumbnailEntry(context, associationId, kind);
    }

    public static boolean updateThumbnailEntrySet(Context context, DataProviderBase dataProvider, String associationId, Bitmap originBitmap) {
        boolean success = true;
        for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
            success &= ThumbnailUtils.updateThumbnailEntry(context, dataProvider, associationId, thumbnailKind, originBitmap);
        }
        return success;
    }

    public static boolean updateThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap originBitmap) {
        Thumbnail thumbnail = ThumbnailUtils.getThumbnailEntry(context, dataProvider, associationId, kind);
        if (thumbnail == null) {
            Log.w((String)"update thumbnail", (String)"detect null");
            return false;
        }
        thumbnail.setImageDataPath(ThumbnailUtils.getThumbnailFile(context, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString()));
        dataProvider.saveThumbnailEntry(context, thumbnail);
        return ThumbnailUtils.insertThumbnailBitmap(thumbnail, originBitmap);
    }
}

