/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.data.db.OnyxCloudDatabase;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.model.Dictionary;
import com.onyx.android.sdk.data.model.DownloadLink;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.transaction.ProcessDeleteModel;
import com.onyx.android.sdk.data.transaction.ProcessSaveModel;
import com.onyx.android.sdk.data.transaction.ProcessUpdateModel;
import com.onyx.android.sdk.data.utils.CloudUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.InternalAdapter;
import com.raizlabs.android.dbflow.structure.database.transaction.FastStoreModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.ProcessModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.ArrayList;
import java.util.List;

public class StoreUtils {
    public static final int PROCESS_SAVE = 0;
    public static final int PROCESS_DELETE = 1;
    public static final int PROCESS_UPDATE = 2;

    public static <T extends BaseData> ProcessModelTransaction.ProcessModel<T> getProcessModel(int process) {
        Object processModel;
        switch (process) {
            case 0: {
                processModel = new ProcessSaveModel();
                break;
            }
            case 2: {
                processModel = new ProcessUpdateModel();
                break;
            }
            case 1: {
                processModel = new ProcessDeleteModel();
                break;
            }
            default: {
                processModel = new ProcessSaveModel();
            }
        }
        return processModel;
    }

    public static <T extends BaseData> void processOnAsync(List<T> productResult, final int process, ProcessModelTransaction.OnModelProcessListener<T> processListener) {
        ProcessModelTransaction processModelTransaction = new ProcessModelTransaction.Builder(new ProcessModelTransaction.ProcessModel<T>(){

            public void processModel(T model) {
                if (process == 0) {
                    ((BaseData)((Object)model)).save();
                } else if (process == 1) {
                    model.delete();
                } else if (process == 2) {
                    model.update();
                }
            }
        }).processListener(processListener).addAll(productResult).build();
        Transaction transaction = FlowManager.getDatabase(OnyxCloudDatabase.class).beginTransactionAsync((ITransaction)processModelTransaction).build();
        transaction.execute();
    }

    public static <T extends BaseData> void saveToLocal(ProductResult<T> productResult, Class<T> clazz, boolean clearBeforeSave) {
        if (StoreUtils.clearTable(productResult, clazz, clearBeforeSave)) {
            StoreUtils.processOnAsync(productResult.list, 0, null);
        }
    }

    public static <T extends BaseData> void saveToLocal(List<T> list, Class<T> clazz, boolean clearBeforeSave) {
        if (clearBeforeSave) {
            StoreUtils.clearTable(clazz);
        }
        StoreUtils.processOnAsync(list, 0, null);
    }

    public static <T extends BaseData> void saveToLocalFast(ProductResult<T> productResult, Class<T> clazz, boolean clearBeforeSave) {
        if (StoreUtils.clearTable(productResult, clazz, clearBeforeSave)) {
            StoreUtils.saveToLocalFast(productResult.list, clazz);
        }
    }

    public static <T extends BaseData> void saveToLocalFast(List<T> productResult, Class<T> clazz, boolean clearBeforeSave) {
        if (clearBeforeSave) {
            if (productResult.size() <= 0) {
                return;
            }
            StoreUtils.clearTable(clazz);
        }
        StoreUtils.saveToLocalFast(productResult, clazz);
    }

    public static <T extends BaseData> void saveToLocalFast(List<T> list, Class<T> clazz) {
        StoreUtils.executeFastBuilder(FastStoreModelTransaction.saveBuilder((InternalAdapter)FlowManager.getModelAdapter(clazz)), list);
    }

    public static <T extends BaseData> void updateToLocalFast(List<T> list, Class<T> clazz) {
        StoreUtils.executeFastBuilder(FastStoreModelTransaction.updateBuilder((InternalAdapter)FlowManager.getModelAdapter(clazz)), list);
    }

    private static <T extends BaseData> void executeFastBuilder(FastStoreModelTransaction.Builder<T> builder, List<T> list) {
        builder.addAll(list).build().execute(FlowManager.getWritableDatabase(OnyxCloudDatabase.class));
    }

    public static <T extends BaseData> boolean clearTable(ProductResult<T> productResult, Class<T> clazz, boolean clearBeforeSave) {
        if (CloudUtils.isEmpty(productResult)) {
            return false;
        }
        if (clearBeforeSave) {
            StoreUtils.clearTable(clazz);
        }
        return true;
    }

    public static <T extends BaseModel> void clearTable(Class<T> clazz) {
        SQLite.delete(clazz).execute();
    }

    public static <T extends BaseModel> void clearAllTable() {
        StoreUtils.clearTable(Product.class);
        StoreUtils.clearTable(Dictionary.class);
        StoreUtils.clearTable(Category.class);
        StoreUtils.clearTable(DownloadLink.class);
    }

    public static <T extends BaseModel> List<T> queryDataList(Class<T> clazz, int limit) {
        return SQLite.select((IProperty[])new IProperty[0]).from(clazz).limit(limit).queryList();
    }

    public static <T extends BaseModel> List<T> queryDataList(Class<T> clazz) {
        return SQLite.select((IProperty[])new IProperty[0]).from(clazz).queryList();
    }

    public static <T extends BaseModel> T queryDataSingle(Class<T> clazz) {
        return (T)((BaseModel)SQLite.select((IProperty[])new IProperty[0]).from(clazz).querySingle());
    }

    public static <T extends BaseModel> List<T> queryDataList(Class<T> clazz, OrderBy ... orderBys) {
        Where where = SQLite.select((IProperty[])new IProperty[0]).from(clazz).where();
        for (OrderBy orderBy : orderBys) {
            where.orderBy(orderBy);
        }
        return where.queryList();
    }

    public static <T extends BaseModel> T queryDataSingle(Class<T> clazz, SQLCondition ... conditions) {
        return (T)((BaseModel)SQLite.select((IProperty[])new IProperty[0]).from(clazz).where().andAll(conditions).querySingle());
    }

    public static <T extends BaseModel> T queryDataSingle(Class<T> clazz, OrderBy ... orderBys) {
        Where where = SQLite.select((IProperty[])new IProperty[0]).from(clazz).where();
        for (OrderBy orderBy : orderBys) {
            where.orderBy(orderBy);
        }
        return (T)((BaseModel)where.querySingle());
    }

    public static <T extends BaseModel> long queryDataCount(Class<T> clazz) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(clazz).count();
    }

    public static <T extends BaseModel> long queryDataCount(Class<T> clazz, Condition ... condition) {
        Where where = new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(clazz).where();
        if (condition != null && condition.length > 0) {
            where.andAll((SQLCondition[])condition);
        }
        return where.count();
    }

    public static <T extends BaseData> void saveAsyncSingle(BaseData object) {
        object.async().save();
    }

    public static <T extends BaseData> boolean isEmpty(ProductResult<T> productResult) {
        return productResult == null || productResult.list == null || productResult.list.size() <= 0;
    }

    public static <T extends BaseData> List<T> getResultList(ProductResult<T> productResult) {
        if (StoreUtils.isEmpty(productResult)) {
            return new ArrayList();
        }
        return productResult.list;
    }
}

