/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.BaseCondition;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.IntProperty;
import com.raizlabs.android.dbflow.sql.language.property.LongProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class QueryBuilder {
    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = QueryBuilder.allBooksQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = QueryBuilder.allBooksQuery(fileTypes, sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, OrderBy orderBy) {
        QueryArgs args = QueryArgs.queryBy(QueryBuilder.orTypeCondition(fileTypes), orderBy);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryBookListNewQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = QueryBuilder.newBookListQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryFinishReadQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = QueryBuilder.finishReadQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryRecentReadingQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = QueryBuilder.recentReadingQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryRecentAddQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        args.conditionGroup = QueryBuilder.recentAddCondition();
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryTagsFilterQuery(String libraryUniqueId, Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs args = QueryBuilder.tagsFilterQuery(tags, sortBy, order);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs librarySearchQuery(String libraryUniqueId, String search, SortBy sortBy, SortOrder order) {
        QueryArgs args = QueryBuilder.searchQuery(search, sortBy, order);
        args.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs allBooksQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        return QueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        args.fileType = fileTypes;
        return QueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, OrderBy orderBy) {
        return QueryArgs.queryBy(QueryBuilder.orTypeCondition(fileTypes), orderBy);
    }

    public static QueryArgs newBookListQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.NEW);
        return QueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs finishReadQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.FINISHED);
        return QueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs recentReadingQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.READING);
        return QueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs tagsFilterQuery(Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs args = new QueryArgs(sortBy, order).appendFilter(BookFilter.TAG);
        args.tags = tags;
        return QueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs searchQuery(String search, SortBy sortBy, SortOrder order) {
        QueryArgs args = new QueryArgs(sortBy, order).appendFilter(BookFilter.SEARCH);
        args.query = search;
        return QueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs recentAddQuery() {
        QueryArgs args = QueryArgs.queryBy(QueryBuilder.recentAddCondition(), QueryBuilder.getOrderByUpdateAt().descending());
        return args;
    }

    public static IntProperty getMetadataReadingStatusProperty() {
        return Metadata_Table.readingStatus;
    }

    public static Property<String> getMetadataTypeProperty() {
        return Metadata_Table.type;
    }

    public static Property<String> getMetadataTitleProperty() {
        return Metadata_Table.title;
    }

    public static Property<String> getMetadataNameProperty() {
        return Metadata_Table.name;
    }

    public static Property<String> getMetadataAuthorsProperty() {
        return Metadata_Table.authors;
    }

    public static Property<String> getMetadataPublisherProperty() {
        return Metadata_Table.publisher;
    }

    public static Property<String> getMetadataTagsProperty() {
        return Metadata_Table.tags;
    }

    public static Property<String> getMetadataSeriesProperty() {
        return Metadata_Table.series;
    }

    public static Property<String> getMetadataIdStringProperty() {
        return Metadata_Table.idString;
    }

    public static LongProperty getMetadataSizeProperty() {
        return Metadata_Table.size;
    }

    public static Property<Date> getMetadataCreatedAtProperty() {
        return Metadata_Table.createdAt;
    }

    public static Property<Date> getMetadataLastAccessProperty() {
        return Metadata_Table.lastAccess;
    }

    public static Property<String> getMetadataCollectionDocIdProperty() {
        return MetadataCollection_Table.documentUniqueId;
    }

    public static Property<String> getMetadataCollectionLibraryIdProperty() {
        return MetadataCollection_Table.libraryUniqueId;
    }

    public static ConditionGroup newBookListCondition() {
        return ConditionGroup.clause().and((SQLCondition)QueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.NEW));
    }

    public static ConditionGroup finishReadCondition() {
        return ConditionGroup.clause().and((SQLCondition)QueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.FINISHED));
    }

    public static ConditionGroup recentReadingCondition() {
        return ConditionGroup.clause().and((SQLCondition)QueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.READING));
    }

    public static ConditionGroup recentAddCondition() {
        return ConditionGroup.clause().and((SQLCondition)QueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.NEW));
    }

    public static ConditionGroup orTypeCondition(Set<String> fileTypes) {
        if (CollectionUtils.isNullOrEmpty(fileTypes)) {
            return ConditionGroup.clause();
        }
        ConditionGroup group = ConditionGroup.clause();
        ArrayList<Condition> sqlConditions = new ArrayList<Condition>();
        for (String type : fileTypes) {
            sqlConditions.add(QueryBuilder.getMetadataTypeProperty().eq((Object)type));
        }
        return group.orAll(sqlConditions);
    }

    public static ConditionGroup orTagsCondition(Set<String> tags) {
        if (CollectionUtils.isNullOrEmpty(tags)) {
            return ConditionGroup.clause();
        }
        ArrayList<Condition> sqlConditions = new ArrayList<Condition>();
        for (String tag : tags) {
            sqlConditions.add(QueryBuilder.matchLike(QueryBuilder.getMetadataTagsProperty(), tag));
        }
        return ConditionGroup.clause().orAll(sqlConditions);
    }

    public static ConditionGroup orSearchCondition(String search) {
        if (StringUtils.isNullOrEmpty((String)search)) {
            return ConditionGroup.clause();
        }
        return ConditionGroup.clause().or((SQLCondition)QueryBuilder.matchLike(QueryBuilder.getMetadataTitleProperty(), search)).or((SQLCondition)QueryBuilder.matchLike(QueryBuilder.getMetadataNameProperty(), search)).or((SQLCondition)QueryBuilder.matchLike(QueryBuilder.getMetadataAuthorsProperty(), search));
    }

    public static List<OrderBy> getOrderByList() {
        ArrayList<OrderBy> orderByList = new ArrayList<OrderBy>();
        orderByList.add(OrderBy.fromProperty(QueryBuilder.getMetadataNameProperty()).ascending());
        return orderByList;
    }

    public static OrderBy getOrderByUpdateAt() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByCreateAt() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByName() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataNameProperty()).ascending();
    }

    public static OrderBy getOrderBy(IProperty property) {
        return OrderBy.fromProperty((IProperty)property);
    }

    public static void andWith(ConditionGroup parent, ConditionGroup child) {
        if (parent != null && child != null) {
            parent.and((SQLCondition)child);
        }
    }

    public static SQLCondition matchNotLike(final Property<String> property, final String value) {
        if (property == null || StringUtils.isNullOrEmpty((String)value)) {
            return null;
        }
        return new SQLCondition(){
            private String separator;

            public void appendConditionToQuery(com.raizlabs.android.dbflow.sql.QueryBuilder queryBuilder) {
                queryBuilder.append((Object)this.columnName()).append((Object)this.operation());
                queryBuilder.append((Object)BaseCondition.convertValueToString((Object)this.value(), (boolean)true));
            }

            public String columnName() {
                return property.getNameAlias().name();
            }

            public String separator() {
                return this.separator;
            }

            public SQLCondition separator(String separator) {
                this.separator = separator;
                return this;
            }

            public boolean hasSeparator() {
                return StringUtils.isNotBlank((String)this.separator);
            }

            public String operation() {
                return String.format(" %1s ", "NOT LIKE");
            }

            public Object value() {
                return "%" + value + "%";
            }
        };
    }

    public static Condition matchLike(Property<String> property, String match) {
        if (StringUtils.isNullOrEmpty((String)match)) {
            return null;
        }
        return property.like("%" + match + "%");
    }

    public static ConditionGroup matchLikeSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        ConditionGroup conditionGroup = ConditionGroup.clause();
        for (String string : set) {
            Condition condition = QueryBuilder.matchLike(property, string);
            if (condition == null) continue;
            conditionGroup.or((SQLCondition)condition);
        }
        return conditionGroup;
    }

    public static ConditionGroup matchEqualSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        ConditionGroup conditionGroup = ConditionGroup.clause();
        for (String string : set) {
            conditionGroup.or((SQLCondition)property.eq((Object)string));
        }
        return conditionGroup;
    }

    private static Condition getNullOrEqualCondition(Property<String> property, String compare) {
        return compare == null ? property.isNull() : property.eq((Object)compare);
    }

    private static Condition getNotNullOrEqualCondition(Property<String> property, String value) {
        return value == null ? property.isNotNull() : property.eq((Object)value);
    }

    private static Condition.In inCondition(Property property, Where in, boolean isIn) {
        return isIn ? property.in((BaseModelQueriable)in, new BaseModelQueriable[0]) : property.notIn((BaseModelQueriable)in, new BaseModelQueriable[0]);
    }

    public static QueryArgs generateQueryArgs(QueryArgs args) {
        switch (args.filter) {
            case ALL: {
                args.conditionGroup = QueryBuilder.orTypeCondition(args.fileType);
                break;
            }
            case NEW: {
                args.conditionGroup = QueryBuilder.newBookListCondition();
                break;
            }
            case READING: {
                args.conditionGroup = QueryBuilder.recentReadingCondition();
                break;
            }
            case FINISHED: {
                args.conditionGroup = QueryBuilder.finishReadCondition();
                break;
            }
            case TAG: {
                args.conditionGroup = QueryBuilder.orTagsCondition(args.tags);
                break;
            }
            case SEARCH: {
                args.conditionGroup = QueryBuilder.orSearchCondition(args.query);
            }
        }
        QueryBuilder.generateQueryArgsSortBy(args);
        QueryBuilder.generateCriteriaCondition(args);
        return args;
    }

    private static OrderBy ascDescOrder(OrderBy orderBy, boolean asc) {
        if (asc) {
            orderBy.ascending();
        } else {
            orderBy.descending();
        }
        return orderBy;
    }

    public static BaseProperty getPropertyFromSortBy(SortBy sortBy) {
        Object property = QueryBuilder.getMetadataNameProperty();
        switch (sortBy) {
            case None: 
            case Name: {
                break;
            }
            case FileType: {
                property = QueryBuilder.getMetadataTypeProperty();
                break;
            }
            case Size: {
                property = QueryBuilder.getMetadataSizeProperty();
                break;
            }
            case CreationTime: {
                property = QueryBuilder.getMetadataCreatedAtProperty();
                break;
            }
            case BookTitle: {
                property = QueryBuilder.getMetadataTitleProperty();
                break;
            }
            case Author: {
                property = QueryBuilder.getMetadataAuthorsProperty();
                break;
            }
            case Publisher: {
                property = QueryBuilder.getMetadataPublisherProperty();
                break;
            }
            case LastOpenTime: {
                property = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case RecentlyRead: {
                property = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Total: {
                property = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case StartTime: {
                property = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case InstallTime: {
                property = QueryBuilder.getMetadataLastAccessProperty();
            }
        }
        return property;
    }

    public static OrderBy generateOrderBy(SortBy sortBy, SortOrder order) {
        boolean asc = order == SortOrder.Asc;
        return QueryBuilder.ascDescOrder(OrderBy.fromProperty((IProperty)QueryBuilder.getPropertyFromSortBy(sortBy)), asc);
    }

    public static void generateQueryArgsSortBy(QueryArgs args) {
        args.orderByList.clear();
        args.orderByList.add(QueryBuilder.generateOrderBy(args.sortBy, args.order));
    }

    public static void generateCriteriaCondition(QueryArgs args) {
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataAuthorsProperty(), args.author));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTagsProperty(), args.tags));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataSeriesProperty(), args.series));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTitleProperty(), args.title));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTypeProperty(), args.fileType));
    }

    public static QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        Where whereCollection = new Select(new IProperty[]{QueryBuilder.getMetadataCollectionDocIdProperty().withTable()}).from(MetadataCollection.class).where(new SQLCondition[]{QueryBuilder.getNotNullOrEqualCondition((Property<String>)((Property)QueryBuilder.getMetadataCollectionLibraryIdProperty().withTable()), queryArgs.libraryUniqueId)});
        Condition.In inCondition = QueryBuilder.inCondition((Property)QueryBuilder.getMetadataIdStringProperty().withTable(), whereCollection, StringUtils.isNotBlank((String)queryArgs.libraryUniqueId));
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)inCondition);
        queryArgs.conditionGroup = queryArgs.conditionGroup.size() > 0 ? group.and((SQLCondition)queryArgs.conditionGroup) : group;
        return queryArgs;
    }
}

