/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.utils.FileUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FileSystemScanRequest
extends BaseFSRequest {
    private String storageId;
    private List<String> root;
    private HashSet<String> result;
    private volatile boolean overwrite;
    private Set<String> extensionFilterSet;

    public FileSystemScanRequest(String s, List<String> r, boolean overwriteSnapshot) {
        this.storageId = s;
        this.root = r;
        this.overwrite = overwriteSnapshot;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.result = new HashSet();
        for (String path : this.root) {
            FileUtils.collectFiles((String)path, this.extensionFilterSet, (boolean)true, this.result);
        }
        if (this.isOverwrite()) {
            dataManager.getFileSystemManager().clear(this.storageId);
            dataManager.getFileSystemManager().addAll(this.storageId, this.result, this.isOverwrite());
        }
    }

    public HashSet<String> getResult() {
        return this.result;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setExtensionFilterSet(Set<String> set) {
        this.extensionFilterSet = set;
    }
}

