/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import java.util.List;

public class FileAutoSuffixNameRequest
extends BaseDataRequest {
    private List<String> fileNames;
    private String fileName;
    private String fileNamePrefix;

    public FileAutoSuffixNameRequest(List<String> fileNames, String fileNamePrefix) {
        this.fileNames = fileNames;
        this.fileNamePrefix = fileNamePrefix;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.fileName = this.generateFileAutoSuffixName(this.fileNames);
    }

    public String getFileName() {
        return this.fileName;
    }

    private String generateFileAutoSuffixName(List<String> fileNames) {
        int size = fileNames.size();
        ++size;
        String fileName = this.fileNamePrefix;
        for (int i = 0; i < size; ++i) {
            String name = this.fileNamePrefix;
            if (i > 0) {
                name = name + i;
            }
            if (this.matchFileName(name, fileNames)) continue;
            fileName = name;
            break;
        }
        return fileName;
    }

    private boolean matchFileName(String matchName, List<String> fileNames) {
        for (String file : fileNames) {
            if (!file.equals(matchName)) continue;
            return true;
        }
        return false;
    }
}

