/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import com.onyx.android.sdk.data.AppDataInfo;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.utils.ApplicationUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApplicationListLoadRequest
extends BaseFSRequest {
    private List<String> ignoreAppList;
    private List<String> testAppList;
    private Map<String, String> customizedIconAppsMap;
    private List<AppDataInfo> appInfoList = new ArrayList<AppDataInfo>();
    private boolean testAppExist = false;

    public ApplicationListLoadRequest(List<String> ignoreAppList, List<String> testAppList, Map<String, String> customizedIconAppsMap) {
        this.ignoreAppList = ignoreAppList;
        this.testAppList = testAppList;
        this.customizedIconAppsMap = customizedIconAppsMap;
    }

    public List<AppDataInfo> getAppInfoList() {
        return this.appInfoList;
    }

    public boolean isTestAppExist() {
        return this.testAppExist;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.processLoadApplication();
    }

    private void processLoadApplication() throws Exception {
        Intent mainIntent = new Intent("android.intent.action.MAIN", null);
        mainIntent.addCategory("android.intent.category.LAUNCHER");
        List allInstalledPackageList = this.getContext().getPackageManager().getInstalledPackages(0);
        List apps = this.getContext().getPackageManager().queryIntentActivities(mainIntent, 0);
        for (PackageInfo packageInfo : allInstalledPackageList) {
            AppDataInfo appInfo;
            String packageName = packageInfo.applicationInfo.packageName;
            if (CollectionUtils.safelyContains(this.ignoreAppList, (String)packageName)) continue;
            if (CollectionUtils.safelyContains(this.testAppList, (String)packageName)) {
                if (ApplicationUtil.testAppRecordExist((Context)this.getContext(), (String)packageName)) continue;
                this.testAppExist = true;
                appInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (PackageInfo)packageInfo);
            } else {
                appInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (List)apps, (PackageInfo)packageInfo);
            }
            ApplicationUtil.checkCustomIcon((Context)this.getContext(), this.customizedIconAppsMap, (AppDataInfo)appInfo);
            if (appInfo == null) continue;
            this.appInfoList.add(appInfo);
        }
    }
}

