/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.utils.DatabaseUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.DatabaseHolder;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;

public class TransferDBRequest
extends BaseDataRequest {
    private String src;
    private String dst;
    private boolean restartDB = false;
    private boolean checkVersion = false;
    private Class<?> databaseClass;
    private Class<? extends DatabaseHolder> databaseHolderClass;

    public TransferDBRequest(String src, String dst, boolean restartDB, boolean checkVersion, Class<?> databaseClass, Class<? extends DatabaseHolder> databaseHolderClass) {
        this.src = src;
        this.dst = dst;
        this.restartDB = restartDB;
        this.checkVersion = checkVersion;
        this.databaseClass = databaseClass;
        this.databaseHolderClass = databaseHolderClass;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.src) || StringUtils.isNullOrEmpty((String)this.dst)) {
            return;
        }
        if (this.checkVersion && !DatabaseUtils.canRestoreDB((String)this.src, (String)this.dst)) {
            throw new Exception("Can not restore high version database");
        }
        this.beforeTransfer();
        FileUtils.transferFile((String)this.src, (String)this.dst);
        if (!FileUtils.compareFileMd5((String)this.src, (String)this.dst)) {
            throw new Exception("Md5 is not the same");
        }
        if (this.restartDB) {
            this.restartDB();
        }
    }

    private void beforeTransfer() {
        FileUtils.deleteFile((String)this.dst);
        FileUtils.ensureFileExists((String)this.dst);
        if (this.restartDB) {
            DatabaseDefinition databaseDefinition = FlowManager.getDatabase(this.databaseClass);
            databaseDefinition.getTransactionManager().stopQueue();
            databaseDefinition.getHelper().closeDB();
        }
    }

    private void restartDB() {
        if (this.databaseHolderClass == null) {
            return;
        }
        FlowManager.destroy();
        FlowConfig.Builder builder = new FlowConfig.Builder(this.getContext().getApplicationContext());
        builder.openDatabasesOnInit(true);
        builder.addDatabaseHolder(this.databaseHolderClass);
        FlowManager.init((FlowConfig)builder.build());
    }
}

