/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import android.content.Context;
import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MetadataRequest
extends BaseDBRequest {
    private HashSet<String> pathList = new HashSet();
    private List<Metadata> list = new ArrayList<Metadata>();
    private QueryArgs queryArgs;
    private long count;
    private boolean loadThumbnail = false;
    private Map<String, CloseableReference<Bitmap>> thumbnailBitmap = new HashMap<String, CloseableReference<Bitmap>>();

    public MetadataRequest(QueryArgs queryArgs) {
        this.queryArgs = queryArgs;
    }

    public MetadataRequest(QueryArgs queryArgs, boolean loadThumbnail) {
        this.queryArgs = queryArgs;
        this.loadThumbnail = loadThumbnail;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.count = dataManager.getRemoteContentProvider().count(this.getContext(), this.queryArgs);
        this.list.addAll(dataManager.getRemoteContentProvider().findMetadataByQueryArgs(this.getContext(), this.queryArgs));
        this.loadThumbnails(this.getContext(), dataManager);
        this.loadPathList();
    }

    private void loadThumbnails(Context context, DataManager dataManager) {
        if (this.loadThumbnail) {
            this.thumbnailBitmap = DataManagerHelper.loadThumbnailBitmapsWithCache(context, dataManager, this.list);
        }
    }

    private void loadPathList() {
        if (CollectionUtils.isNullOrEmpty(this.queryArgs.propertyList)) {
            return;
        }
        for (IProperty iProperty : this.queryArgs.propertyList) {
            if (!iProperty.getNameAlias().name().equals(Metadata_Table.nativeAbsolutePath.getNameAlias().name())) continue;
            for (Metadata metadata : this.list) {
                this.pathList.add(metadata.getNativeAbsolutePath());
            }
        }
    }

    public final List<Metadata> getList() {
        return this.list;
    }

    public long getCount() {
        return this.count;
    }

    public final HashSet<String> getPathList() {
        return this.pathList;
    }

    public final Map<String, CloseableReference<Bitmap>> getThumbnailBitmap() {
        return this.thumbnailBitmap;
    }
}

