/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.LibraryTableOfContentEntry;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.List;

public class LibraryTableOfContentLoadRequest
extends BaseDBRequest {
    private Library rootLibrary;
    private LibraryTableOfContentEntry tableOfContentEntry;

    public LibraryTableOfContentLoadRequest(Library rootLibrary) {
        this.rootLibrary = rootLibrary;
    }

    public LibraryTableOfContentEntry getLibraryTableOfContentEntry() {
        return this.tableOfContentEntry;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        String parentId = null;
        if (this.rootLibrary != null) {
            parentId = this.rootLibrary.getIdString();
        }
        this.tableOfContentEntry = new LibraryTableOfContentEntry();
        this.buildTableOfContentEntry(dataManager, parentId, this.tableOfContentEntry);
    }

    private void buildTableOfContentEntry(DataManager dataManager, String parentId, LibraryTableOfContentEntry toc) {
        List<Library> list = DataManagerHelper.loadLibraryListWithCache(this.getContext(), dataManager, parentId, false);
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (Library library : list) {
            LibraryTableOfContentEntry child = new LibraryTableOfContentEntry();
            child.library = library;
            toc.children.add(child);
            this.buildTableOfContentEntry(dataManager, library.getIdString(), child);
        }
    }
}

