/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import android.content.Context;
import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LibraryLoadRequest
extends BaseDBRequest {
    private boolean loadFromCache = true;
    private boolean loadMetadata = true;
    private QueryArgs queryArgs;
    private Map<String, CloseableReference<Bitmap>> thumbnailMap = new HashMap<String, CloseableReference<Bitmap>>();
    private List<Metadata> bookList = new ArrayList<Metadata>();
    private List<Library> libraryList = new ArrayList<Library>();
    private long totalCount;

    public LibraryLoadRequest(QueryArgs queryArgs) {
        this.queryArgs = queryArgs;
    }

    public LibraryLoadRequest(QueryArgs queryArgs, boolean loadMetadata) {
        this.queryArgs = queryArgs;
        this.loadMetadata = loadMetadata;
    }

    public void setLoadFromCache(boolean loadFromCache) {
        this.loadFromCache = loadFromCache;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        List<Library> tmpList = DataManagerHelper.loadLibraryListWithCache(this.getContext(), dataManager, this.queryArgs.libraryUniqueId, this.loadFromCache);
        if (!CollectionUtils.isNullOrEmpty(tmpList)) {
            this.libraryList.addAll(tmpList);
        }
        if (this.loadMetadata) {
            this.totalCount = dataManager.getRemoteContentProvider().count(this.getContext(), this.queryArgs);
            List<Metadata> metadataList = DataManagerHelper.loadMetadataListWithCache(this.getContext(), dataManager, this.queryArgs, this.loadFromCache);
            if (!CollectionUtils.isNullOrEmpty(metadataList)) {
                this.bookList.addAll(metadataList);
                this.loadBitmaps(this.getContext(), dataManager);
            }
        }
    }

    private void loadBitmaps(Context context, DataManager dataManager) {
        this.thumbnailMap = DataManagerHelper.loadThumbnailBitmapsWithCache(context, dataManager, this.bookList);
    }

    public List<Metadata> getBookList() {
        return this.bookList;
    }

    public List<Library> getLibraryList() {
        return this.libraryList;
    }

    public Map<String, CloseableReference<Bitmap>> getThumbnailMap() {
        return this.thumbnailMap;
    }

    public long getTotalCount() {
        return this.totalCount;
    }
}

