/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.data.utils.QueryBuilder;
import java.util.List;

public class LibraryBuildRequest
extends BaseDBRequest {
    private Library library;
    private QueryArgs criteria;
    private List<Metadata> bookList;

    public LibraryBuildRequest(Library library, QueryArgs queryCriteria) {
        this.library = library;
        this.criteria = queryCriteria;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        dataManager.getRemoteContentProvider().addLibrary(this.library);
        if (this.criteria == null || this.criteria.isAllSetContentEmpty()) {
            return;
        }
        this.criteria.libraryUniqueId = this.library.getParentUniqueId();
        QueryBuilder.generateCriteriaCondition(this.criteria);
        QueryBuilder.generateMetadataInQueryArgs(this.criteria);
        this.bookList = dataManager.getRemoteContentProvider().findMetadataByQueryArgs(this.getContext(), this.criteria);
        for (Metadata metadata : this.bookList) {
            MetadataCollection collection = DataManagerHelper.loadMetadataCollection(this.getContext(), dataManager, this.library.getParentUniqueId(), metadata.getIdString());
            if (collection == null) {
                collection = MetadataCollection.create(metadata.getIdString(), this.library.getIdString());
            }
            collection.setLibraryUniqueId(this.library.getIdString());
            if (collection.hasValidId()) {
                dataManager.getRemoteContentProvider().updateMetadataCollection(collection);
                continue;
            }
            dataManager.getRemoteContentProvider().addMetadataCollection(this.getContext(), collection);
        }
    }

    public List<Metadata> getBookList() {
        return this.bookList;
    }
}

