/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import android.os.Environment;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.ShellUtils;

public class CreateDBRequest
extends BaseDataRequest {
    private String exportCommand = "sqlite3 %s .schema > %s";
    private String importCommand = "sqlite3 %s < %s";
    private String currentDbPath;
    private String createDbPath;
    private String schemaFilePath;

    public CreateDBRequest(String currentDbPath, String createDbPath) {
        this.currentDbPath = currentDbPath;
        this.createDbPath = createDbPath;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.schemaFilePath = Environment.getExternalStorageDirectory().getPath() + "/" + "OnyxReader" + "/schema.sql";
        FileUtils.deleteFile((String)this.schemaFilePath);
        FileUtils.ensureFileExists((String)this.schemaFilePath);
        FileUtils.deleteFile((String)this.createDbPath);
        FileUtils.ensureFileExists((String)this.createDbPath);
        this.exportCommand = String.format(this.exportCommand, this.currentDbPath, this.schemaFilePath);
        this.importCommand = String.format(this.importCommand, this.createDbPath, this.schemaFilePath);
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand((boolean)false, (String[])new String[]{this.exportCommand, this.importCommand});
        if (commandResult.result != 0) {
            throw new Exception(commandResult.errorMsg);
        }
    }
}

