/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.common;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.common.ScreenSaverConfig;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.utils.BitmapUtils;

public class ScreenSaverRequest
extends BaseDataRequest {
    private ScreenSaverConfig config;

    public ScreenSaverRequest(ScreenSaverConfig saverConfig) {
        this.config = saverConfig;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.saveScreenFile(this.config);
    }

    private void saveScreenFile(ScreenSaverConfig config) throws Exception {
        int fullScreenPhysicalHeight = config.fullScreenPhysicalHeight;
        int fullScreenPhysicalWidth = config.fullScreenPhysicalWidth;
        Bitmap temp = BitmapFactory.decodeFile((String)config.sourcePicPathString).copy(Bitmap.Config.RGB_565, true);
        if (temp.getHeight() > temp.getWidth()) {
            temp = BitmapUtils.rotateBmp((Bitmap)temp, (int)config.picRotateDegrees);
        }
        if (temp.getWidth() != fullScreenPhysicalHeight || temp.getHeight() != fullScreenPhysicalWidth) {
            temp = Bitmap.createScaledBitmap((Bitmap)temp, (int)fullScreenPhysicalHeight, (int)fullScreenPhysicalWidth, (boolean)true);
        }
        if (config.convertToGrayScale) {
            temp = BitmapUtils.convertToBlackWhite((Bitmap)temp);
        }
        boolean success = false;
        if (config.targetFormat.contains("bmp")) {
            success = BitmapUtils.saveBitmapToFile((Bitmap)temp, (String)config.targetDir, (String)config.targetPicPathString, (boolean)true);
        } else if (config.targetFormat.contains("png")) {
            success = BitmapUtils.savePngToFile((Bitmap)temp, (String)config.targetDir, (String)config.targetPicPathString, (boolean)true);
        }
        if (success) {
            Log.i((String)"screenSaver", (String)"success");
            Intent intent = new Intent("update_standby_pic");
            this.getContext().sendBroadcast(intent);
        }
    }
}

