/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.net.Uri;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.v2.AuthToken;
import com.onyx.android.sdk.data.model.v2.BaseAuthAccount;
import com.onyx.android.sdk.data.model.v2.NeoAccountBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import com.onyx.android.sdk.utils.TestUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class LoginByHardwareInfoRequest<T extends NeoAccountBase>
extends BaseCloudRequest {
    private static final String TAG = "LoginByHardwareRequest";
    private static final String NAME_SECRET = "eefbb54a-ffd1-4e86-9513-f83e15b807c9";
    private static final String PASSWORD_SECRET = "807bb28a-623e-408c-97c5-61177091737b";
    private int localLoadRetryCount = 1;
    private boolean loadOnlyFromCloud = false;
    private Uri providerUri;
    private T account;
    private Class<T> clazzType;

    public LoginByHardwareInfoRequest(Uri providerUri, Class<T> clazz) {
        this.providerUri = providerUri;
        this.clazzType = clazz;
    }

    public T getAccount() {
        return this.account;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (this.loadOnlyFromCloud) {
            this.account = this.LoginToCloud(this.getContext(), parent);
            return;
        }
        this.account = this.LoginToLocal(parent, this.localLoadRetryCount);
        if (this.account == null) {
            this.account = this.LoginToCloud(this.getContext(), parent);
        } else {
            T updatedAccount = this.getAccountInfoFromCloud(parent, this.account);
            if (updatedAccount != null) {
                this.account = updatedAccount;
            }
        }
    }

    private T getAccountInfoFromCloud(CloudManager parent, T oldAccount) {
        BaseData cloudAccount = null;
        try {
            cloudAccount = (BaseData)((Object)this.getAccountInfoFromCloudImpl(parent, null));
            if (oldAccount != null) {
                ((NeoAccountBase)cloudAccount).token = ((NeoAccountBase)((Object)oldAccount)).token;
                ((NeoAccountBase)cloudAccount).tokenExpiresIn = ((NeoAccountBase)((Object)oldAccount)).tokenExpiresIn;
                cloudAccount.setCreatedAt(((BaseData)((Object)oldAccount)).getCreatedAt());
            }
            this.accountSaveToDb(cloudAccount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)((Object)cloudAccount);
    }

    private T LoginToLocal(CloudManager parent, int retryCount) {
        T account = null;
        for (int i = 0; i < retryCount && (account = (T)this.LoginToLocal(parent)) == null; ++i) {
            if (retryCount <= 1) continue;
            TestUtils.sleep((long)300L);
        }
        return account;
    }

    private T LoginToLocal(CloudManager parent) {
        NeoAccountBase account = null;
        try {
            account = (NeoAccountBase)ContentUtils.querySingle((Uri)this.providerUri, this.clazzType, (ConditionGroup)ConditionGroup.clause(), null, (String[])new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!NeoAccountBase.isValid(account) || account.isTokenTimeExpired()) {
            return null;
        }
        NeoAccountBase.parseName(account);
        parent.setToken(account.token);
        this.updateTokenHeader(parent);
        return (T)((Object)account);
    }

    private T LoginToCloud(Context context, CloudManager parent) throws Exception {
        AuthToken authToken = this.getAuthTokenFromCloud(context, parent);
        if (authToken == null || StringUtils.isNullOrEmpty((String)authToken.token)) {
            return null;
        }
        T account = this.getAccountInfoFromCloudImpl(parent, authToken);
        this.accountSaveToDb(account);
        return account;
    }

    private void accountSaveToDb(T account) {
        if (account == null) {
            return;
        }
        try {
            ((BaseData)((Object)account)).beforeSave();
            FlowManager.getContext().getContentResolver().delete(this.providerUri, null, null);
            ContentUtils.insert((Uri)this.providerUri, account);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AuthToken getAuthTokenFromCloud(Context context, CloudManager parent) throws Exception {
        BaseAuthAccount authAccount = LoginByHardwareInfoRequest.createAuthAccountFromHardware(context);
        if (authAccount == null) {
            return null;
        }
        AuthToken authToken = null;
        Response<AuthToken> response = this.executeCall(ServiceFactory.getContentService(parent.getCloudConf().getApiBase()).getAccountToken(authAccount));
        if (response.isSuccessful()) {
            authToken = (AuthToken)response.body();
            parent.setToken(authToken.token);
            this.updateTokenHeader(parent);
        }
        return authToken;
    }

    private T getAccountInfoFromCloudImpl(CloudManager parent, AuthToken authToken) throws Exception {
        NeoAccountBase account = null;
        Response<ResponseBody> response = this.executeCall(ServiceFactory.getContentService(parent.getCloudConf().getApiBase()).getAccount());
        if (response.isSuccessful()) {
            account = (NeoAccountBase)((Object)JSON.parseObject((String)((ResponseBody)response.body()).string(), this.clazzType));
            if (authToken != null) {
                account.token = authToken.token;
                account.tokenExpiresIn = authToken.expires_in;
            }
            NeoAccountBase.parseName(account);
        }
        return (T)((Object)account);
    }

    public static BaseAuthAccount createAuthAccountFromHardware(Context context) {
        String macAddress = NetworkUtil.getMacAddress((Context)context);
        if (StringUtils.isNullOrEmpty((String)macAddress)) {
            return null;
        }
        return BaseAuthAccount.create(FileUtils.computeMD5((String)(macAddress + NAME_SECRET)), FileUtils.computeMD5((String)(macAddress + PASSWORD_SECRET)));
    }

    private void updateTokenHeader(CloudManager cloudManager) {
        if (StringUtils.isNotBlank((String)cloudManager.getToken())) {
            ServiceFactory.addRetrofitTokenHeader(cloudManager.getCloudConf().getApiBase(), "authorization", "Bearer " + cloudManager.getToken());
        }
    }

    public void setLoadOnlyFromCloud(boolean loadOnlyFromCloud) {
        this.loadOnlyFromCloud = loadOnlyFromCloud;
    }

    public void setLocalLoadRetryCount(int retryCount) {
        this.localLoadRetryCount = retryCount <= 0 ? 1 : retryCount;
    }
}

